/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.item.functional.armor;

import com.cjm721.overloaded.Overloaded;
import com.cjm721.overloaded.capabilities.CapabilityGenericDataStorage;
import com.cjm721.overloaded.config.OverloadedConfig;
import com.cjm721.overloaded.item.functional.armor.IMultiArmor;
import com.cjm721.overloaded.item.functional.armor.ItemMultiHelmet;
import com.cjm721.overloaded.network.packets.KeyBindPressedMessage;
import com.cjm721.overloaded.proxy.ClientProxy;
import com.cjm721.overloaded.storage.GenericDataCapabilityProvider;
import com.cjm721.overloaded.storage.GenericDataStorage;
import com.cjm721.overloaded.storage.IGenericDataStorage;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.FoodStats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;

public class ArmorEventHandler {
    private static final UUID HEALTH_MODIFIER = UUID.fromString("def4cf44-4a8a-11ec-81d3-0242ac130003");
    private static final String set = "set";
    private static final String noClip = "noClip";
    private static final UUID groundSpeedAttribute = UUID.fromString("241a8bbe-1660-11eb-adc1-0242ac120002");

    @SubscribeEvent
    public void onAttachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PlayerEntity) {
            event.addCapability(new ResourceLocation("overloaded", "player_data"), (ICapabilityProvider)new GenericDataCapabilityProvider());
        }
    }

    @SubscribeEvent
    public void onPlayerTickEvent(@Nonnull TickEvent.PlayerTickEvent event) {
        PlayerEntity player = event.player;
        if (player == null || player.field_70729_aU) {
            return;
        }
        IGenericDataStorage playerDataStorage = ArmorEventHandler.getPlayerDataStorage(player);
        if (this.isMultiArmorSetEquipped(player) && this.hasEnergy(player)) {
            IGenericDataStorage armorDataStorage = ArmorEventHandler.getHelmetDataStorage(player);
            Map<String, Boolean> armorBooleans = armorDataStorage.getBooleanMap();
            playerDataStorage.getBooleanMap().put(set, true);
            AttributeModifier modifier = player.func_110148_a(Attributes.field_233818_a_).func_111127_a(HEALTH_MODIFIER);
            if (modifier == null) {
                player.func_110148_a(Attributes.field_233818_a_).func_233767_b_(new AttributeModifier(HEALTH_MODIFIER, "Max Health", 100.0, AttributeModifier.Operation.ADDITION));
            }
            if (armorBooleans.getOrDefault("flight", true).booleanValue()) {
                this.tryEnableFlight(player, playerDataStorage, armorDataStorage, event.side);
            } else {
                this.disableFlight(player, event.side);
            }
            if (armorBooleans.getOrDefault("feed", true).booleanValue()) {
                this.tryFeedPlayer(player, event.side);
            }
            if (armorBooleans.getOrDefault("heal", true).booleanValue()) {
                this.tryHealPlayer(player, event.side);
            }
            if (armorBooleans.getOrDefault("remove_harmful", true).booleanValue()) {
                this.tryRemoveHarmful(player, event.side);
            }
            if (armorBooleans.getOrDefault("extinguish", true).booleanValue()) {
                this.tryExtinguish(player, event.side);
            }
            if (armorBooleans.getOrDefault("give_air", true).booleanValue()) {
                this.tryGiveAir(player, event.side);
            }
            this.tryGroundSpeed(player, armorDataStorage, event.side);
        } else {
            Map<String, Boolean> boolMap = playerDataStorage.getBooleanMap();
            if (boolMap.containsKey(set) && boolMap.get(set).booleanValue()) {
                boolMap.put(set, false);
                this.disableFlight(player, event.side);
                this.disableNoClip(player, playerDataStorage);
                this.disableGroundSpeed(player, event.side);
                player.func_110148_a(Attributes.field_233818_a_).func_188479_b(HEALTH_MODIFIER);
                player.func_70606_j(Math.min(player.func_110143_aJ(), player.func_110138_aP()));
            }
        }
    }

    private void tryGroundSpeed(PlayerEntity player, IGenericDataStorage armorDataStorage, LogicalSide side) {
        float groundSpeed = armorDataStorage.getFloatMap().getOrDefault("ground_speed", Float.valueOf(0.2f)).floatValue();
        float powerRequired = (float)((double)((player.field_70140_Q - player.field_70141_P) / 0.6f) * OverloadedConfig.INSTANCE.multiArmorConfig.energyPerBlockWalked * OverloadedConfig.INSTANCE.multiArmorConfig.energyMultiplierPerGroundSpeed * (double)(groundSpeed - 0.2f));
        if (this.extractEnergy(player, Math.round(powerRequired), side == LogicalSide.CLIENT)) {
            AttributeModifier modifier = new AttributeModifier(groundSpeedAttribute, "Ground Speed modifier", (double)groundSpeed, AttributeModifier.Operation.ADDITION);
            if (!player.func_110148_a(Attributes.field_233821_d_).func_180374_a(modifier)) {
                player.func_110148_a(Attributes.field_233821_d_).func_233767_b_(modifier);
            }
        } else {
            this.disableGroundSpeed(player, side);
        }
    }

    private void disableGroundSpeed(PlayerEntity player, LogicalSide side) {
        player.func_110148_a(Attributes.field_233821_d_).func_188479_b(groundSpeedAttribute);
    }

    private void disableNoClip(PlayerEntity player, IGenericDataStorage dataStorage) {
        player.field_70145_X = false;
        dataStorage.getBooleanMap().put(noClip, false);
    }

    private void tryEnableNoClip(PlayerEntity player, IGenericDataStorage dataStorage, IGenericDataStorage helmetDataStorage, LogicalSide side) {
        Map<String, Boolean> playerBooleans = dataStorage.getBooleanMap();
        Map<String, Boolean> armorBooleans = helmetDataStorage.getBooleanMap();
        if (playerBooleans.containsKey(set) && playerBooleans.get(set).booleanValue() && playerBooleans.containsKey(noClip) && playerBooleans.get(noClip).booleanValue()) {
            if (this.extractEnergy(player, OverloadedConfig.INSTANCE.multiArmorConfig.noClipEnergyPerTick, side == LogicalSide.CLIENT)) {
                player.field_70145_X = true;
                if (armorBooleans.getOrDefault("noclip_flight_lock", true).booleanValue()) {
                    this.tryEnableFlight(player, dataStorage, helmetDataStorage, side);
                    player.field_71075_bZ.field_75100_b = true;
                }
            } else {
                this.disableNoClip(player, dataStorage);
            }
        }
    }

    private void tryGiveAir(PlayerEntity player, LogicalSide side) {
        int airNeeded = 300 - player.func_70086_ai();
        if (airNeeded > 0 && this.extractEnergy(player, airNeeded * OverloadedConfig.INSTANCE.multiArmorConfig.costPerAir, side == LogicalSide.CLIENT)) {
            player.func_70050_g(300);
        }
    }

    private void tryExtinguish(@Nonnull PlayerEntity player, @Nonnull LogicalSide side) {
        if (player.func_70027_ad() && this.extractEnergy(player, OverloadedConfig.INSTANCE.multiArmorConfig.extinguishCost, side == LogicalSide.CLIENT)) {
            player.func_70066_B();
        }
    }

    private void tryHealPlayer(@Nonnull PlayerEntity player, @Nonnull LogicalSide side) {
        float currentHealth = player.func_110143_aJ();
        float maxHealth = player.func_110138_aP();
        int toHeal = (int)Math.ceil(maxHealth - currentHealth);
        if (toHeal > 0 && this.extractEnergy(player, OverloadedConfig.INSTANCE.multiArmorConfig.costPerHealth * toHeal, side == LogicalSide.CLIENT)) {
            player.func_70691_i((float)toHeal);
        }
    }

    private void tryRemoveHarmful(@Nonnull PlayerEntity player, @Nonnull LogicalSide side) {
        Iterator potionEffectIterator = player.func_70651_bq().iterator();
        while (potionEffectIterator.hasNext()) {
            EffectInstance effect = (EffectInstance)potionEffectIterator.next();
            Effect potion = effect.func_188419_a();
            if (potion.func_188408_i() || !this.extractEnergy(player, OverloadedConfig.INSTANCE.multiArmorConfig.removeEffect, true) || !this.extractEnergy(player, OverloadedConfig.INSTANCE.multiArmorConfig.removeEffect, side == LogicalSide.CLIENT) || MinecraftForge.EVENT_BUS.post((Event)new PotionEvent.PotionRemoveEvent((LivingEntity)player, potion))) continue;
            potionEffectIterator.remove();
        }
    }

    private void tryFeedPlayer(@Nonnull PlayerEntity player, @Nonnull LogicalSide side) {
        FoodStats foodStats = player.func_71024_bL();
        int foodLevel = foodStats.func_75116_a();
        int toFeed = OverloadedConfig.INSTANCE.multiArmorConfig.maxFoodLevel - foodLevel;
        float saturationLevel = foodStats.func_75115_e();
        float toAdd = (float)OverloadedConfig.INSTANCE.multiArmorConfig.maxFoodLevel - saturationLevel;
        if (toFeed > 0 && this.extractEnergy(player, Math.round(OverloadedConfig.INSTANCE.multiArmorConfig.costPerFood * toFeed), side == LogicalSide.CLIENT)) {
            foodStats.func_75122_a(toFeed, 0.0f);
        }
        if (toAdd > 0.0f && this.extractEnergy(player, (int)Math.round(OverloadedConfig.INSTANCE.multiArmorConfig.costPerSaturation * (double)toAdd), side == LogicalSide.CLIENT)) {
            toFeed = Math.round(toAdd);
            foodStats.func_75122_a(toFeed, 0.5f);
        }
    }

    private void tryEnableFlight(@Nonnull PlayerEntity player, @Nonnull IGenericDataStorage dataStorage, IGenericDataStorage armorDataStorage, @Nonnull LogicalSide side) {
        Map<String, Boolean> booleans = dataStorage.getBooleanMap();
        Map<String, Float> armorFloats = armorDataStorage.getFloatMap();
        float flightSpeed = armorFloats.getOrDefault("flight_speed", Float.valueOf(0.1f)).floatValue();
        player.field_71075_bZ.field_75101_c = true;
        if (side == LogicalSide.CLIENT) {
            player.field_71075_bZ.func_195931_a(armorFloats.getOrDefault("flight_speed", Float.valueOf(0.1f)).floatValue());
        }
        booleans.put(set, true);
        int energyCost = (int)Math.round((double)((float)OverloadedConfig.INSTANCE.multiArmorConfig.energyPerTickFlying * flightSpeed) * OverloadedConfig.INSTANCE.multiArmorConfig.energyMultiplierPerFlightSpeed);
        if (player.field_71075_bZ.field_75100_b && !this.extractEnergy(player, energyCost, side == LogicalSide.CLIENT)) {
            this.disableFlight(player, side);
        }
    }

    private void disableFlight(@Nonnull PlayerEntity player, @Nonnull LogicalSide side) {
        player.field_71075_bZ.field_75101_c = false;
        player.field_71075_bZ.field_75100_b = false;
        if (side == LogicalSide.CLIENT) {
            player.field_71075_bZ.func_195931_a(0.05f);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingAttackedEvent(LivingAttackEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        boolean setEquipped = this.isMultiArmorSetEquipped(player);
        if (setEquipped) {
            DamageSource damageSource = event.getSource();
            int energyCost = OverloadedConfig.INSTANCE.multiArmorConfig.baseCost;
            float damageAmount = (float)((double)event.getAmount() * OverloadedConfig.INSTANCE.multiArmorConfig.damageMultiplier);
            if (damageSource.func_151517_h()) {
                damageAmount = (float)((double)damageAmount * OverloadedConfig.INSTANCE.multiArmorConfig.absoluteDamageMultiplier);
            }
            if (damageSource.func_76363_c()) {
                damageAmount = (float)((double)damageAmount * OverloadedConfig.INSTANCE.multiArmorConfig.unblockableMultiplier);
            }
            if (damageAmount > 2.1474836E9f) {
                return;
            }
            if ((energyCost = (int)((float)energyCost + damageAmount)) < 0) {
                return;
            }
            if (this.extractEnergy(player, energyCost, false)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof PlayerEntity && this.isMultiArmorSetEquipped((PlayerEntity)entity)) {
            PlayerEntity player = (PlayerEntity)entity;
            this.tryEnableNoClip(player, ArmorEventHandler.getPlayerDataStorage(player), ArmorEventHandler.getHelmetDataStorage(player), LogicalSide.SERVER);
        }
    }

    private boolean hasEnergy(PlayerEntity player) {
        for (ItemStack stack : player.func_184193_aE()) {
            if (!stack.getCapability(CapabilityEnergy.ENERGY).map(e -> e.getEnergyStored() > 0).orElse(false).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private boolean extractEnergy(PlayerEntity player, int energyCost, boolean simulated) {
        LazyOptional opEnergyStorage;
        if (energyCost <= 0) {
            return true;
        }
        int originalCost = energyCost;
        for (ItemStack stack : player.func_184193_aE()) {
            opEnergyStorage = stack.getCapability(CapabilityEnergy.ENERGY);
            if ((energyCost -= opEnergyStorage.map(e -> e.extractEnergy(originalCost / 4, simulated)).orElse(0).intValue()) > 0) continue;
            return true;
        }
        for (ItemStack stack : player.func_184193_aE()) {
            int extractAmount;
            opEnergyStorage = stack.getCapability(CapabilityEnergy.ENERGY);
            if ((energyCost -= opEnergyStorage.map(arg_0 -> ArmorEventHandler.lambda$extractEnergy$2(extractAmount = energyCost, simulated, arg_0)).orElse(0).intValue()) > 0) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    private static IGenericDataStorage getPlayerDataStorage(PlayerEntity player) {
        return (IGenericDataStorage)player.getCapability(CapabilityGenericDataStorage.GENERIC_DATA_STORAGE).orElse((Object)new GenericDataStorage());
    }

    @Nonnull
    private static IGenericDataStorage getHelmetDataStorage(PlayerEntity player) {
        for (ItemStack stack : player.field_71071_by.field_70460_b) {
            if (!(stack.func_77973_b() instanceof ItemMultiHelmet)) continue;
            IGenericDataStorage cap = (IGenericDataStorage)stack.getCapability(CapabilityGenericDataStorage.GENERIC_DATA_STORAGE).orElse((Object)new GenericDataStorage());
            cap.suggestUpdate();
            return cap;
        }
        return new GenericDataStorage();
    }

    private boolean isMultiArmorSetEquipped(PlayerEntity player) {
        for (ItemStack stack : player.field_71071_by.field_70460_b) {
            if (stack.func_77973_b() instanceof IMultiArmor) continue;
            return false;
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onKeyInputEvent(InputEvent.KeyInputEvent event) {
        if (((ClientProxy)Overloaded.proxy).noClipKeybind.func_151468_f() && this.isMultiArmorSetEquipped((PlayerEntity)Minecraft.func_71410_x().field_71439_g)) {
            Overloaded.proxy.networkWrapper.sendToServer((Object)new KeyBindPressedMessage(KeyBindPressedMessage.KeyBind.NO_CLIP));
        }
    }

    public static boolean toggleNoClip(ServerPlayerEntity player) {
        IGenericDataStorage storage = ArmorEventHandler.getPlayerDataStorage((PlayerEntity)player);
        Map<String, Boolean> booleans = storage.getBooleanMap();
        if (booleans.containsKey(noClip) && booleans.get(noClip).booleanValue()) {
            booleans.remove(noClip);
            return false;
        }
        booleans.put(noClip, true);
        return true;
    }

    public static void setNoClip(PlayerEntity player, boolean enabled) {
        IGenericDataStorage storage = ArmorEventHandler.getPlayerDataStorage(player);
        Map<String, Boolean> booleans = storage.getBooleanMap();
        booleans.put(noClip, enabled);
    }

    private static /* synthetic */ Integer lambda$extractEnergy$2(int extractAmount, boolean simulated, IEnergyStorage e) {
        return e.extractEnergy(extractAmount, simulated);
    }
}

