/*
 * Decompiled with CFR 0.152.
 */
package me.andre111.mambience.sound;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import me.andre111.mambience.MALogger;
import me.andre111.mambience.accessor.Accessor;
import me.andre111.mambience.sound.Sound;

public class SoundPlayer {
    private final Accessor accessor;
    private final MALogger logger;
    private final List<ScheduledSound> scheduledSounds = new LinkedList<ScheduledSound>();

    public SoundPlayer(Accessor accessor, MALogger logger) {
        this.accessor = accessor;
        this.logger = logger;
    }

    public void update() {
        long time = System.currentTimeMillis();
        Iterator<ScheduledSound> iter = this.scheduledSounds.iterator();
        while (iter.hasNext()) {
            ScheduledSound sound = iter.next();
            if (time - sound.startTime < (long)sound.delay) continue;
            this.logger.log("Play Delayed " + sound.name);
            if (sound.global) {
                this.accessor.playGlobalFootstepSound(sound.name, sound.x, sound.y, sound.z, sound.volume, sound.pitch);
            } else {
                this.accessor.playSound(sound.name, sound.x, sound.y, sound.z, sound.volume, sound.pitch);
            }
            iter.remove();
        }
    }

    public void playSound(Sound sound, double x, double y, double z, boolean global) {
        if (sound.getProbability() < 1.0 && Math.random() >= sound.getProbability()) {
            return;
        }
        float volume = sound.getVolume();
        float pitch = sound.getPitch();
        if (sound.getDelay() > 0) {
            this.scheduledSounds.add(new ScheduledSound(sound.getName(), x, y, z, volume, pitch, global, sound.getDelay()));
        } else {
            this.logger.log("Play " + sound.getName());
            if (global) {
                this.accessor.playGlobalFootstepSound(sound.getName(), x, y, z, volume, pitch);
            } else {
                this.accessor.playSound(sound.getName(), x, y, z, volume, pitch);
            }
        }
    }

    private static final class ScheduledSound {
        private final String name;
        private final double x;
        private final double y;
        private final double z;
        private final float volume;
        private final float pitch;
        private final boolean global;
        private final int delay;
        private final long startTime;

        public ScheduledSound(String name, double x, double y, double z, float volume, float pitch, boolean global, int delay) {
            this.name = name;
            this.x = x;
            this.y = y;
            this.z = z;
            this.volume = volume;
            this.pitch = pitch;
            this.global = global;
            this.delay = delay;
            this.startTime = System.currentTimeMillis();
        }
    }
}

