/*
 * Decompiled with CFR 0.152.
 */
package me.andre111.mambience.effect;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import me.andre111.mambience.MAPlayer;
import me.andre111.mambience.accessor.Accessor;
import me.andre111.mambience.config.Config;
import me.andre111.mambience.effect.Effect;
import me.andre111.mambience.effect.EffectInstance;

public class Effects {
    private static Random random = new Random();
    private static Set<Effect> effects = new HashSet<Effect>();
    private static List<EffectInstance> instances = new ArrayList<EffectInstance>();

    public static void reset() {
        effects.clear();
    }

    public static void addEffect(Effect effect) {
        effects.add(effect);
    }

    public static void tick() {
        Iterator<EffectInstance> iter = instances.iterator();
        while (iter.hasNext()) {
            EffectInstance instance = iter.next();
            instance.tick();
            if (instance.isAlive()) continue;
            iter.remove();
        }
    }

    public static void update(MAPlayer player) {
        Accessor accessor = player.getAccessor();
        int bx = (int)accessor.getX();
        int by = (int)accessor.getY();
        int bz = (int)accessor.getZ();
        for (int i = 0; i < Config.effects().getRandomTicks(); ++i) {
            int ox = random.nextInt(Config.effects().getSizeX() + 1) - Config.effects().getSizeX() / 2;
            int oy = random.nextInt(Config.effects().getSizeY() + 1) - Config.effects().getSizeY() / 2;
            int oz = random.nextInt(Config.effects().getSizeZ() + 1) - Config.effects().getSizeZ() / 2;
            String block = player.getAccessor().getBlock(bx + ox, by + oy, bz + oz);
            for (Effect effect : effects) {
                effect.update(player, block, bx + ox, by + oy, bz + oz);
            }
        }
    }

    public static void addInstance(EffectInstance instance) {
        instances.add(instance);
    }
}

