/*
 * Decompiled with CFR 0.152.
 */
package me.andre111.mambience.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.HashMap;
import java.util.Map;
import me.andre111.mambience.MALogger;
import me.andre111.mambience.config.CommentSkippingReader;
import me.andre111.mambience.config.Config;
import me.andre111.mambience.config.ConfigUtil;
import me.andre111.mambience.footstep.FSMaterial;
import me.andre111.mambience.sound.Sound;

public final class FootstepLoader {
    public static final Map<String, String> BLOCK_MAP = new HashMap<String, String>();
    public static final Map<String, String> ARMOR_MAP = new HashMap<String, String>();
    public static final Map<String, FSMaterial> MATERIALS = new HashMap<String, FSMaterial>();

    public static void loadFootsteps(MALogger logger, File file) {
        try (CommentSkippingReader reader = new CommentSkippingReader(new BufferedReader(new FileReader(file)));){
            JsonParser parser = new JsonParser();
            JsonObject footstepElement = parser.parse(reader.readAllLines("\n")).getAsJsonObject();
            BLOCK_MAP.clear();
            ARMOR_MAP.clear();
            MATERIALS.clear();
            JsonObject blockMapElement = footstepElement.get("blocks").getAsJsonObject();
            for (Object e : blockMapElement.entrySet()) {
                BLOCK_MAP.put((String)e.getKey(), ((JsonElement)e.getValue()).getAsString());
            }
            JsonObject armorMapElement = footstepElement.get("armor").getAsJsonObject();
            for (Map.Entry e : armorMapElement.entrySet()) {
                ARMOR_MAP.put((String)e.getKey(), ((JsonElement)e.getValue()).getAsString());
            }
            JsonObject materialsElement = footstepElement.get("materials").getAsJsonObject();
            for (Map.Entry e : materialsElement.entrySet()) {
                MATERIALS.put((String)e.getKey(), FootstepLoader.loadMaterial(((JsonElement)e.getValue()).getAsJsonObject()));
            }
        }
        catch (Exception e) {
            logger.error("Exception loading footsteps: " + file.getAbsolutePath() + ": " + e);
            e.printStackTrace();
        }
    }

    private static FSMaterial loadMaterial(JsonObject object) {
        Sound[] wanderSounds = ConfigUtil.loadSounds(object.get("wander"), Config.footsteps().getVolume());
        Sound[] walkSounds = ConfigUtil.loadSounds(object.get("walk"), Config.footsteps().getVolume());
        Sound[] runSounds = ConfigUtil.loadSounds(object.get("run"), Config.footsteps().getVolume());
        Sound[] jumpSounds = ConfigUtil.loadSounds(object.get("jump"), Config.footsteps().getVolume());
        Sound[] landSounds = ConfigUtil.loadSounds(object.get("land"), Config.footsteps().getVolume());
        return new FSMaterial(wanderSounds, walkSounds, runSounds, jumpSounds, landSounds);
    }
}

