/*
 * Decompiled with CFR 0.152.
 */
package me.andre111.mambience.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.andre111.mambience.MALogger;
import me.andre111.mambience.ambient.AmbientEvent;
import me.andre111.mambience.condition.Condition;
import me.andre111.mambience.config.CommentSkippingReader;
import me.andre111.mambience.config.Config;
import me.andre111.mambience.config.ConfigUtil;
import me.andre111.mambience.sound.Sound;

public final class EventLoader {
    public static final Set<AmbientEvent> EVENTS = new HashSet<AmbientEvent>();

    public static void loadEvents(MALogger logger, File file) {
        try (CommentSkippingReader reader = new CommentSkippingReader(new BufferedReader(new FileReader(file)));){
            JsonParser parser = new JsonParser();
            JsonArray soundElement = parser.parse(reader.readAllLines("\n")).getAsJsonArray();
            EVENTS.clear();
            for (int i = 0; i < soundElement.size(); ++i) {
                AmbientEvent sound = EventLoader.loadEvent(logger, i, soundElement.get(i).getAsJsonObject());
                EVENTS.add(sound);
            }
        }
        catch (Exception e) {
            logger.error("Exception loading sounds: " + file.getAbsolutePath() + ": " + e);
            e.printStackTrace();
        }
    }

    private static AmbientEvent loadEvent(MALogger logger, int index, JsonObject obj) {
        String id = Integer.toString(index);
        Sound[] sounds = ConfigUtil.loadSounds(obj.get("sound"), Config.ambientEvents().getVolume());
        List<Condition> conditions = ConfigUtil.loadConditions(logger, obj.get("conditions").getAsJsonArray());
        List<Condition> restrictions = ConfigUtil.loadConditions(logger, obj.get("restrictions").getAsJsonArray());
        int cooldownMin = ConfigUtil.getInt(obj, "cooldownMin", 1);
        int cooldownMax = ConfigUtil.getInt(obj, "cooldownMax", 1);
        return new AmbientEvent(id, sounds, conditions, restrictions, cooldownMin, cooldownMax);
    }
}

