/*
 * Decompiled with CFR 0.152.
 */
package me.andre111.mambience.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.andre111.mambience.MALogger;
import me.andre111.mambience.config.CommentSkippingReader;

public final class DataLoader {
    private static Map<String, List<String>> BIOME_GROUPS;
    private static Map<String, List<String>> BLOCK_TAGS;

    public static void loadData(MALogger logger, File file) {
        try (CommentSkippingReader reader = new CommentSkippingReader(new BufferedReader(new FileReader(file)));){
            JsonParser parser = new JsonParser();
            JsonObject dataElement = parser.parse(reader.readAllLines("\n")).getAsJsonObject();
            DataLoader.loadBiomeGroups(logger, dataElement.get("biomeGroups").getAsJsonArray());
            DataLoader.loadBlockTags(logger, dataElement.get("tags").getAsJsonArray());
        }
        catch (Exception e) {
            logger.error("Exception loading data: " + file.getAbsolutePath() + ": " + e);
            e.printStackTrace();
        }
    }

    private static void loadBiomeGroups(MALogger logger, JsonArray array) {
        BIOME_GROUPS = new HashMap<String, List<String>>();
        for (int i = 0; i < array.size(); ++i) {
            JsonObject obj = array.get(i).getAsJsonObject();
            String name = obj.get("name").getAsString();
            ArrayList<String> biomes = new ArrayList<String>();
            JsonArray biomeArray = obj.get("biomes").getAsJsonArray();
            for (int j = 0; j < biomeArray.size(); ++j) {
                biomes.add(DataLoader.namespaced(biomeArray.get(j).getAsString()));
            }
            BIOME_GROUPS.put(name, biomes);
        }
    }

    private static void loadBlockTags(MALogger logger, JsonArray array) {
        BLOCK_TAGS = new HashMap<String, List<String>>();
        for (int i = 0; i < array.size(); ++i) {
            JsonObject obj = array.get(i).getAsJsonObject();
            if (!obj.get("type").getAsString().equals("BLOCKS") || obj.has("dpOnly") && obj.get("dpOnly").getAsBoolean()) continue;
            String name = "#andre111:mambience/" + obj.get("name").getAsString();
            ArrayList<String> blocks = new ArrayList<String>();
            JsonArray blocksArray = obj.get("values").getAsJsonArray();
            for (int j = 0; j < blocksArray.size(); ++j) {
                Object value = blocksArray.get(j).getAsString();
                if (((String)value).startsWith("#")) {
                    if (((String)value).startsWith("#minecraft:")) {
                        value = "#andre111:mambience/" + ((String)value).substring("#minecraft:".length());
                    }
                    if (!BLOCK_TAGS.containsKey(value)) {
                        throw new RuntimeException("Unknown tag " + (String)value + " when loading tag " + name);
                    }
                    blocks.addAll((Collection)BLOCK_TAGS.get(value));
                    continue;
                }
                blocks.add(DataLoader.namespaced((String)value));
            }
            BLOCK_TAGS.put(name, blocks);
        }
    }

    public static List<String> getBiomeGroup(String name) {
        return BIOME_GROUPS.get(name);
    }

    public static List<String> getBlockTag(String name) {
        return BLOCK_TAGS.get(name);
    }

    public static String namespaced(String name) {
        return name.contains(":") ? name : "minecraft:" + name;
    }
}

