/*
 * Decompiled with CFR 0.152.
 */
package me.andre111.mambience.config;

import com.google.gson.Gson;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import me.andre111.mambience.MALogger;
import me.andre111.mambience.config.CommentSkippingReader;
import me.andre111.mambience.config.DataLoader;
import me.andre111.mambience.config.EffectLoader;
import me.andre111.mambience.config.EventLoader;
import me.andre111.mambience.config.FootstepLoader;

public final class Config {
    private static final int VERSION = 2;
    private static Config instance = null;
    private static File configRoot = null;
    private int version = 2;
    private boolean debugLogging = false;
    private ScannerConfig scanner = new ScannerConfig();
    private AmbientEventsConfig ambientEvents = new AmbientEventsConfig();
    private EffectsConfig effects = new EffectsConfig();
    private FootstepConfig footsteps = new FootstepConfig();

    public static boolean debugLogging() {
        return Config.instance.debugLogging;
    }

    public static void setDebugLogging(boolean debugLogging) {
        Config.instance.debugLogging = debugLogging;
    }

    public static ScannerConfig scanner() {
        return Config.instance.scanner;
    }

    public static AmbientEventsConfig ambientEvents() {
        return Config.instance.ambientEvents;
    }

    public static EffectsConfig effects() {
        return Config.instance.effects;
    }

    public static FootstepConfig footsteps() {
        return Config.instance.footsteps;
    }

    public static void initialize(MALogger logger, File configRoot) {
        if (instance != null) {
            return;
        }
        Config.configRoot = configRoot;
        try {
            instance = new Config();
            boolean update = true;
            if (!configRoot.exists()) {
                configRoot.mkdir();
            }
            File configFile = new File(configRoot, "/config.json");
            Config existingConfig = Config.load();
            if (existingConfig != null && existingConfig.version >= 2) {
                instance = existingConfig;
                update = false;
            }
            if (update) {
                logger.error("Creating or updating config and settings, backups will be created...");
                if (configFile.exists()) {
                    Files.copy(configFile.toPath(), new File(configRoot, "/config.json_backup").toPath(), StandardCopyOption.REPLACE_EXISTING);
                } else {
                    configFile.createNewFile();
                }
                Config.save();
            }
            Config.exportSettings(configRoot, update);
            Config.reloadData(logger);
        }
        catch (Exception e) {
            logger.error("Exception reading settings: " + e);
            e.printStackTrace();
        }
    }

    public static Config load() throws IOException {
        File configFile = new File(configRoot, "/config.json");
        if (configFile.exists()) {
            try (CommentSkippingReader reader = new CommentSkippingReader(new BufferedReader(new FileReader(configFile)));){
                Config config = (Config)new Gson().fromJson(reader.readAllLines("\n"), Config.class);
                return config;
            }
        }
        return null;
    }

    public static void save() throws IOException {
        File configFile = new File(configRoot, "/config.json");
        try (JsonWriter writer = new JsonWriter((Writer)new BufferedWriter(new FileWriter(configFile)));){
            writer.setIndent("    ");
            new Gson().toJson((Object)instance, Config.class, writer);
        }
    }

    public static void reloadData(MALogger logger) {
        DataLoader.loadData(logger, new File(configRoot, "/settings/data.json"));
        EventLoader.loadEvents(logger, new File(configRoot, "/settings/events.json"));
        EffectLoader.loadEffects(logger, new File(configRoot, "/settings/effects.json"));
        FootstepLoader.loadFootsteps(logger, new File(configRoot, "/settings/footsteps.json"));
    }

    private static void exportSettings(File folder, boolean update) {
        Config.exportSingleFile(folder, "/settings/data.json", update);
        Config.exportSingleFile(folder, "/settings/events.json", update);
        Config.exportSingleFile(folder, "/settings/effects.json", update);
        Config.exportSingleFile(folder, "/settings/footsteps.json", update);
    }

    private static void exportSingleFile(File folder, String path, boolean update) {
        File file = new File(folder, path);
        if (!file.exists() || update) {
            try {
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                if (file.exists()) {
                    Files.copy(file.toPath(), new File(folder, path + "_backup").toPath(), StandardCopyOption.REPLACE_EXISTING);
                } else {
                    file.createNewFile();
                }
                Files.copy(Config.class.getResourceAsStream(path), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static class ScannerConfig {
        public static final int DEFAULT_SIZE_X = 11;
        public static final int DEFAULT_SIZE_Y = 9;
        public static final int DEFAULT_SIZE_Z = 11;
        public static final int DEFAULT_INTERVAL = 20;
        private int sizeX = 11;
        private int sizeY = 9;
        private int sizeZ = 11;
        private int interval = 20;

        public int getSizeX() {
            return this.sizeX;
        }

        public void setSizeX(int sizeX) {
            this.sizeX = sizeX;
        }

        public int getSizeY() {
            return this.sizeY;
        }

        public void setSizeY(int sizeY) {
            this.sizeY = sizeY;
        }

        public int getSizeZ() {
            return this.sizeZ;
        }

        public void setSizeZ(int sizeZ) {
            this.sizeZ = sizeZ;
        }

        public int getInterval() {
            return this.interval;
        }

        public void setInterval(int interval) {
            this.interval = interval;
        }
    }

    public static class AmbientEventsConfig {
        public static final boolean DEFAULT_ENABLED = true;
        public static final float DEFAULT_VOLUME = 0.5f;
        public static final boolean DEFAULT_STOP_SOUNDS = false;
        private boolean enabled = true;
        private float volume = 0.5f;
        private boolean stopSounds = false;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public float getVolume() {
            return this.volume;
        }

        public void setVolume(float volume) {
            this.volume = volume;
        }

        public boolean isStopSounds() {
            return this.stopSounds;
        }

        public void setStopSounds(boolean stopSounds) {
            this.stopSounds = stopSounds;
        }
    }

    public static class EffectsConfig {
        public static final boolean DEFAULT_ENABLED = true;
        public static final int DEFAULT_SIZE_X = 36;
        public static final int DEFAULT_SIZE_Y = 18;
        public static final int DEFAULT_SIZE_Z = 36;
        public static final int DEFAULT_RANDOM_TICKS = 384;
        private boolean enabled = true;
        private int sizeX = 36;
        private int sizeY = 18;
        private int sizeZ = 36;
        private int randomTicks = 384;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public int getSizeX() {
            return this.sizeX;
        }

        public void setSizeX(int sizeX) {
            this.sizeX = sizeX;
        }

        public int getSizeY() {
            return this.sizeY;
        }

        public void setSizeY(int sizeY) {
            this.sizeY = sizeY;
        }

        public int getSizeZ() {
            return this.sizeZ;
        }

        public void setSizeZ(int sizeZ) {
            this.sizeZ = sizeZ;
        }

        public int getRandomTicks() {
            return this.randomTicks;
        }

        public void setRandomTicks(int randomTicks) {
            this.randomTicks = randomTicks;
        }
    }

    public static class FootstepConfig {
        public static final boolean DEFAULT_ENABLED = true;
        public static final float DEFAULT_VOLUME = 0.5f;
        private boolean enabled = true;
        private float volume = 0.5f;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public float getVolume() {
            return this.volume;
        }

        public void setVolume(float volume) {
            this.volume = volume;
        }
    }
}

