/*
 * Decompiled with CFR 0.152.
 */
package me.andre111.mambience.condition;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import me.andre111.mambience.MAPlayer;
import me.andre111.mambience.condition.Condition;

public final class ConditionBiomes
extends Condition {
    private final List<String> biomes;
    private final float minPercentage;

    public ConditionBiomes(List<String> biomes, float minPercentage) {
        this.biomes = new ArrayList<String>(biomes);
        this.minPercentage = minPercentage;
    }

    @Override
    public boolean matches(MAPlayer player) {
        Map<String, Integer> scanData = player.getScanner().getScanBiomeData();
        int count = 0;
        for (String biome : this.biomes) {
            count += scanData != null && biome != null && scanData.containsKey(biome) ? scanData.get(biome) : 0;
        }
        float percentage = (float)count / (float)player.getScanner().getScanBiomeCount();
        return percentage >= this.minPercentage;
    }
}

