/*
 * Decompiled with CFR 0.152.
 */
package me.andre111.mambience;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import me.andre111.mambience.MALogger;
import me.andre111.mambience.MAPlayer;
import me.andre111.mambience.accessor.Accessor;
import me.andre111.mambience.ambient.AmbientEvent;
import me.andre111.mambience.config.Config;
import me.andre111.mambience.config.EventLoader;
import me.andre111.mambience.effect.Effects;
import me.andre111.mambience.scan.BlockScanner;

public class MAScheduler {
    private MALogger logger;
    private long timer;
    private Set<MAPlayer> players = new HashSet<MAPlayer>();
    private Queue<BlockScanner> scannerQueue = new LinkedList<BlockScanner>();
    private boolean clearPlayers = false;
    private List<MAPlayer> newPlayers = new ArrayList<MAPlayer>();

    public MAScheduler(MALogger logger) {
        this.logger = logger;
        this.timer = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPlayer(UUID player, Accessor accessor, MALogger logger) {
        MAPlayer maplayer = new MAPlayer(player, accessor, logger);
        for (AmbientEvent event : EventLoader.EVENTS) {
            event.init(maplayer);
        }
        List<MAPlayer> list = this.newPlayers;
        synchronized (list) {
            this.newPlayers.add(maplayer);
        }
    }

    public void clearPlayers() {
        this.clearPlayers = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runSyncUpdate() {
        long startTime;
        long variableTime = startTime = System.currentTimeMillis();
        ++this.timer;
        List<MAPlayer> list = this.newPlayers;
        synchronized (list) {
            if (this.clearPlayers) {
                this.players.clear();
                this.clearPlayers = false;
            }
            this.players.addAll(this.newPlayers);
            this.newPlayers.clear();
        }
        Iterator<MAPlayer> iterator = this.players.iterator();
        while (iterator.hasNext()) {
            MAPlayer maplayer = iterator.next();
            if (!maplayer.getAccessor().updatePlayerInstance()) {
                iterator.remove();
                continue;
            }
            maplayer.getVariables().update();
            if (Config.footsteps().isEnabled()) {
                maplayer.getFootsteps().update();
            }
            maplayer.getSoundPlayer().update();
            if (maplayer.getScanner().getLastScan() + (long)Config.scanner().getInterval() <= this.timer && !this.scannerQueue.contains(maplayer.getScanner())) {
                this.scannerQueue.add(maplayer.getScanner());
            }
            maplayer.getAccessor().updateLastPosition();
        }
        variableTime = System.currentTimeMillis();
        int refreshed = 0;
        int perTick = (int)Math.max(1.0, Math.ceil((double)this.players.size() / (double)Config.scanner().getInterval() * 1.5));
        for (int i = 0; i < perTick; ++i) {
            BlockScanner scanner = this.scannerQueue.poll();
            if (scanner == null) continue;
            scanner.performScan();
            scanner.setLastScan(this.timer);
            ++refreshed;
        }
        long scannerTime = System.currentTimeMillis();
        Effects.tick();
        long endTime = System.currentTimeMillis();
        if (this.timer % 20L == 0L) {
            this.logger.log("Refreshing " + refreshed + "/" + this.players.size() + " Player(s) last tick took " + (endTime - startTime) + "ms!");
            this.logger.log("\tPlayers: " + (variableTime - startTime) + "ms      Scanners: " + (scannerTime - variableTime) + "ms      Effects: " + (endTime - scannerTime) + "ms!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAsyncUpdate() {
        ArrayList<MAPlayer> toUpdate;
        long startTime = System.currentTimeMillis();
        List<MAPlayer> list = this.newPlayers;
        synchronized (list) {
            toUpdate = new ArrayList<MAPlayer>(this.players);
        }
        if (Config.ambientEvents().isEnabled()) {
            for (MAPlayer maplayer : toUpdate) {
                for (AmbientEvent event : EventLoader.EVENTS) {
                    event.update(maplayer);
                }
            }
        }
        long soundTime = System.currentTimeMillis();
        if (Config.effects().isEnabled()) {
            for (MAPlayer maplayer : toUpdate) {
                Effects.update(maplayer);
            }
        }
        long endTime = System.currentTimeMillis();
        this.logger.log("Soundscape update took " + (soundTime - startTime) + "ms - Effect update took " + (endTime - soundTime) + "ms!");
    }
}

