/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.general_layers;

import com.legacy.blue_skies.world.util.BiomeIDs;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.world.level.newbiome.area.Area;
import net.minecraft.world.level.newbiome.context.Context;
import net.minecraft.world.level.newbiome.layer.traits.AreaTransformer2;
import net.minecraft.world.level.newbiome.layer.traits.DimensionOffset1Transformer;

public enum BiomeMutationLayer implements AreaTransformer2,
DimensionOffset1Transformer
{
    SMALL(() -> BiomeMutationLayer.createSmall()),
    LARGE(() -> BiomeMutationLayer.createLarge());

    private final Supplier<Map<Integer, Function<Integer, Integer>>> mutationsSupplier;
    private Map<Integer, Function<Integer, Integer>> mutations;

    private BiomeMutationLayer(Supplier<Map<Integer, Function<Integer, Integer>>> mutationsSupplier) {
        this.mutationsSupplier = mutationsSupplier;
        this.mutations = mutationsSupplier.get();
    }

    public void reset() {
        this.mutations = this.mutationsSupplier.get();
    }

    public int m_5924_(Context noiseRand, Area biomeLayer, Area noiseLayer, int x, int z) {
        int biomeId = biomeLayer.m_7929_(this.m_6320_(x + 1), this.m_6317_(z + 1));
        Function<Integer, Integer> biomeFunc = this.mutations.get(biomeId);
        if (biomeFunc != null) {
            return biomeFunc.apply(noiseLayer.m_7929_(this.m_6320_(x + 1), this.m_6317_(z + 1)));
        }
        return biomeId;
    }

    private static Map<Integer, Function<Integer, Integer>> createSmall() {
        return (Map)Util.m_137469_(new HashMap(), map -> {
            BiomeIDs ids = BiomeIDs.getInstance();
            map.put(ids.CRESCENT_ORCHARD, noiseVal -> noiseVal < 30 ? ids.CRESCENT_ORCHARD_LAKE : ids.CRESCENT_ORCHARD);
            map.put(ids.FROSTBITTEN_FOREST, noiseVal -> noiseVal < 30 ? ids.FROSTBITTEN_FOREST_CLEARING : ids.FROSTBITTEN_FOREST);
            map.put(ids.DEEP_PEEKING_OCEAN, noiseVal -> noiseVal < 30 ? ids.BRUMBLE_FOREST : ids.DEEP_PEEKING_OCEAN);
        });
    }

    private static Map<Integer, Function<Integer, Integer>> createLarge() {
        return (Map)Util.m_137469_(new HashMap(), map -> {
            BiomeIDs ids = BiomeIDs.getInstance();
            map.put(ids.CRYSTAL_DUNES, noiseVal -> noiseVal < 30 ? ids.CRYSTAL_DUNES_SPIKES : ids.CRYSTAL_DUNES);
        });
    }
}

