/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.general_features.structures;

import com.google.common.collect.ImmutableList;
import com.legacy.structure_gel.api.structure.GelStructure;
import com.mojang.serialization.Codec;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public abstract class BlindingDungeonStructure
extends GelStructure<NoneFeatureConfiguration> {
    public BlindingDungeonStructure(Codec<NoneFeatureConfiguration> configFactoryIn) {
        super(configFactoryIn);
        this.spawns.put(MobCategory.MONSTER, ImmutableList.of());
    }

    protected boolean isFeatureChunk(ChunkGenerator chunkGen, BiomeSource biomeProvider, long seed, WorldgenRandom rand, ChunkPos chunkPosIn, Biome biomeIn, ChunkPos potentialChunkPos, NoneFeatureConfiguration config, LevelHeightAccessor level) {
        ChunkPos chunkPos = this.m_67067_(this.getFeatureConfiguration(), seed, rand, chunkPosIn.f_45578_, chunkPosIn.f_45579_);
        for (Biome biome : biomeProvider.m_7901_(chunkPos.f_45578_ * 16 + 8, chunkGen.m_6337_(), chunkPos.f_45579_ * 16 + 8, 18)) {
            if (biome.m_47536_().m_47808_((StructureFeature)this)) continue;
            return false;
        }
        if (chunkPos.equals((Object)chunkPosIn)) {
            rand.m_64694_(seed, chunkPosIn.f_45578_, chunkPosIn.f_45579_, this.getSeed());
            return rand.nextDouble() < (double)this.getProbability() && BlindingDungeonStructure.getHighestY(level, chunkGen, chunkPos.f_45578_, chunkPos.f_45579_) >= 60;
        }
        return false;
    }

    public static int getHighestY(LevelHeightAccessor level, ChunkGenerator chunkGen, int chunkX, int chunkZ) {
        int width = 18;
        int x = chunkX * 16 + 8;
        int z = chunkZ * 16 + 8;
        int y = 0;
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                y = Math.max(y, chunkGen.m_142647_(x + i * width, z + j * width, Heightmap.Types.WORLD_SURFACE_WG, level));
            }
        }
        return y;
    }
}

