/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everdawn.biome.provider.layer;

import com.legacy.blue_skies.world.everdawn.biome.provider.layer.DawnRiverLayer;
import com.legacy.blue_skies.world.everdawn.biome.provider.layer.EverdawnBiomeLayer;
import com.legacy.blue_skies.world.everdawn.biome.provider.layer.MixDawnRiverLayer;
import com.legacy.blue_skies.world.general_layers.BiomeMutationLayer;
import com.legacy.blue_skies.world.general_layers.BiomeMutationNoiseLayer;
import java.util.function.LongFunction;
import net.minecraft.world.level.newbiome.area.Area;
import net.minecraft.world.level.newbiome.area.AreaFactory;
import net.minecraft.world.level.newbiome.context.BigContext;
import net.minecraft.world.level.newbiome.context.LazyAreaContext;
import net.minecraft.world.level.newbiome.layer.IslandLayer;
import net.minecraft.world.level.newbiome.layer.Layer;
import net.minecraft.world.level.newbiome.layer.RiverInitLayer;
import net.minecraft.world.level.newbiome.layer.SmoothLayer;
import net.minecraft.world.level.newbiome.layer.ZoomLayer;
import net.minecraft.world.level.newbiome.layer.traits.AreaTransformer1;

public class EverdawnLayer {
    public static <T extends Area, C extends BigContext<T>> AreaFactory<T> repeat(long seed, AreaTransformer1 parent, AreaFactory<T> layer, int count, LongFunction<C> contextFactory) {
        AreaFactory iareafactory = layer;
        for (int i = 0; i < count; ++i) {
            iareafactory = parent.m_77002_((BigContext)contextFactory.apply(seed + (long)i), iareafactory);
        }
        return iareafactory;
    }

    private static <T extends Area, C extends BigContext<T>> AreaFactory<T> setupLayers(int biomeSize, int riverSize, LongFunction<C> contextFactory) {
        AreaFactory<T> baseLayer = IslandLayer.INSTANCE.m_76984_((BigContext)contextFactory.apply(1L));
        baseLayer = ZoomLayer.FUZZY.m_77002_((BigContext)contextFactory.apply(2000L), (AreaFactory)baseLayer);
        baseLayer = ZoomLayer.NORMAL.m_77002_((BigContext)contextFactory.apply(2001L), (AreaFactory)baseLayer);
        baseLayer = ZoomLayer.NORMAL.m_77002_((BigContext)contextFactory.apply(2002L), (AreaFactory)baseLayer);
        baseLayer = ZoomLayer.NORMAL.m_77002_((BigContext)contextFactory.apply(2003L), (AreaFactory)baseLayer);
        baseLayer = EverdawnLayer.repeat(1000L, (AreaTransformer1)ZoomLayer.NORMAL, baseLayer, 0, contextFactory);
        AreaFactory baseZoom1 = EverdawnLayer.repeat(1000L, (AreaTransformer1)ZoomLayer.NORMAL, baseLayer, 0, contextFactory);
        baseZoom1 = RiverInitLayer.INSTANCE.m_77002_((BigContext)contextFactory.apply(100L), baseZoom1);
        AreaFactory everdawnBiomeLayer = new EverdawnBiomeLayer().m_77002_((BigContext)contextFactory.apply(200L), baseLayer);
        baseZoom1 = EverdawnLayer.repeat(1000L, (AreaTransformer1)ZoomLayer.NORMAL, baseZoom1, 2, contextFactory);
        baseZoom1 = EverdawnLayer.repeat(1000L, (AreaTransformer1)ZoomLayer.NORMAL, baseZoom1, riverSize, contextFactory);
        baseZoom1 = DawnRiverLayer.INSTANCE.m_77002_((BigContext)contextFactory.apply(1L), baseZoom1);
        baseZoom1 = SmoothLayer.INSTANCE.m_77002_((BigContext)contextFactory.apply(1000L), baseZoom1);
        for (int k = 0; k < biomeSize; ++k) {
            everdawnBiomeLayer = ZoomLayer.NORMAL.m_77002_((BigContext)contextFactory.apply(1000 + k), everdawnBiomeLayer);
        }
        everdawnBiomeLayer = SmoothLayer.INSTANCE.m_77002_((BigContext)contextFactory.apply(1000L), everdawnBiomeLayer);
        everdawnBiomeLayer = MixDawnRiverLayer.INSTANCE.m_77020_((BigContext)contextFactory.apply(100L), everdawnBiomeLayer, baseZoom1);
        AreaFactory mutationLayer = BiomeMutationNoiseLayer.INSTANCE.m_76984_((BigContext)contextFactory.apply(2L));
        everdawnBiomeLayer = BiomeMutationLayer.LARGE.m_77020_((BigContext)contextFactory.apply(100L), everdawnBiomeLayer, EverdawnLayer.repeat(1000L, (AreaTransformer1)ZoomLayer.NORMAL, mutationLayer, 2, contextFactory));
        everdawnBiomeLayer = BiomeMutationLayer.SMALL.m_77020_((BigContext)contextFactory.apply(100L), everdawnBiomeLayer, mutationLayer);
        return everdawnBiomeLayer;
    }

    public static Layer build(long seed, int biomeSize, int riverSize) {
        AreaFactory layerFactory = EverdawnLayer.setupLayers(biomeSize, riverSize, seedModifier -> new LazyAreaContext(25, seed, seedModifier));
        return new Layer(layerFactory);
    }
}

