/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everbright.gen.structures.nature_dungeon;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.legacy.blue_skies.registries.SkiesDimensions;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.world.everbright.gen.structures.nature_dungeon.NatureDungeonPieces;
import com.legacy.structure_gel.api.structure.GelStructure;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;

public class NatureDungeonStructure
extends GelStructure<NoneFeatureConfiguration> {
    private static final List<MobSpawnSettings.SpawnerData> DUNGEON_ENEMIES = Lists.newArrayList((Object[])new MobSpawnSettings.SpawnerData[]{new MobSpawnSettings.SpawnerData(SkiesEntityTypes.STONELET, 2, 1, 1), new MobSpawnSettings.SpawnerData(SkiesEntityTypes.SPEWTER, 2, 1, 1)});

    public NatureDungeonStructure(Codec<NoneFeatureConfiguration> configFactoryIn) {
        super(configFactoryIn);
        this.spawns.put(MobCategory.MONSTER, DUNGEON_ENEMIES);
    }

    public int getSpacing() {
        return 36;
    }

    public int getOffset() {
        return this.getSpacing() - 13;
    }

    public Set<ResourceLocation> getValidDimensions() {
        return ImmutableSet.of((Object)SkiesDimensions.EVERBRIGHT_ID);
    }

    public StructureFeature.StructureStartFactory<NoneFeatureConfiguration> m_6258_() {
        return Start::new;
    }

    public static int getYValue(LevelHeightAccessor level, ChunkGenerator chunkGen, int chunkX, int chunkZ) {
        return chunkGen.m_156179_(chunkX * 16, chunkZ * 16, Heightmap.Types.WORLD_SURFACE_WG, null);
    }

    public static class Start
    extends StructureStart<NoneFeatureConfiguration> {
        public Start(StructureFeature<NoneFeatureConfiguration> structureIn, ChunkPos chunkPos, int referenceIn, long seed) {
            super(structureIn, chunkPos, referenceIn, seed);
        }

        public void generatePieces(RegistryAccess registry, ChunkGenerator generator, StructureManager templateManagerIn, ChunkPos chunkPos, Biome biomeIn, NoneFeatureConfiguration config, LevelHeightAccessor level) {
            NatureDungeonPieces.assemble(templateManagerIn, new BlockPos(chunkPos.f_45578_ * 16 + 8, 88, chunkPos.f_45579_ * 16 + 8), Rotation.m_55956_((Random)this.f_73564_), this.f_73562_, (Random)this.f_73564_, generator, level);
        }
    }
}

