/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everbright.gen.structures.blinding_dungeon;

import com.google.common.collect.ImmutableSet;
import com.legacy.blue_skies.registries.SkiesDimensions;
import com.legacy.blue_skies.registries.SkiesStructures;
import com.legacy.blue_skies.world.everbright.gen.structures.blinding_dungeon.EverbrightBlindingDungeonPieces;
import com.legacy.blue_skies.world.everbright.gen.structures.nature_dungeon.NatureDungeonStructure;
import com.legacy.blue_skies.world.general_features.structures.BlindingDungeonStructure;
import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;

public class EverbrightBlindingDungeonStructure
extends BlindingDungeonStructure {
    public EverbrightBlindingDungeonStructure(Codec<NoneFeatureConfiguration> config) {
        super(config);
    }

    @Override
    protected boolean isFeatureChunk(ChunkGenerator chunkGen, BiomeSource biomeProvider, long seed, WorldgenRandom sharedSeedRand, ChunkPos chunkPosIn, Biome biomeIn, ChunkPos potentialChunkPos, NoneFeatureConfiguration config, LevelHeightAccessor level) {
        return super.isFeatureChunk(chunkGen, biomeProvider, seed, sharedSeedRand, chunkPosIn, biomeIn, potentialChunkPos, config, level) && !this.isDungeonClose(level, chunkGen, seed, sharedSeedRand, chunkPosIn);
    }

    private boolean isDungeonClose(LevelHeightAccessor level, ChunkGenerator chunkGen, long seed, WorldgenRandom sharedSeedRand, ChunkPos chunkPos) {
        int range = 10;
        for (int x = chunkPos.f_45578_ - range; x <= chunkPos.f_45578_ + range; ++x) {
            for (int z = chunkPos.f_45579_ - range; z <= chunkPos.f_45579_ + range; ++z) {
                ChunkPos chunkpos = ((NatureDungeonStructure)SkiesStructures.NATURE_DUNGEON.getStructure()).m_67067_(null, seed, sharedSeedRand, x, z);
                if (x != chunkpos.f_45578_ || z != chunkpos.f_45579_) continue;
                return true;
            }
        }
        return false;
    }

    public int getSpacing() {
        return 26;
    }

    public int getOffset() {
        return this.getSpacing() - 10;
    }

    public Set<ResourceLocation> getValidDimensions() {
        return ImmutableSet.of((Object)SkiesDimensions.EVERBRIGHT_ID);
    }

    public StructureFeature.StructureStartFactory<NoneFeatureConfiguration> m_6258_() {
        return Start::new;
    }

    public static class Start
    extends StructureStart<NoneFeatureConfiguration> {
        public Start(StructureFeature<NoneFeatureConfiguration> structure, ChunkPos chunkPos, int referenceIn, long seed) {
            super(structure, chunkPos, referenceIn, seed);
        }

        public void generatePieces(RegistryAccess registry, ChunkGenerator chunkGen, StructureManager templateManagerIn, ChunkPos chunkPos, Biome biomeIn, NoneFeatureConfiguration configIn, LevelHeightAccessor level) {
            Rotation rotation = Rotation.values()[this.f_73564_.nextInt(Rotation.values().length)];
            int y = BlindingDungeonStructure.getHighestY(level, chunkGen, chunkPos.f_45578_, chunkPos.f_45579_);
            if (y >= 60) {
                BlockPos blockpos = new BlockPos(chunkPos.f_45578_ * 16 + 8, y, chunkPos.f_45579_ * 16 + 8);
                EverbrightBlindingDungeonPieces.assemble(templateManagerIn, blockpos, rotation, this.f_73562_, (Random)this.f_73564_);
            }
        }
    }
}

