/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everbright.biome.provider.layer;

import com.legacy.blue_skies.world.everbright.biome.provider.layer.EverbrightBiomeLayer;
import com.legacy.blue_skies.world.everbright.biome.provider.layer.EverbrightOceanLayer;
import com.legacy.blue_skies.world.everbright.biome.provider.layer.EverbrightShoreLayer;
import com.legacy.blue_skies.world.everbright.biome.provider.layer.MixEverbrightOceansLayer;
import com.legacy.blue_skies.world.general_layers.BiomeMutationLayer;
import com.legacy.blue_skies.world.general_layers.BiomeMutationNoiseLayer;
import java.util.function.LongFunction;
import net.minecraft.world.level.newbiome.area.Area;
import net.minecraft.world.level.newbiome.area.AreaFactory;
import net.minecraft.world.level.newbiome.context.BigContext;
import net.minecraft.world.level.newbiome.context.LazyAreaContext;
import net.minecraft.world.level.newbiome.layer.IslandLayer;
import net.minecraft.world.level.newbiome.layer.Layer;
import net.minecraft.world.level.newbiome.layer.SmoothLayer;
import net.minecraft.world.level.newbiome.layer.ZoomLayer;
import net.minecraft.world.level.newbiome.layer.traits.AreaTransformer1;

public class EverbrightLayer {
    public static <T extends Area, C extends BigContext<T>> AreaFactory<T> repeat(long seed, AreaTransformer1 parent, AreaFactory<T> layer, int count, LongFunction<C> contextFactory) {
        AreaFactory iareafactory = layer;
        for (int i = 0; i < count; ++i) {
            iareafactory = parent.m_77002_((BigContext)contextFactory.apply(seed + (long)i), iareafactory);
        }
        return iareafactory;
    }

    private static <T extends Area, C extends BigContext<T>> AreaFactory<T> setupLayers(int biomeSize, int riverSize, LongFunction<C> contextFactory) {
        AreaFactory<T> baseLayer = IslandLayer.INSTANCE.m_76984_((BigContext)contextFactory.apply(1L));
        baseLayer = ZoomLayer.FUZZY.m_77002_((BigContext)contextFactory.apply(2000L), (AreaFactory)baseLayer);
        baseLayer = ZoomLayer.NORMAL.m_77002_((BigContext)contextFactory.apply(2001L), (AreaFactory)baseLayer);
        AreaFactory<T> oceanLayer = EverbrightOceanLayer.INSTANCE.m_76984_((BigContext)contextFactory.apply(2L));
        oceanLayer = EverbrightLayer.repeat(2001L, (AreaTransformer1)ZoomLayer.NORMAL, oceanLayer, 6, contextFactory);
        baseLayer = ZoomLayer.NORMAL.m_77002_((BigContext)contextFactory.apply(2002L), (AreaFactory)baseLayer);
        baseLayer = ZoomLayer.NORMAL.m_77002_((BigContext)contextFactory.apply(2003L), (AreaFactory)baseLayer);
        baseLayer = EverbrightLayer.repeat(1000L, (AreaTransformer1)ZoomLayer.NORMAL, baseLayer, 0, contextFactory);
        AreaFactory baseZoom1 = EverbrightLayer.repeat(1000L, (AreaTransformer1)ZoomLayer.NORMAL, baseLayer, 0, contextFactory);
        AreaFactory everbrightBiomeLayer = new EverbrightBiomeLayer().m_77002_((BigContext)contextFactory.apply(200L), baseLayer);
        baseZoom1 = EverbrightLayer.repeat(1000L, (AreaTransformer1)ZoomLayer.NORMAL, baseZoom1, 2, contextFactory);
        baseZoom1 = EverbrightLayer.repeat(1000L, (AreaTransformer1)ZoomLayer.NORMAL, baseZoom1, riverSize, contextFactory);
        baseZoom1 = SmoothLayer.INSTANCE.m_77002_((BigContext)contextFactory.apply(1000L), baseZoom1);
        for (int k = 0; k < biomeSize; ++k) {
            everbrightBiomeLayer = ZoomLayer.NORMAL.m_77002_((BigContext)contextFactory.apply(1000 + k), everbrightBiomeLayer);
            if (k != 1 && biomeSize != 1) continue;
            everbrightBiomeLayer = EverbrightShoreLayer.INSTANCE.m_77002_((BigContext)contextFactory.apply(1000L), everbrightBiomeLayer);
        }
        everbrightBiomeLayer = SmoothLayer.INSTANCE.m_77002_((BigContext)contextFactory.apply(1000L), everbrightBiomeLayer);
        everbrightBiomeLayer = MixEverbrightOceansLayer.INSTANCE.m_77020_((BigContext)contextFactory.apply(100L), everbrightBiomeLayer, oceanLayer);
        AreaFactory mutationLayer = BiomeMutationNoiseLayer.INSTANCE.m_76984_((BigContext)contextFactory.apply(2L));
        everbrightBiomeLayer = BiomeMutationLayer.LARGE.m_77020_((BigContext)contextFactory.apply(100L), everbrightBiomeLayer, EverbrightLayer.repeat(1000L, (AreaTransformer1)ZoomLayer.NORMAL, mutationLayer, 2, contextFactory));
        everbrightBiomeLayer = BiomeMutationLayer.SMALL.m_77020_((BigContext)contextFactory.apply(100L), everbrightBiomeLayer, mutationLayer);
        return everbrightBiomeLayer;
    }

    public static Layer build(long seed, int biomeSize, int riverSize) {
        AreaFactory layerFactory = EverbrightLayer.setupLayers(biomeSize, riverSize, seedModifier -> new LazyAreaContext(25, seed, seedModifier));
        return new Layer(layerFactory);
    }
}

