/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everbright.biome.provider;

import com.legacy.blue_skies.registries.SkiesBiomes;
import com.legacy.blue_skies.world.everbright.biome.provider.layer.EverbrightLayer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryLookupCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.newbiome.layer.Layer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EverbrightBiomeProvider
extends BiomeSource {
    public static final Codec<EverbrightBiomeProvider> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("seed").stable().forGetter(prov -> prov.seed), (App)Codec.BOOL.fieldOf("large_biomes").orElse((Object)false).stable().forGetter(prov -> prov.largeBiomes), (App)RegistryLookupCodec.m_135622_((ResourceKey)Registry.f_122885_).forGetter(prov -> prov.biomeRegistry)).apply((Applicative)instance, instance.stable(EverbrightBiomeProvider::new)));
    private final Layer genBiomes;
    private final long seed;
    private final boolean largeBiomes;
    private final Registry<Biome> biomeRegistry;

    public EverbrightBiomeProvider(long seedIn, boolean largeBiomes, Registry<Biome> biomeRegistry) {
        super(new ArrayList<Biome>(SkiesBiomes.EVERBRIGHT_BIOMES));
        this.seed = seedIn;
        this.largeBiomes = largeBiomes;
        this.biomeRegistry = biomeRegistry;
        this.genBiomes = EverbrightLayer.build(seedIn, largeBiomes ? 8 : 6, 4);
    }

    protected Codec<? extends BiomeSource> m_5820_() {
        return CODEC;
    }

    @OnlyIn(value=Dist.CLIENT)
    public BiomeSource m_7206_(long seed) {
        return new EverbrightBiomeProvider(seed, this.largeBiomes, this.biomeRegistry);
    }

    public Biome m_7158_(int x, int y, int z) {
        return this.genBiomes.m_76715_(this.biomeRegistry, x, z);
    }
}

