/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.registries;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesStructures;
import com.legacy.blue_skies.world.SkiesNoiseChunkGenerator;
import com.legacy.blue_skies.world.everbright.biome.provider.EverbrightBiomeProvider;
import com.legacy.blue_skies.world.everbright.gen.structures.blinding_dungeon.EverbrightBlindingDungeonStructure;
import com.legacy.blue_skies.world.everbright.gen.structures.bunker.BunkerStructure;
import com.legacy.blue_skies.world.everbright.gen.structures.nature_dungeon.NatureDungeonStructure;
import com.legacy.blue_skies.world.everdawn.biome.provider.EverdawnBiomeProvider;
import com.legacy.blue_skies.world.everdawn.gen.structures.blinding_dungeon.EverdawnBlindingDungeonStructure;
import com.legacy.blue_skies.world.everdawn.gen.structures.poison_dungeon.PoisonDungeonStructure;
import com.legacy.blue_skies.world.util.BiomeIDs;
import com.legacy.structure_gel.api.dimension.DimensionAccessHelper;
import com.legacy.structure_gel.api.dimension.DimensionTypeBuilder;
import com.legacy.structure_gel.api.events.RegisterDimensionEvent;
import com.legacy.structure_gel.api.registry.registrar.DimensionRegistrar;
import com.legacy.structure_gel.api.util.GelCollectors;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.StructureSettings;

public class SkiesDimensions {
    public static final ResourceLocation EVERBRIGHT_ID = BlueSkies.locate("everbright");
    public static final ResourceLocation EVERDAWN_ID = BlueSkies.locate("everdawn");
    private static DimensionRegistrar EVERBRIGHT;
    private static DimensionRegistrar EVERDAWN;
    private static final StructureSettings BRIGHT_STRUCTURE_SETTINGS;
    private static final StructureSettings DAWN_STRUCTURE_SETTINGS;

    public static void init() {
        BiomeIDs.reset();
        boolean largeBiomes = false;
        NoiseGeneratorSettings brightSettings = DimensionAccessHelper.newCustomSurfaceSettings((StructureSettings)BRIGHT_STRUCTURE_SETTINGS, (boolean)false, (BlockState)SkiesBlocks.turquoise_stone.m_49966_(), (BlockState)Blocks.f_49990_.m_49966_());
        Function<RegisterDimensionEvent, ChunkGenerator> brightGenerator = e -> {
            long seed = e.getSeed() + 80085L;
            return new SkiesNoiseChunkGenerator(new EverbrightBiomeProvider(seed, largeBiomes, (Registry<Biome>)e.getBiomeRegistry()), seed, () -> brightSettings);
        };
        DimensionType brightDimensionType = DimensionTypeBuilder.of().fixedTime(OptionalLong.of(6000L)).effects(EVERBRIGHT_ID).build();
        EVERBRIGHT = new DimensionRegistrar(EVERBRIGHT_ID, brightDimensionType, brightSettings, brightGenerator);
        NoiseGeneratorSettings dawnSettings = DimensionAccessHelper.newCustomSurfaceSettings((StructureSettings)DAWN_STRUCTURE_SETTINGS, (boolean)false, (BlockState)SkiesBlocks.lunar_stone.m_49966_(), (BlockState)Blocks.f_49990_.m_49966_());
        Function<RegisterDimensionEvent, ChunkGenerator> dawnGenerator = e -> {
            long seed = e.getSeed() + 1337L;
            return new SkiesNoiseChunkGenerator(new EverdawnBiomeProvider(seed, largeBiomes, (Registry<Biome>)e.getBiomeRegistry()), seed, () -> dawnSettings);
        };
        DimensionType dawnDimensionType = DimensionTypeBuilder.of().fixedTime(OptionalLong.of(23200L)).effects(EVERDAWN_ID).build();
        EVERDAWN = new DimensionRegistrar(EVERDAWN_ID, dawnDimensionType, dawnSettings, dawnGenerator);
    }

    public static ResourceKey<Level> everbrightKey() {
        return EVERBRIGHT.getLevelKey();
    }

    public static ResourceKey<Level> everdawnKey() {
        return EVERDAWN.getLevelKey();
    }

    public static boolean inSkyDimension(Entity entity) {
        if (entity == null) {
            return false;
        }
        return entity.f_19853_.m_46472_() == SkiesDimensions.everbrightKey() || entity.f_19853_.m_46472_() == SkiesDimensions.everdawnKey();
    }

    static {
        BRIGHT_STRUCTURE_SETTINGS = new StructureSettings(Optional.empty(), GelCollectors.mapOf((Object)SkiesStructures.BUNKER.getStructure(), (Object)((BunkerStructure)SkiesStructures.BUNKER.getStructure()).getFeatureConfiguration(), (Object[])new Object[]{SkiesStructures.EVERBRIGHT_BLINDING_DUNGEON.getStructure(), ((EverbrightBlindingDungeonStructure)SkiesStructures.EVERBRIGHT_BLINDING_DUNGEON.getStructure()).getFeatureConfiguration(), SkiesStructures.NATURE_DUNGEON.getStructure(), ((NatureDungeonStructure)SkiesStructures.NATURE_DUNGEON.getStructure()).getFeatureConfiguration()}));
        DAWN_STRUCTURE_SETTINGS = new StructureSettings(Optional.empty(), GelCollectors.mapOf((Object)SkiesStructures.EVERDAWN_BLINDING_DUNGEON.getStructure(), (Object)((EverdawnBlindingDungeonStructure)SkiesStructures.EVERDAWN_BLINDING_DUNGEON.getStructure()).getFeatureConfiguration(), (Object[])new Object[]{SkiesStructures.POISON_DUNGEON.getStructure(), ((PoisonDungeonStructure)SkiesStructures.POISON_DUNGEON.getStructure()).getFeatureConfiguration()}));
    }
}

