/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.registries;

import com.google.common.collect.Sets;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.data.providers.SkiesBiomeProv;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesRegistry;
import com.legacy.blue_skies.world.everbright.biome.provider.EverbrightBiomeProvider;
import com.legacy.blue_skies.world.everbright.biome.surface_builder.CoarseDirtMixSurfaceBuilder;
import com.legacy.blue_skies.world.everdawn.biome.provider.EverdawnBiomeProvider;
import com.legacy.blue_skies.world.everdawn.biome.surface_builder.CrystalRoughsSurfaceBuilder;
import com.legacy.blue_skies.world.everdawn.biome.surface_builder.MoonlitReservoirSurfaceBuilder;
import com.legacy.structure_gel.api.registry.registrar.BiomeRegistrar;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraft.world.level.levelgen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.level.levelgen.surfacebuilders.SurfaceBuilderBaseConfiguration;
import net.minecraft.world.level.levelgen.surfacebuilders.SurfaceBuilderConfiguration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistry;

public class SkiesBiomes {
    public static final BiomeRegistrar CALMING_SKIES = new BiomeRegistrar(BlueSkies.locate("calming_skies"), SkiesBiomeProv.Makers.calmingSkies());
    public static final BiomeRegistrar BRIGHTLANDS = new BiomeRegistrar(BlueSkies.locate("brightlands"), SkiesBiomeProv.Makers.brightlands());
    public static final BiomeRegistrar SLUSHLANDS = new BiomeRegistrar(BlueSkies.locate("slushlands"), SkiesBiomeProv.Makers.slushlands());
    public static final BiomeRegistrar FROSTBITTEN_FOREST = new BiomeRegistrar(BlueSkies.locate("frostbitten_forest"), SkiesBiomeProv.Makers.frostbittenForest(false));
    public static final BiomeRegistrar FROSTBITTEN_FOREST_CLEARING = new BiomeRegistrar(BlueSkies.locate("frostbitten_forest_clearing"), SkiesBiomeProv.Makers.frostbittenForest(true));
    public static final BiomeRegistrar PEEKING_OCEAN = new BiomeRegistrar(BlueSkies.locate("peeking_ocean"), SkiesBiomeProv.Makers.peekingOcean(false, false));
    public static final BiomeRegistrar DEEP_PEEKING_OCEAN = new BiomeRegistrar(BlueSkies.locate("deep_peeking_ocean"), SkiesBiomeProv.Makers.peekingOcean(true, false));
    public static final BiomeRegistrar BRUMBLE_FOREST = new BiomeRegistrar(BlueSkies.locate("brumble_forest"), SkiesBiomeProv.Makers.peekingOcean(true, true));
    public static final BiomeRegistrar MIDDAY_SHORE = new BiomeRegistrar(BlueSkies.locate("midday_shore"), SkiesBiomeProv.Makers.middayShore());
    public static final BiomeRegistrar SNOW_COVERED_PINES = new BiomeRegistrar(BlueSkies.locate("snow_covered_pines"), SkiesBiomeProv.Makers.snowCoveredPines());
    public static final BiomeRegistrar BRISK_MEADOW = new BiomeRegistrar(BlueSkies.locate("brisk_meadow"), SkiesBiomeProv.Makers.briskMeadow());
    public static final BiomeRegistrar POLAR_HIGHLAND = new BiomeRegistrar(BlueSkies.locate("polar_highland"), SkiesBiomeProv.Makers.polarHighland());
    public static final BiomeRegistrar UNORTHODOX_VALLEY = new BiomeRegistrar(BlueSkies.locate("unorthodox_valley"), SkiesBiomeProv.Makers.unorthodoxValley());
    public static final BiomeRegistrar SHADED_WOODLANDS = new BiomeRegistrar(BlueSkies.locate("shaded_woodlands"), SkiesBiomeProv.Makers.shadedWoodlands());
    public static final BiomeRegistrar CRYSTAL_DUNES = new BiomeRegistrar(BlueSkies.locate("crystal_dunes"), SkiesBiomeProv.Makers.crystalDunes(false));
    public static final BiomeRegistrar CRYSTAL_DUNES_SPIKES = new BiomeRegistrar(BlueSkies.locate("crystal_dunes_spikes"), SkiesBiomeProv.Makers.crystalDunes(true));
    public static final BiomeRegistrar SUNSET_MAPLE_FOREST = new BiomeRegistrar(BlueSkies.locate("sunset_maple_forest"), SkiesBiomeProv.Makers.sunsetMapleForest());
    public static final BiomeRegistrar RISING_CREEK = new BiomeRegistrar(BlueSkies.locate("rising_creek"), SkiesBiomeProv.Makers.risingCreek());
    public static final BiomeRegistrar MOONLIT_RESERVOIR = new BiomeRegistrar(BlueSkies.locate("moonlit_reservoir"), SkiesBiomeProv.Makers.moonlitReservoir());
    public static final BiomeRegistrar CRYSTAL_ROUGHS = new BiomeRegistrar(BlueSkies.locate("crystal_roughs"), SkiesBiomeProv.Makers.crystalRoughs());
    public static final BiomeRegistrar SEARING_GRASSLAND = new BiomeRegistrar(BlueSkies.locate("searing_grassland"), SkiesBiomeProv.Makers.searingGrassland());
    public static final BiomeRegistrar CRESCENT_ORCHARD = new BiomeRegistrar(BlueSkies.locate("crescent_orchard"), SkiesBiomeProv.Makers.crescentOrchard(false));
    public static final BiomeRegistrar CRESCENT_ORCHARD_LAKE = new BiomeRegistrar(BlueSkies.locate("crescent_orchard_lake"), SkiesBiomeProv.Makers.crescentOrchard(true));
    public static final Set<Biome> EVERBRIGHT_BIOMES = Sets.newHashSet();
    public static final Set<Biome> EVERDAWN_BIOMES = Sets.newHashSet();
    public static final Set<ResourceKey<Biome>> EVERBRIGHT_KEYS = Sets.newHashSet();
    public static final Set<ResourceKey<Biome>> EVERDAWN_KEYS = Sets.newHashSet();
    public static final Set<ResourceLocation> EVERBRIGHT_LOCATIONS = Sets.newHashSet();
    public static final Set<ResourceLocation> EVERDAWN_LOCATIONS = Sets.newHashSet();
    public static final Set<ResourceKey<Biome>> SANDSTORM_APPLICABLE = Sets.newHashSet();

    public static void init(RegistryEvent.Register<Biome> event) {
        IForgeRegistry registry = event.getRegistry();
        SkiesBiomes.register((IForgeRegistry<Biome>)registry, Arrays.asList(CALMING_SKIES, BRIGHTLANDS, SLUSHLANDS, FROSTBITTEN_FOREST, PEEKING_OCEAN, MIDDAY_SHORE), true);
        SkiesBiomes.register((IForgeRegistry<Biome>)registry, Arrays.asList(UNORTHODOX_VALLEY, SHADED_WOODLANDS, CRYSTAL_DUNES, SUNSET_MAPLE_FOREST, RISING_CREEK), false);
        SkiesBiomes.register((IForgeRegistry<Biome>)registry, Arrays.asList(SNOW_COVERED_PINES, DEEP_PEEKING_OCEAN, BRISK_MEADOW, POLAR_HIGHLAND, FROSTBITTEN_FOREST_CLEARING, BRUMBLE_FOREST), true);
        SkiesBiomes.register((IForgeRegistry<Biome>)registry, Arrays.asList(MOONLIT_RESERVOIR, CRYSTAL_ROUGHS, SEARING_GRASSLAND, CRESCENT_ORCHARD, CRESCENT_ORCHARD_LAKE, CRYSTAL_DUNES_SPIKES), false);
        Registry.m_122961_((Registry)Registry.f_122889_, (String)"everbright", EverbrightBiomeProvider.CODEC);
        Registry.m_122961_((Registry)Registry.f_122889_, (String)"everdawn", EverdawnBiomeProvider.CODEC);
        SANDSTORM_APPLICABLE.add((ResourceKey<Biome>)CRYSTAL_DUNES.getKey());
        SANDSTORM_APPLICABLE.add((ResourceKey<Biome>)CRYSTAL_DUNES_SPIKES.getKey());
    }

    public static void register(IForgeRegistry<Biome> registry, List<BiomeRegistrar> biome, boolean inEverbright) {
        biome.forEach(b -> {
            b.handleForge(registry);
            if (inEverbright) {
                EVERBRIGHT_BIOMES.add(b.getBiome());
                EVERBRIGHT_KEYS.add((ResourceKey<Biome>)b.getKey());
                EVERBRIGHT_LOCATIONS.add(b.getName());
            } else {
                EVERDAWN_BIOMES.add(b.getBiome());
                EVERDAWN_KEYS.add((ResourceKey<Biome>)b.getKey());
                EVERDAWN_LOCATIONS.add(b.getName());
            }
        });
    }

    public static class SurfaceBuilders {
        public static final CrystalRoughsSurfaceBuilder ROUGHS = new CrystalRoughsSurfaceBuilder((Codec<SurfaceBuilderBaseConfiguration>)SurfaceBuilderBaseConfiguration.f_75241_);
        public static final CoarseDirtMixSurfaceBuilder TURQUOISE_COARSE_MIX = new CoarseDirtMixSurfaceBuilder((Codec<SurfaceBuilderBaseConfiguration>)SurfaceBuilderBaseConfiguration.f_75241_);
        public static final MoonlitReservoirSurfaceBuilder RESERVOIR = new MoonlitReservoirSurfaceBuilder((Codec<SurfaceBuilderBaseConfiguration>)SurfaceBuilderBaseConfiguration.f_75241_);
        public static final SurfaceBuilderBaseConfiguration TURQUOISE_GRASS_DIRT_SAND_CONFIG = new SurfaceBuilderBaseConfiguration(SkiesBlocks.turquoise_grass_block.m_49966_(), SkiesBlocks.turquoise_dirt.m_49966_(), SkiesBlocks.midnight_sand.m_49966_());
        public static final SurfaceBuilderBaseConfiguration LUNAR_GRASS_DIRT_SAND_CONFIG = new SurfaceBuilderBaseConfiguration(SkiesBlocks.lunar_grass_block.m_49966_(), SkiesBlocks.lunar_dirt.m_49966_(), SkiesBlocks.crystal_sand.m_49966_());
        public static final SurfaceBuilderBaseConfiguration MIDNIGHT_SAND_SANDSTONE_SAND_CONFIG = new SurfaceBuilderBaseConfiguration(SkiesBlocks.midnight_sand.m_49966_(), SkiesBlocks.midnight_sandstone.m_49966_(), SkiesBlocks.midnight_sand.m_49966_());
        public static final SurfaceBuilderBaseConfiguration CRYSTAL_SAND_SANDSTONE_DIRT_CONFIG = new SurfaceBuilderBaseConfiguration(SkiesBlocks.crystal_sand.m_49966_(), SkiesBlocks.crystal_sandstone.m_49966_(), SkiesBlocks.lunar_dirt.m_49966_());
        public static final SurfaceBuilderBaseConfiguration TURQUOISE_COARSE_DIRT_SAND_CONFIG = new SurfaceBuilderBaseConfiguration(SkiesBlocks.coarse_turquoise_dirt.m_49966_(), SkiesBlocks.turquoise_dirt.m_49966_(), SkiesBlocks.midnight_sand.m_49966_());
        public static final SurfaceBuilderBaseConfiguration LUNAR_COARSE_DIRT_SAND_CONFIG = new SurfaceBuilderBaseConfiguration(SkiesBlocks.coarse_lunar_dirt.m_49966_(), SkiesBlocks.lunar_dirt.m_49966_(), SkiesBlocks.crystal_sand.m_49966_());
        public static final ConfiguredSurfaceBuilder<SurfaceBuilderBaseConfiguration> TURQUOISE_GRASS_SURFACE_BUILDER = SurfaceBuilder.f_75214_.m_75223_((SurfaceBuilderConfiguration)TURQUOISE_GRASS_DIRT_SAND_CONFIG);
        public static final ConfiguredSurfaceBuilder<SurfaceBuilderBaseConfiguration> LUNAR_GRASS_SURFACE_BUILDER = SurfaceBuilder.f_75214_.m_75223_((SurfaceBuilderConfiguration)LUNAR_GRASS_DIRT_SAND_CONFIG);
        public static final ConfiguredSurfaceBuilder<SurfaceBuilderBaseConfiguration> MIDNIGHT_SAND_SURFACE_BUILDER = SurfaceBuilder.f_75214_.m_75223_((SurfaceBuilderConfiguration)MIDNIGHT_SAND_SANDSTONE_SAND_CONFIG);
        public static final ConfiguredSurfaceBuilder<SurfaceBuilderBaseConfiguration> CRYSTAL_SAND_SURFACE_BUILDER = SurfaceBuilder.f_75214_.m_75223_((SurfaceBuilderConfiguration)CRYSTAL_SAND_SANDSTONE_DIRT_CONFIG);
        public static final ConfiguredSurfaceBuilder<SurfaceBuilderBaseConfiguration> CRYSTAL_ROUGHS_SURFACE_BUILDER = ROUGHS.m_75223_((SurfaceBuilderConfiguration)LUNAR_GRASS_DIRT_SAND_CONFIG);
        public static final ConfiguredSurfaceBuilder<SurfaceBuilderBaseConfiguration> COARSE_TURQUOISE_SURFACE_BUILDER = TURQUOISE_COARSE_MIX.m_75223_((SurfaceBuilderConfiguration)TURQUOISE_COARSE_DIRT_SAND_CONFIG);
        public static final ConfiguredSurfaceBuilder<SurfaceBuilderBaseConfiguration> COARSE_LUNAR_SURFACE_BUILDER = SurfaceBuilder.f_75214_.m_75223_((SurfaceBuilderConfiguration)LUNAR_COARSE_DIRT_SAND_CONFIG);
        public static final ConfiguredSurfaceBuilder<SurfaceBuilderBaseConfiguration> MOONLIT_RESERVOIR_SURFACE_BUILDER = RESERVOIR.m_75223_((SurfaceBuilderConfiguration)LUNAR_GRASS_DIRT_SAND_CONFIG);

        public static void init(RegistryEvent.Register<SurfaceBuilder<?>> event) {
            SkiesRegistry.register(event.getRegistry(), "roughs", ROUGHS);
            SkiesRegistry.register(event.getRegistry(), "turquoise_coarse_mix", TURQUOISE_COARSE_MIX);
            SkiesRegistry.register(event.getRegistry(), "reservoir", RESERVOIR);
        }
    }
}

