/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.network.s_to_c;

import com.legacy.blue_skies.capability.SkiesPlayer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class UpdateBlueLorePacket {
    private boolean usedLore;

    public UpdateBlueLorePacket(boolean usedLore) {
        this.usedLore = usedLore;
    }

    public static void encoder(UpdateBlueLorePacket packet, FriendlyByteBuf buff) {
        buff.writeBoolean(packet.usedLore);
    }

    public static UpdateBlueLorePacket decoder(FriendlyByteBuf buff) {
        return new UpdateBlueLorePacket(buff.readBoolean());
    }

    public static void handler(UpdateBlueLorePacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> UpdateBlueLorePacket.handlePacket(packet)));
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handlePacket(UpdateBlueLorePacket packet) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        SkiesPlayer.ifPresent(player, skiesPlayer -> skiesPlayer.setUsedBlueLore(packet.usedLore));
    }
}

