/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.network.s_to_c;

import com.legacy.blue_skies.capability.SkiesPlayer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class SyncPlayerPacket {
    private final CompoundTag nbt;

    public SyncPlayerPacket(CompoundTag nbt) {
        this.nbt = nbt;
    }

    public static void encoder(SyncPlayerPacket packet, FriendlyByteBuf buff) {
        buff.m_130079_(packet.nbt);
    }

    public static SyncPlayerPacket decoder(FriendlyByteBuf buff) {
        return new SyncPlayerPacket(buff.m_130260_());
    }

    public static void handler(SyncPlayerPacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> SyncPlayerPacket.handleClient(packet)));
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleClient(SyncPlayerPacket packet) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        SkiesPlayer.ifPresent(player, skyPlayer -> skyPlayer.read(packet.nbt));
    }
}

