/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.network.s_to_c;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.client.gui.screen.journal.BlueJournalScreen;
import com.legacy.blue_skies.data.BlueSkiesData;
import com.legacy.blue_skies.data.managers.SkiesSyncedDataManager;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class SyncDataRegistryPacket {
    private final byte id;
    private final SkiesSyncedDataManager<?, ?, ?> manager;

    public SyncDataRegistryPacket(int id, SkiesSyncedDataManager<?, ?, ?> manager) {
        this.id = (byte)id;
        this.manager = manager;
    }

    public static void encoder(SyncDataRegistryPacket packet, FriendlyByteBuf buff) {
        buff.writeByte((int)packet.id);
        buff.m_130079_(packet.manager.toNBT());
    }

    public static SyncDataRegistryPacket decoder(FriendlyByteBuf buff) {
        byte id = buff.readByte();
        CompoundTag data = buff.m_130260_();
        return new SyncDataRegistryPacket(id, (SkiesSyncedDataManager<?, ?, ?>)((Object)BlueSkiesData.getSyncedManager(id).fromNBT(data)));
    }

    public static void handler(SyncDataRegistryPacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            BlueJournalScreen.savedScreen = null;
            BlueSkiesData.getSyncedManager(packet.id).setData(packet.manager);
            BlueSkies.LOGGER.info("Recieved {} from the server", (Object)packet.manager.m_7812_());
        }));
        context.get().setPacketHandled(true);
    }
}

