/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.network.s_to_c;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.registries.SkiesParticles;
import com.legacy.blue_skies.util.LogicUtil;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class SpawnParticlePacket {
    private final byte id;
    private final float x;
    private final float y;
    private final float z;

    public SpawnParticlePacket(byte id, BlockPos pos) {
        this.id = id;
        this.x = pos.m_123341_();
        this.y = pos.m_123342_();
        this.z = pos.m_123343_();
    }

    public SpawnParticlePacket(byte id, Vec3 vec) {
        this.id = id;
        this.x = (float)vec.f_82479_;
        this.y = (float)vec.f_82480_;
        this.z = (float)vec.f_82481_;
    }

    public static void encoder(SpawnParticlePacket packet, FriendlyByteBuf buff) {
        buff.writeByte((int)packet.id);
        buff.writeFloat(packet.x);
        buff.writeFloat(packet.y);
        buff.writeFloat(packet.z);
    }

    public static SpawnParticlePacket decoder(FriendlyByteBuf buff) {
        return new SpawnParticlePacket(buff.readByte(), new Vec3((double)buff.readFloat(), (double)buff.readFloat(), (double)buff.readFloat()));
    }

    public static void handler(SpawnParticlePacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> SpawnParticlePacket.handlePacket(packet)));
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handlePacket(SpawnParticlePacket packet) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        switch (packet.id) {
            case 0: {
                double spread = 0.3f;
                double speed = 0.02f;
                for (int i = 0; i < 6; ++i) {
                    double x = LogicUtil.plusOrMinus((double)(packet.x + 0.5f), spread, world.f_46441_);
                    double y = LogicUtil.plusOrMinus((double)(packet.y + 0.5f), spread, world.f_46441_);
                    double z = LogicUtil.plusOrMinus((double)(packet.z + 0.5f), spread, world.f_46441_);
                    double dx = LogicUtil.plusOrMinus(speed, world.f_46441_);
                    double dy = LogicUtil.plusOrMinus(speed, world.f_46441_);
                    double dz = LogicUtil.plusOrMinus(speed, world.f_46441_);
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123744_, x, y, z, dx, dy, dz);
                }
                break;
            }
            case 1: {
                double speed = 0.02f;
                for (int i = 0; i < 1; ++i) {
                    double x = LogicUtil.plusOrMinus(packet.x, 0.3f, world.f_46441_);
                    double y = LogicUtil.plusOrMinus(packet.y + 0.25f, 0.5f, world.f_46441_);
                    double z = LogicUtil.plusOrMinus(packet.z, 0.3f, world.f_46441_);
                    double dx = LogicUtil.plusOrMinus(speed, world.f_46441_);
                    double dy = LogicUtil.plusOrMinus(speed, world.f_46441_);
                    double dz = LogicUtil.plusOrMinus(speed, world.f_46441_);
                    world.m_7106_((ParticleOptions)SkiesParticles.DUSK_SMOKE, x, y, z, dx, dy, dz);
                }
                break;
            }
            default: {
                BlueSkies.LOGGER.warn("Trying to spawn particle with unknown id: " + packet.id);
            }
        }
    }
}

