/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.network.s_to_c;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class IllagerTeleportPacket {
    private int entityId;
    private BlockPos teleportingPos;

    public IllagerTeleportPacket(int entityIdIn, BlockPos teleportingPosIn) {
        this.entityId = entityIdIn;
        this.teleportingPos = teleportingPosIn;
    }

    public static void encoder(IllagerTeleportPacket packet, FriendlyByteBuf buff) {
        buff.writeInt(packet.entityId);
        buff.m_130064_(packet.teleportingPos);
    }

    public static IllagerTeleportPacket decoder(FriendlyByteBuf buff) {
        return new IllagerTeleportPacket(buff.readInt(), buff.m_130135_());
    }

    public static void handler(IllagerTeleportPacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> IllagerTeleportPacket.handlePacket(packet)));
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handlePacket(IllagerTeleportPacket packet) {
        Entity boss = Minecraft.m_91087_().f_91073_.m_6815_(packet.entityId);
        boss.m_6021_((double)packet.teleportingPos.m_123341_(), (double)packet.teleportingPos.m_123342_(), (double)packet.teleportingPos.m_123343_());
    }
}

