/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.network.s_to_c;

import com.legacy.blue_skies.capability.SkiesPlayer;
import com.legacy.blue_skies.entities.util.SkiesDungeonType;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class BossTypePacket {
    private byte type;

    public BossTypePacket(byte type) {
        this.type = type;
    }

    public static void encoder(BossTypePacket packet, FriendlyByteBuf buff) {
        buff.writeByte((int)packet.type);
    }

    public static BossTypePacket decoder(FriendlyByteBuf buff) {
        return new BossTypePacket(buff.readByte());
    }

    public static void handler(BossTypePacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> BossTypePacket.handlePacket(packet)));
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handlePacket(BossTypePacket packet) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        SkiesPlayer.ifPresent(player, skyPlayer -> skyPlayer.setBossType(SkiesDungeonType.getFromId(packet.type)));
    }
}

