/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.network.c_to_s;

import com.legacy.blue_skies.capability.SkiesPlayer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class SpawnSupporterPetPacket {
    private byte petID;
    private boolean petEnabled;
    private boolean petAudible;
    private String petName;
    private byte styleID;

    public SpawnSupporterPetPacket(byte petIdIn, boolean petEnabledIn, boolean petAudibleIn, String petNameIn, byte styleIdIn) {
        this.petID = petIdIn;
        this.petEnabled = petEnabledIn;
        this.petAudible = petAudibleIn;
        this.petName = petNameIn;
        this.styleID = styleIdIn;
    }

    public static void encoder(SpawnSupporterPetPacket packet, FriendlyByteBuf buff) {
        buff.writeByte((int)packet.petID);
        buff.writeBoolean(packet.petEnabled);
        buff.writeBoolean(packet.petAudible);
        buff.m_130070_(packet.petName);
        buff.writeByte((int)packet.styleID);
    }

    public static SpawnSupporterPetPacket decoder(FriendlyByteBuf buff) {
        return new SpawnSupporterPetPacket(buff.readByte(), buff.readBoolean(), buff.readBoolean(), buff.m_130136_(16), buff.readByte());
    }

    public static void handler(SpawnSupporterPetPacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> SpawnSupporterPetPacket.handlePacket(packet, (Player)((NetworkEvent.Context)context.get()).getSender()));
        context.get().setPacketHandled(true);
    }

    private static void handlePacket(SpawnSupporterPetPacket packet, Player player) {
        SkiesPlayer.ifPresent(player, skyPlayer -> {
            skyPlayer.setSupporterPetID(packet.petID);
            skyPlayer.setSupporterPetEnabled(packet.petEnabled);
            skyPlayer.setSupporterPetAudible(packet.petAudible);
            skyPlayer.setSupporterPetName(packet.petName);
            skyPlayer.setSupporterStyleID(packet.styleID);
        });
    }
}

