/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.items.util;

import com.google.common.collect.Streams;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.data.objects.SkiesItemTags;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.util.Lazy;

public enum SkiesArmorMaterial implements ArmorMaterial
{
    PYROPE("pyrope", 15, new int[]{1, 4, 5, 2}, 12, SoundEvents.f_11677_, 0.0f, () -> Ingredient.m_43911_(SkiesItemTags.PYROPE), true),
    AQUITE("aquite", 15, new int[]{2, 5, 6, 2}, 9, SoundEvents.f_11677_, 0.0f, () -> Ingredient.m_43911_(SkiesItemTags.AQUITE), true),
    HORIZONITE("horizonite", 15, new int[]{1, 4, 5, 2}, 12, SoundEvents.f_11676_, 0.0f, () -> Ingredient.m_43911_(SkiesItemTags.HORIZONITE), true),
    DIOPSIDE("diopside", 36, new int[]{2, 5, 7, 2}, 9, SoundEvents.f_11673_, 4.5f, () -> Ingredient.m_43911_(SkiesItemTags.DIOPSIDE), true),
    CHAROITE("charoite", 33, new int[]{3, 6, 8, 3}, 10, SoundEvents.f_11673_, 2.0f, () -> Ingredient.m_43911_(SkiesItemTags.CHAROITE), true),
    SHADOW("shadow", 35, new int[]{3, 6, 8, 3}, 10, SoundEvents.f_11673_, 3.0f, () -> Ingredient.m_43938_((Stream)Streams.concat((Stream[])new Stream[]{Stream.of(new Ingredient.TagValue(SkiesItemTags.CHAROITE)), Stream.of(new Ingredient.TagValue((Tag)Tags.Items.GEMS_DIAMOND))})), true);

    private static final int[] MAX_DAMAGE_ARRAY;
    private final String name;
    private final int maxDamageFactor;
    private final int[] damageReductionAmountArray;
    private final int enchantability;
    private final SoundEvent soundEvent;
    private final float toughness;
    private final boolean compatWithFalsite;
    private final Lazy<Ingredient> repairMaterial;

    private SkiesArmorMaterial(String nameIn, int maxDamage, int[] damageReductionArray, int enchantability, SoundEvent equipSound, float toughness, Supplier<Ingredient> repairMaterial, boolean compatWithFalsite) {
        this.name = BlueSkies.find(nameIn);
        this.maxDamageFactor = maxDamage;
        this.damageReductionAmountArray = damageReductionArray;
        this.enchantability = enchantability;
        this.soundEvent = equipSound;
        this.toughness = toughness;
        this.repairMaterial = Lazy.of(repairMaterial);
        this.compatWithFalsite = compatWithFalsite;
    }

    public int m_7366_(EquipmentSlot slotIn) {
        return MAX_DAMAGE_ARRAY[slotIn.m_20749_()] * this.maxDamageFactor;
    }

    public int m_7365_(EquipmentSlot slotIn) {
        return this.damageReductionAmountArray[slotIn.m_20749_()];
    }

    public int m_6646_() {
        return this.enchantability;
    }

    public SoundEvent m_7344_() {
        return this.soundEvent;
    }

    public Ingredient m_6230_() {
        return (Ingredient)this.repairMaterial.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public String m_6082_() {
        return this.name;
    }

    public float m_6651_() {
        return this.toughness;
    }

    public boolean isCompatWithFalsite() {
        return this.compatWithFalsite;
    }

    public float m_6649_() {
        return 0.0f;
    }

    static {
        MAX_DAMAGE_ARRAY = new int[]{13, 15, 16, 11};
    }
}

