/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.items.util;

import com.legacy.blue_skies.items.util.SkiesArmorMaterial;
import com.legacy.blue_skies.items.util.SkiesItemTier;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraftforge.common.extensions.IForgeItem;

public interface IFalsiteItem
extends IForgeItem {
    public static final String FALSITE_KEY = "Falsite";

    default public <T extends LivingEntity> int damageItemFalsite(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        int falsiteUses = IFalsiteItem.getFalsiteUses(stack);
        if (falsiteUses > 0) {
            IFalsiteItem.setFalsiteUses(stack, falsiteUses -= amount);
            if (falsiteUses <= 0) {
                onBroken.accept(entity);
                return Math.abs(falsiteUses);
            }
            return 0;
        }
        return amount;
    }

    public static ItemStack applyFalsite(ItemStack stack) {
        stack.m_41784_().m_128405_(FALSITE_KEY, IFalsiteItem.getMaxFalsiteUses(stack));
        return stack;
    }

    public static int getMaxFalsiteUses(ItemStack stack) {
        return Math.max(Math.floorDiv(stack.m_41776_(), 5), 30);
    }

    public static void setFalsiteUses(ItemStack stack, int value) {
        stack.m_41784_().m_128405_(FALSITE_KEY, Math.max(value, 0));
    }

    public static int getFalsiteUses(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            return tag.m_128451_(FALSITE_KEY);
        }
        return 0;
    }

    public static boolean hasUses(ItemStack stack) {
        return IFalsiteItem.getFalsiteUses(stack) > 0;
    }

    default public boolean isFalsiteCompatible(ItemStack stack) {
        if (stack.m_41720_() instanceof TieredItem) {
            Tier tier = ((TieredItem)stack.m_41720_()).m_43314_();
            if (tier instanceof SkiesItemTier) {
                return ((SkiesItemTier)tier).isCompatWithFalsite();
            }
            return false;
        }
        if (stack.m_41720_() instanceof ArmorItem) {
            ArmorMaterial material = ((ArmorItem)stack.m_41720_()).m_40401_();
            if (material instanceof SkiesArmorMaterial) {
                return ((SkiesArmorMaterial)material).isCompatWithFalsite();
            }
            return false;
        }
        return false;
    }

    default public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return this.isFalsiteCompatible(stack) ? this.damageItemFalsite(stack, amount, entity, onBroken) : amount;
    }

    default public int getRGBDurabilityForDisplay(ItemStack stack) {
        return IFalsiteItem.hasUses(stack) ? Mth.m_14169_((float)0.5f, (float)1.0f, (float)1.0f) : Mth.m_14169_((float)(Math.max(0.0f, (float)(1.0 - this.getDurabilityForDisplay(stack))) / 3.0f), (float)1.0f, (float)1.0f);
    }

    default public boolean showDurabilityBar(ItemStack stack) {
        return IFalsiteItem.hasUses(stack) ? true : stack.m_41768_();
    }

    default public double getDurabilityForDisplay(ItemStack stack) {
        double falsiteDur = ((double)IFalsiteItem.getMaxFalsiteUses(stack) - (double)IFalsiteItem.getFalsiteUses(stack)) / (double)IFalsiteItem.getMaxFalsiteUses(stack);
        double normalDur = (double)stack.m_41773_() / (double)stack.m_41776_();
        return IFalsiteItem.hasUses(stack) ? falsiteDur : normalDur;
    }
}

