/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.items.tools;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.legacy.blue_skies.data.objects.SkiesItemTags;
import com.legacy.blue_skies.items.util.ICustomHandleItem;
import com.legacy.blue_skies.items.util.IFalsiteItem;
import com.legacy.blue_skies.items.util.ToolUtils;
import com.legacy.blue_skies.registries.SkiesItems;
import com.legacy.blue_skies.util.StringUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SkyShovelItem
extends ShovelItem
implements IFalsiteItem,
ICustomHandleItem {
    private final float attackSpeed;

    public SkyShovelItem(Tier tier, float attackDamageIn, float attackSpeedIn, Item.Properties builder) {
        super(tier, attackDamageIn, attackSpeedIn, builder);
        this.attackSpeed = attackSpeedIn;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> lore, TooltipFlag flagIn) {
        if (this == SkiesItems.horizonite_shovel) {
            lore.add((Component)new TextComponent(StringUtil.getAbilityText("gui.blue_skies.item.ability.smelt")));
        }
    }

    public int getMaxDamage(ItemStack stack) {
        return ToolUtils.getMaxDurability(this.m_43314_(), stack);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (SkiesItemTags.HORIZONITE_TOOLS.m_8110_((Object)stack.m_41720_())) {
            target.m_20254_(3);
        }
        return super.m_7579_(stack, target, attacker);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot equipmentSlot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (equipmentSlot == EquipmentSlot.MAINHAND) {
            multimap.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.m_41008_(), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)ToolUtils.getAttackSpeed(this.attackSpeed, stack), AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack m_7968_() {
        ItemStack stack = super.m_7968_();
        stack.m_41784_().m_128359_("Stick", Items.f_42398_.getRegistryName().toString());
        return stack;
    }
}

