/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.util.base;

import com.legacy.blue_skies.entities.util.base.SkiesMonsterEntity;
import com.legacy.blue_skies.entities.util.interfaces.ISkyBoss;
import com.legacy.blue_skies.network.PacketHandler;
import com.legacy.blue_skies.network.s_to_c.BossTypePacket;
import com.legacy.blue_skies.registries.SkiesItems;
import com.legacy.blue_skies.util.EntityUtil;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;

public abstract class SkiesBossEntity
extends SkiesMonsterEntity
implements ISkyBoss {
    protected static final EntityDataAccessor<Boolean> DUNGEON_SPAWNED = SynchedEntityData.m_135353_(SkiesBossEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Integer> INVULNERABILITY_TIME = SynchedEntityData.m_135353_(SkiesBossEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Boolean> RESPAWNED = SynchedEntityData.m_135353_(SkiesBossEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Byte> DIFFICULTY_ID = SynchedEntityData.m_135353_(SkiesBossEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected BlockPos homePos;
    private final ServerBossEvent bossInfo = this.getNewBossInfo();

    public SkiesBossEntity(EntityType<? extends SkiesBossEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new DoNothingGoal());
    }

    public void m_6478_(MoverType type, Vec3 vec) {
        if (this.getInvulTime() <= 0) {
            super.m_6478_(type, vec);
        } else {
            super.m_6478_(type, new Vec3(0.0, vec.f_82480_, 0.0));
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DUNGEON_SPAWNED, (Object)false);
        this.f_19804_.m_135372_(INVULNERABILITY_TIME, (Object)0);
        this.f_19804_.m_135372_(RESPAWNED, (Object)false);
        this.f_19804_.m_135372_(DIFFICULTY_ID, (Object)1);
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        SpawnGroupData flag = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        if (!this.f_19853_.f_46443_) {
            this.defaultSpawningRoutine(difficultyIn);
        }
        return flag;
    }

    public void m_20258_(CompoundTag compound) {
        super.m_20258_(compound);
        this.readDefaultBossNBT(compound);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        this.writeDefaultBossNBT(compound);
    }

    public void m_8119_() {
        super.m_8119_();
        this.bossTick();
    }

    @Override
    public ServerBossEvent getBossInfo() {
        return this.bossInfo;
    }

    public void m_6593_(Component name) {
        super.m_6593_(name);
        this.getBossInfo().m_6456_((Component)this.m_5446_().m_6879_().m_7220_(ISkyBoss.getDifficultyDecoration(this.getDifficultyID())));
    }

    public void m_6457_(ServerPlayer player) {
        PacketHandler.sendToClient(new BossTypePacket((byte)this.getBossType().getId()), player);
        super.m_6457_(player);
        this.getBossInfo().m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.getBossInfo().m_6539_(player);
    }

    public boolean m_6072_() {
        return false;
    }

    public boolean m_8023_() {
        return true;
    }

    protected float m_6121_() {
        return 2.0f;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source) || this.getInvulTime() > 0 && source != DamageSource.f_19317_) {
            return false;
        }
        if (source.m_7639_() instanceof Player) {
            Player player = (Player)source.m_7639_();
            ItemStack stack = player.m_150109_().m_36056_();
            if (source.m_19390_()) {
                return super.m_6469_(source, amount);
            }
            if (stack.m_41720_() == SkiesItems.debug_sword) {
                return false;
            }
            return super.m_6469_(source, Math.min((float)this.getDamageCap(), amount));
        }
        return super.m_6469_(source, amount);
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        this.onBossDeath(source);
    }

    @Override
    public void setHome(BlockPos pos) {
        this.homePos = pos;
    }

    @Override
    public BlockPos getHome() {
        if (!this.isDungeonSpawned() || this.homePos == null || this.homePos != null && this.homePos == BlockPos.f_121853_) {
            return this.m_142538_();
        }
        return this.homePos;
    }

    @Override
    public boolean isDungeonSpawned() {
        return (Boolean)this.f_19804_.m_135370_(DUNGEON_SPAWNED);
    }

    @Override
    public void setDungeonSpawned(boolean isDungeonSpawned) {
        this.f_19804_.m_135381_(DUNGEON_SPAWNED, (Object)isDungeonSpawned);
    }

    @Override
    public boolean isBossRespawned() {
        return (Boolean)this.f_19804_.m_135370_(RESPAWNED);
    }

    @Override
    public void setBossRespawned(boolean isRespawned) {
        this.f_19804_.m_135381_(RESPAWNED, (Object)isRespawned);
    }

    @Override
    public int getInvulTime() {
        return (Integer)this.f_19804_.m_135370_(INVULNERABILITY_TIME);
    }

    @Override
    public void setInvulTime(int time) {
        this.f_19804_.m_135381_(INVULNERABILITY_TIME, (Object)time);
    }

    @Override
    public byte getDifficultyID() {
        return (Byte)this.f_19804_.m_135370_(DIFFICULTY_ID);
    }

    @Override
    public void setDifficultyID(byte id) {
        this.f_19804_.m_135381_(DIFFICULTY_ID, (Object)((byte)Math.min(3, id)));
    }

    public float getDistanceToPos(double x, double y, double z) {
        return EntityUtil.getDistanceToPos((Vec3i)this.m_142538_(), (Vec3i)new BlockPos(x, y, z));
    }

    public float getDistanceToPos(BlockPos pos) {
        return EntityUtil.getDistanceToPos((Vec3i)this.m_142538_(), (Vec3i)pos);
    }

    @Override
    public Monster getBoss() {
        return this;
    }

    class DoNothingGoal
    extends Goal {
        public DoNothingGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return SkiesBossEntity.this.getInvulTime() > 0;
        }
    }
}

