/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.projectile;

import com.legacy.blue_skies.client.particle.data.PoisonData;
import com.legacy.blue_skies.registries.SkiesEffects;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.util.EntityUtil;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.LlamaSpit;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.fmllegacy.network.FMLPlayMessages;
import net.minecraftforge.fmllegacy.network.NetworkHooks;

public class VenomSpitEntity
extends LlamaSpit {
    protected static final EntityDataAccessor<Boolean> DEADLY = SynchedEntityData.m_135353_(VenomSpitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public VenomSpitEntity(EntityType<? extends VenomSpitEntity> type, Level world) {
        super(type, world);
    }

    public VenomSpitEntity(Level worldIn, LivingEntity spider) {
        this(worldIn, spider, true);
    }

    public VenomSpitEntity(Level worldIn, LivingEntity spider, boolean spawnOffsetted) {
        this(SkiesEntityTypes.VENOM_SPIT, worldIn);
        super.m_5602_((Entity)spider);
        if (spawnOffsetted) {
            this.m_6034_(spider.m_20185_() - (double)(spider.m_20205_() + 1.0f) * 0.5 * (double)Mth.m_14031_((float)(spider.f_20883_ * ((float)Math.PI / 180))), spider.m_20186_() + (double)spider.m_20192_() - (double)0.1f, spider.m_20189_() + (double)(spider.m_20205_() + 1.0f) * 0.5 * (double)Mth.m_14089_((float)(spider.f_20883_ * ((float)Math.PI / 180))));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public VenomSpitEntity(Level worldIn, double x, double y, double z, double xDir, double yDir, double zDir) {
        this(SkiesEntityTypes.VENOM_SPIT, worldIn);
        this.m_6034_(x, y, z);
        for (int i = 0; i < 7; ++i) {
            double d0 = 0.4 + 0.1 * (double)i;
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123764_, x, y, z, xDir * d0, yDir, zDir * d0);
        }
        this.m_20334_(xDir, yDir, zDir);
    }

    public VenomSpitEntity(FMLPlayMessages.SpawnEntity spawnEntity, Level world) {
        this(SkiesEntityTypes.VENOM_SPIT, world);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            this.spawnParticles();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnParticles() {
        for (int i = 0; i < 6; ++i) {
            float dx = (this.f_19796_.nextFloat() - 0.5f) / 7.0f;
            float dy = this.f_19796_.nextFloat() / 10.0f;
            float dz = (this.f_19796_.nextFloat() - 0.5f) / 7.0f;
            this.f_19853_.m_7106_((ParticleOptions)new PoisonData(false), (double)this.m_142538_().m_123341_() + 0.5, (double)((float)this.m_142538_().m_123342_() + 0.5f), (double)this.m_142538_().m_123343_() + 0.5, (double)dx, (double)dy, (double)dz);
        }
    }

    public void m_6686_(double x, double y, double z, float velocity, float inaccuracy) {
        Vec3 vec3d = new Vec3(x, y, z).m_82541_().m_82520_(this.f_19796_.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.f_19796_.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.f_19796_.nextGaussian() * (double)0.0075f * (double)inaccuracy).m_82490_((double)velocity);
        this.m_20256_(vec3d);
        double f = vec3d.m_165924_();
        this.m_146922_((float)(Mth.m_14136_((double)vec3d.f_82479_, (double)z) * 57.2957763671875));
        this.m_146922_((float)(Mth.m_14136_((double)vec3d.f_82480_, (double)f) * 57.2957763671875));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }

    protected void m_5790_(EntityHitResult result) {
        Entity owner = this.m_37282_();
        Entity target = result.m_82443_();
        if (owner != null && target != null && !owner.m_7307_(target)) {
            if (this.isDeadly()) {
                Entity durration2;
                boolean attack = target.m_6469_(EntityUtil.DamageSources.causeIndirectVenomDamage((Entity)this, owner), 3.0f);
                Entity entity = target;
                if (entity instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)entity;
                    if (attack) {
                        int durration2 = 5 * Math.max(3, this.f_19853_.m_46791_().m_19028_() + 1);
                        int amplifier = this.f_19853_.m_46791_().m_19028_() / 2;
                        living.m_7292_(new MobEffectInstance(SkiesEffects.DEADLY_VENOM, durration2, amplifier));
                    }
                }
                if ((durration2 = target) instanceof Player) {
                    ItemStack playerItem;
                    Player playerentity = (Player)durration2;
                    ItemStack itemStack = playerItem = playerentity.m_6117_() ? playerentity.m_21211_() : ItemStack.f_41583_;
                    if (!playerItem.m_41619_() && playerItem.canPerformAction(ToolActions.SHIELD_BLOCK)) {
                        playerentity.m_36384_(true);
                        playerentity.m_36335_().m_41524_(playerItem.m_41720_(), 60);
                        this.f_19853_.m_7605_((Entity)playerentity, (byte)30);
                    }
                }
            } else {
                boolean attack = target.m_6469_(EntityUtil.DamageSources.causeIndirectVenomDamage((Entity)this, owner), 1.0f);
                Entity playerItem = target;
                if (playerItem instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)playerItem;
                    if (attack) {
                        int durration = 20 * (this.f_19853_.m_46791_().m_19028_() + 3);
                        int amplifier = this.f_19853_.m_46791_().m_19028_() / 2;
                        living.m_7292_(new MobEffectInstance(MobEffects.f_19614_, durration, amplifier));
                    }
                }
            }
            if (!this.f_19853_.f_46443_) {
                this.m_146870_();
            }
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DEADLY, (Object)false);
    }

    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setDeadly(compound.m_128471_("Deadly"));
    }

    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Deadly", this.isDeadly());
    }

    public boolean isDeadly() {
        return (Boolean)this.f_19804_.m_135370_(DEADLY);
    }

    public void setDeadly(boolean deadly) {
        this.f_19804_.m_135381_(DEADLY, (Object)deadly);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

