/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.passive;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.BlueSkiesConfig;
import com.legacy.blue_skies.entities.util.base.SkiesAnimalEntity;
import com.legacy.blue_skies.registries.SkiesBiomes;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.legacy.blue_skies.util.BiomeUtil;
import com.legacy.structure_gel.api.util.GelCollectors;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;

public class ShadeMonitorEntity
extends SkiesAnimalEntity {
    private static final float NATURAL_FESTIVE_CHANCE = 0.4f;
    public static final Map<ResourceLocation, Biomes> EXISTING_BIOME_MAP = GelCollectors.mapOf((Object)SkiesBiomes.SEARING_GRASSLAND.getName(), (Object)((Object)Biomes.SUNSET_MAPLE_FOREST), (Object[])new Object[]{SkiesBiomes.CRYSTAL_DUNES_SPIKES.getName(), Biomes.CRYSTAL_DUNES});
    private static final EntityDataAccessor<Byte> BIOME = SynchedEntityData.m_135353_(ShadeMonitorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> FESTIVE_STATUS = SynchedEntityData.m_135353_(ShadeMonitorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public ShadeMonitorEntity(EntityType<? extends ShadeMonitorEntity> type, Level world) {
        super(type, world);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(1, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.5, true));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_43911_((Tag)ItemTags.f_13156_), false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 16.0).m_22268_(Attributes.f_22279_, (double)0.3f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BIOME, (Object)0);
        this.f_19804_.m_135372_(FESTIVE_STATUS, (Object)0);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn, CompoundTag dataTag) {
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setBiome(Biomes.get(this.getBiomeKey()).getId());
        this.setFestiveStatus(this.f_19796_.nextFloat() < 0.4f ? 1 : 0);
        return spawnDataIn;
    }

    public ResourceLocation getBiomeKey() {
        return BiomeUtil.getKeyFromBiome((LevelAccessor)this.f_19853_, this.f_19853_.m_46857_(this.m_142538_())).m_135782_();
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128344_("Biome", this.getBiome());
        compound.m_128405_("FestiveStatus", this.getFestiveStatus());
    }

    public void m_20258_(CompoundTag compound) {
        super.m_20258_(compound);
        this.setBiome(compound.m_128445_("Biome"));
        this.setFestiveStatus(!compound.m_128441_("FestiveStatus") ? (this.f_19796_.nextFloat() < 0.4f ? 1 : 0) : compound.m_128451_("FestiveStatus"));
    }

    public byte getBiome() {
        return (Byte)this.f_19804_.m_135370_(BIOME);
    }

    public void setBiome(byte biome) {
        this.f_19804_.m_135381_(BIOME, (Object)biome);
    }

    public int getFestiveStatus() {
        return (Integer)this.f_19804_.m_135370_(FESTIVE_STATUS);
    }

    public void setFestiveStatus(int flag) {
        this.f_19804_.m_135381_(FESTIVE_STATUS, (Object)flag);
    }

    protected SoundEvent m_7515_() {
        return SkiesSounds.ENTITY_SHADE_MONITOR_IDLE;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SkiesSounds.ENTITY_SHADE_MONITOR_HURT;
    }

    protected SoundEvent m_5592_() {
        return SkiesSounds.ENTITY_SHADE_MONITOR_DEATH;
    }

    protected float m_6121_() {
        return 1.0f;
    }

    @Override
    public boolean m_6898_(ItemStack stack) {
        Item item = stack.m_41720_();
        return item.m_41472_() && item.m_41473_().m_38746_() || stack.m_150922_((Tag)ItemTags.f_13156_);
    }

    public ShadeMonitorEntity createChild(AgeableMob ageable) {
        byte biome = (double)this.f_19796_.nextFloat() < 0.05 ? Biomes.get(this.getBiomeKey()).getId() : (this.f_19796_.nextBoolean() ? ((ShadeMonitorEntity)ageable).getBiome() : this.getBiome());
        ShadeMonitorEntity child = (ShadeMonitorEntity)SkiesEntityTypes.SHADE_MONITOR.m_20615_(this.f_19853_);
        child.setBiome(biome);
        if (BlueSkiesConfig.COMMON.isHalloween() && this.getFestiveStatus() > 0 && ((ShadeMonitorEntity)ageable).getFestiveStatus() > 0) {
            child.setFestiveStatus(2);
        }
        return child;
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return this.m_6162_() ? 0.3f : 0.6f;
    }

    public boolean m_7327_(Entity entityIn) {
        entityIn.m_6469_(DamageSource.m_19370_((LivingEntity)this), 2.0f);
        return true;
    }

    public static enum Biomes {
        OVERWORLD("overworld"),
        EVERBRIGHT("everbright"),
        UNORTHODOX_VALLEY(SkiesBiomes.UNORTHODOX_VALLEY.getName()),
        CRYSTAL_DUNES(SkiesBiomes.CRYSTAL_DUNES.getName()),
        CRYSTAL_ROUGHS(SkiesBiomes.CRYSTAL_ROUGHS.getName()),
        SUNSET_MAPLE_FOREST(SkiesBiomes.SUNSET_MAPLE_FOREST.getName()),
        SHADED_WOODLANDS(SkiesBiomes.SHADED_WOODLANDS.getName()),
        MOONLIT_RESERVOIR(SkiesBiomes.MOONLIT_RESERVOIR.getName());

        private final ResourceLocation biome;
        private final ResourceLocation texture;

        private Biomes(ResourceLocation biome) {
            this.biome = biome;
            this.texture = BlueSkies.locate(String.format("textures/entity/shade_monitor/shade_monitor_%s.png", this.biome.m_135815_()));
        }

        private Biomes(String biome) {
            this.biome = null;
            this.texture = BlueSkies.locate(String.format("textures/entity/shade_monitor/shade_monitor_%s.png", biome));
        }

        public byte getId() {
            return (byte)this.ordinal();
        }

        @Nullable
        public ResourceLocation getBiome() {
            return this.biome;
        }

        public ResourceLocation getTexture() {
            return this.texture;
        }

        public static Biomes get(ResourceLocation biome) {
            for (Biomes b : Biomes.values()) {
                if (b.biome != biome) continue;
                return b;
            }
            if (EXISTING_BIOME_MAP.containsKey(biome)) {
                return EXISTING_BIOME_MAP.get(biome);
            }
            if (SkiesBiomes.EVERBRIGHT_LOCATIONS.contains(biome)) {
                return EVERBRIGHT;
            }
            if (SkiesBiomes.EVERDAWN_LOCATIONS.contains(biome)) {
                return UNORTHODOX_VALLEY;
            }
            return OVERWORLD;
        }

        public static Biomes byId(int id) {
            if (id < 0 || id >= Biomes.values().length) {
                id = 0;
            }
            return Biomes.values()[id];
        }
    }
}

