/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.hostile;

import com.legacy.blue_skies.entities.passive.CrogreEntity;
import com.legacy.blue_skies.entities.projectile.VenomSpitEntity;
import com.legacy.blue_skies.entities.util.base.SkiesMonsterEntity;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesEffects;
import com.legacy.blue_skies.registries.SkiesSounds;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class VenomSpiderEntity
extends SkiesMonsterEntity
implements RangedAttackMob {
    private static final EntityDataAccessor<Byte> CLIMBING = SynchedEntityData.m_135353_(VenomSpiderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);

    public VenomSpiderEntity(EntityType<? extends VenomSpiderEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(4, (Goal)new SpiderMeleeAttackGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new RangedAttackGoal(this, 0.0, 40, 20.0f){

            public boolean m_8036_() {
                VenomSpiderEntity spider = VenomSpiderEntity.this;
                LivingEntity target = spider.m_5448_();
                if (target == null) {
                    return false;
                }
                return target.m_20270_((Entity)spider) >= 5.0f && super.m_8036_();
            }

            public boolean m_8045_() {
                VenomSpiderEntity spider = VenomSpiderEntity.this;
                LivingEntity target = spider.m_5448_();
                if (target == null) {
                    return false;
                }
                return target.m_20270_((Entity)spider) >= 5.0f && super.m_8045_();
            }
        });
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, new SpiderTargetGoal<Player>(this, Player.class));
        this.f_21346_.m_25352_(3, new SpiderTargetGoal<IronGolem>(this, IronGolem.class));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, CrogreEntity.class, 8.0f, 1.0, 1.0));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 22.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22277_, 20.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CLIMBING, (Object)0);
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        MobEffect effect;
        if (spawnDataIn == null) {
            spawnDataIn = new Spider.SpiderEffectsGroupData();
            if (worldIn.m_46791_() == Difficulty.HARD && worldIn.m_5822_().nextFloat() < 0.1f * difficultyIn.m_19057_()) {
                ((Spider.SpiderEffectsGroupData)spawnDataIn).m_33829_(worldIn.m_5822_());
            }
        }
        if (spawnDataIn instanceof Spider.SpiderEffectsGroupData && (effect = ((Spider.SpiderEffectsGroupData)spawnDataIn).f_33827_) != null) {
            this.m_7292_(new MobEffectInstance(effect, Integer.MAX_VALUE));
        }
        return spawnDataIn;
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new WallClimberNavigation((Mob)this, worldIn);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            this.setBesideClimbableBlock(this.f_19862_);
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
    }

    public void m_20258_(CompoundTag compound) {
        super.m_20258_(compound);
    }

    public double getMountedYOffset() {
        return this.m_20206_() * 0.5f;
    }

    public int m_5792_() {
        return 1;
    }

    @Override
    public float m_5610_(BlockPos pos, LevelReader worldIn) {
        return 0.0f;
    }

    public boolean m_5545_(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        boolean randomBoolean = this.f_19853_.m_46471_() ? true : this.f_19796_.nextBoolean();
        return randomBoolean && super.m_5545_(worldIn, spawnReasonIn);
    }

    protected SoundEvent m_7515_() {
        return SkiesSounds.ENTITY_VENOM_SPIDER_IDLE;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SkiesSounds.ENTITY_VENOM_SPIDER_HURT;
    }

    protected SoundEvent m_5592_() {
        return SkiesSounds.ENTITY_VENOM_SPIDER_DEATH;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12435_, 0.15f, 1.0f);
    }

    public boolean m_6147_() {
        return this.isBesideClimbableBlock();
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public boolean m_7301_(MobEffectInstance potioneffectIn) {
        return potioneffectIn.m_19544_() == MobEffects.f_19614_ ? false : (potioneffectIn.m_19544_() == SkiesEffects.DEADLY_VENOM ? false : super.m_7301_(potioneffectIn));
    }

    public void m_7601_(BlockState stateIn, Vec3 motionVec) {
        if (stateIn.m_60734_() != Blocks.f_50033_ && stateIn.m_60734_() != SkiesBlocks.spider_webbing) {
            super.m_7601_(stateIn, motionVec);
        }
    }

    public boolean isBesideClimbableBlock() {
        return ((Byte)this.f_19804_.m_135370_(CLIMBING) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean climbing) {
        byte b0 = (Byte)this.f_19804_.m_135370_(CLIMBING);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.f_19804_.m_135381_(CLIMBING, (Object)b0);
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        VenomSpitEntity venom = new VenomSpitEntity(this.f_19853_, (LivingEntity)this);
        double d0 = target.m_20185_() - this.m_20185_();
        double d1 = target.m_142469_().f_82289_ + (double)(target.m_20206_() / 3.0f) - venom.m_20186_();
        double d2 = target.m_20189_() - this.m_20189_();
        float f = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2))) * 0.2f;
        venom.m_6686_(d0, d1 + (double)f, d2, 1.5f, 5.0f);
        this.m_5496_(SkiesSounds.ENTITY_VENOM_SPIDER_SPIT, 1.0f, 1.0f + (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f);
        this.f_19853_.m_7967_((Entity)venom);
    }

    public boolean m_7327_(Entity entityIn) {
        if (super.m_7327_(entityIn)) {
            if (entityIn instanceof LivingEntity) {
                int durration = 20 * (Math.min(2, this.f_19853_.m_46791_().m_19028_()) + 3);
                int amplifier = this.f_19853_.m_46791_().m_19028_() / 2;
                ((LivingEntity)entityIn).m_7292_(new MobEffectInstance(MobEffects.f_19614_, durration, amplifier));
            }
            return true;
        }
        return false;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 0.65f;
    }

    static class SpiderMeleeAttackGoal
    extends MeleeAttackGoal {
        public SpiderMeleeAttackGoal(VenomSpiderEntity spider) {
            super((PathfinderMob)spider, 1.0, true);
        }

        public boolean m_8036_() {
            LivingEntity target = this.f_25540_.m_5448_();
            if (target == null) {
                return false;
            }
            return target.m_20270_((Entity)this.f_25540_) < 5.0f && super.m_8036_();
        }

        public boolean m_8045_() {
            LivingEntity target = this.f_25540_.m_5448_();
            if (target == null) {
                return false;
            }
            return target.m_20270_((Entity)this.f_25540_) < 5.0f && super.m_8045_();
        }

        public void m_8037_() {
            super.m_8037_();
            LivingEntity target = this.f_25540_.m_5448_();
            if (target.m_20270_((Entity)this.f_25540_) >= 5.0f) {
                this.m_8041_();
            }
        }

        protected double m_6639_(LivingEntity attackTarget) {
            return 4.0f + attackTarget.m_20205_();
        }
    }

    static class SpiderTargetGoal<T extends LivingEntity>
    extends NearestAttackableTargetGoal<T> {
        public SpiderTargetGoal(VenomSpiderEntity spider, Class<T> classTarget) {
            super((Mob)spider, classTarget, true);
        }

        public boolean m_8036_() {
            return super.m_8036_();
        }

        public void m_8037_() {
            super.m_8037_();
        }
    }
}

