/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.data.providers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.registries.SkiesBiomes;
import com.legacy.blue_skies.registries.SkiesConfiguredCarvers;
import com.legacy.blue_skies.registries.SkiesConfiguredFeatures;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.registries.SkiesParticles;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.legacy.blue_skies.registries.SkiesStructures;
import com.legacy.blue_skies.world.general_features.structures.villages.SkiesVillageBiomes;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.data.worldgen.biome.BiomeReport;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.Logger;

public class SkiesBiomeProv
extends BiomeReport {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Logger LOGGER = BlueSkies.LOGGER;
    protected static Map<ResourceLocation, Biome> BIOMES = new HashMap<ResourceLocation, Biome>();
    private final DataGenerator generator;

    public SkiesBiomeProv(DataGenerator generator) {
        super(generator);
        this.generator = generator;
    }

    public void m_6865_(HashCache cache) {
        Makers.init();
        LOGGER.info("Starting Blue Skies biome gen");
        Path path = this.generator.m_123916_();
        for (Map.Entry<ResourceLocation, Biome> entry : BIOMES.entrySet()) {
            Path path1 = SkiesBiomeProv.createPath(path, entry.getKey());
            Biome biome = entry.getValue();
            Function function = JsonOps.INSTANCE.withEncoder((Encoder)Biome.f_47431_);
            try {
                Optional optional = ((DataResult)function.apply(() -> biome)).result();
                if (optional.isPresent()) {
                    DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)((JsonElement)optional.get()), (Path)path1);
                    continue;
                }
                LOGGER.error("Couldn't serialize biome {}", (Object)path1);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't save biome {}", (Object)path1, (Object)ioexception);
            }
        }
    }

    private static Path createPath(Path pathIn, ResourceLocation locationIn) {
        Path path = pathIn.resolve("data/" + locationIn.m_135827_() + "/worldgen/biome/" + locationIn.m_135815_() + ".json");
        System.out.println(path.toString());
        return path;
    }

    public static class Makers {
        protected static final int BRIGHT_FOLIAGE_COLOR = 7059637;
        protected static final int DAWN_FOLIAGE_COLOR = 12485859;

        public static void init() {
            for (Biome b : ForgeRegistries.BIOMES) {
                if (b.getRegistryName() == null || !b.getRegistryName().m_135827_().equals("blue_skies")) continue;
                BIOMES.put(b.getRegistryName(), b);
            }
        }

        public static Biome calmingSkies() {
            int grassColor = 0xFFFFFF;
            int foliageColor = 7059637;
            int waterColor = 2903689;
            int waterFogColor = 2903689;
            int skyColor = 9684223;
            float depth = 1.3f;
            float scale = 0.2f;
            float temp = 0.3f;
            float downfall = 0.0f;
            MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.STARDUST_RAM, 8, 2, 4));
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.AZULFO, 6, 4, 4));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.ARMORED_FROST_SPIRIT, 3, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.POLARGEIST, 2, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.DIOPHYDE_PROWLER, 1, 1, 2));
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder().m_47851_(SkiesBiomes.SurfaceBuilders.TURQUOISE_GRASS_SURFACE_BUILDER);
            builder.m_47849_(SkiesStructures.EVERBRIGHT_BLINDING_DUNGEON.getStructureFeature());
            builder.m_47849_(SkiesStructures.BLUE_SKIES_VILLAGE.getStructureFeature(SkiesVillageBiomes.CALMING_SKIES.toString()));
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.CALMING_SKIES_BLUEBRIGHT_TREE);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.CALMING_SKIES_STARLIT_TREE);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.TURQUOISE_GRASS_NOISE);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.POLAR_POSY_3);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.BRITTLEBUSH_3);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.CALMING_SKIES_CAVE_DRIPSTONE);
            SkiesConfiguredFeatures.addDefaultBrightOres(builder);
            SkiesConfiguredFeatures.addBrightLakes(builder);
            SkiesConfiguredFeatures.addFreezeTopLayer(builder);
            SkiesConfiguredFeatures.addGeneralBrightFeatures(builder);
            SkiesConfiguredFeatures.addBrightFlowers(builder);
            SkiesConfiguredFeatures.addFalsiteOre(builder);
            return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47595_(Biome.BiomeCategory.NONE).m_47593_(depth).m_47607_(scale).m_47609_(temp).m_47611_(downfall).m_47603_(Makers.createAmbienceBuilder(grassColor, foliageColor, waterColor, waterFogColor, skyColor).m_48018_()).m_47605_(spawns.m_48381_()).m_47601_(builder.m_47831_()).m_47592_();
        }

        public static Biome brightlands() {
            int grassColor = 14016767;
            int foliageColor = 7059637;
            int waterColor = 2903689;
            int waterFogColor = 2903689;
            int skyColor = 9684223;
            float depth = 1.8f;
            float scale = 0.5f;
            float temp = 0.0f;
            float downfall = 0.8f;
            MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.STARDUST_RAM, 8, 2, 4));
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.REINDEER, 4, 2, 3));
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.AZULFO, 6, 4, 4));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.ARMORED_FROST_SPIRIT, 3, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.CRYNOCEROUS, 1, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.POLARGEIST, 2, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.DIOPHYDE_PROWLER, 1, 1, 2));
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder().m_47851_(SkiesBiomes.SurfaceBuilders.TURQUOISE_GRASS_SURFACE_BUILDER);
            builder.m_47849_(SkiesStructures.EVERBRIGHT_BLINDING_DUNGEON.getStructureFeature());
            builder.m_47849_(SkiesStructures.BLUE_SKIES_VILLAGE.getStructureFeature(SkiesVillageBiomes.BRIGHTLANDS.toString()));
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.BRIGHTLANDS_FALLEN_LOG);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.BRIGHTLANDS_STARLIT_TREE);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.SNOWBLOOM_2);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.CHILLWEED_3);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.TURQUOISE_GRASS_3);
            builder.m_47842_(GenerationStep.Decoration.UNDERGROUND_DECORATION, SkiesConfiguredFeatures.BRIGHTLANDS_CAVE_GRASS);
            builder.m_47842_(GenerationStep.Decoration.UNDERGROUND_DECORATION, SkiesConfiguredFeatures.BRIGHTLANDS_GIANT_CAVE_ICICLE);
            builder.m_47842_(GenerationStep.Decoration.UNDERGROUND_DECORATION, SkiesConfiguredFeatures.BRIGHTLANDS_CAVE_WALL);
            SkiesConfiguredFeatures.addDefaultBrightOres(builder);
            SkiesConfiguredFeatures.addEmeraldOre(builder, true);
            SkiesConfiguredFeatures.addBrightLakes(builder);
            SkiesConfiguredFeatures.addGeneralBrightFeatures(builder);
            SkiesConfiguredFeatures.addFreezeTopLayer(builder);
            SkiesConfiguredFeatures.addBrightFlowers(builder);
            SkiesConfiguredFeatures.addSprings(builder, false);
            return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.SNOW).m_47595_(Biome.BiomeCategory.NONE).m_47593_(depth).m_47607_(scale).m_47609_(temp).m_47611_(downfall).m_47603_(Makers.createAmbienceBuilder(grassColor, foliageColor, waterColor, waterFogColor, skyColor).m_48018_()).m_47605_(spawns.m_48381_()).m_47601_(builder.m_47831_()).m_47592_();
        }

        public static Biome slushlands() {
            int grassColor = 12119807;
            int foliageColor = 7059637;
            int waterColor = 2903689;
            int waterFogColor = 2903689;
            int skyColor = 7252691;
            float depth = -0.2f;
            float scale = 0.1f;
            float temp = 0.5f;
            float downfall = 0.0f;
            MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.STARDUST_RAM, 8, 2, 4));
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.AZULFO, 6, 4, 4));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.ARMORED_FROST_SPIRIT, 3, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.POLARGEIST, 2, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.SHRUMPTY, 2, 1, 1));
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder().m_47851_(SkiesBiomes.SurfaceBuilders.COARSE_TURQUOISE_SURFACE_BUILDER);
            builder.m_47849_(SkiesStructures.BUNKER.getStructureFeature());
            builder.m_47849_(SkiesStructures.BLUE_SKIES_VILLAGE.getStructureFeature(SkiesVillageBiomes.SLUSHLANDS.toString()));
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.SLUSHLANDS_LARGE_SNOWCAP_MUSHROOM);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.SLUSHLANDS_SNOWCAP_MUSHROOM);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.SLUSHLANDS_CHILLED_LILY);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.PATCHY_SNOW);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.TALL_TURQUOISE_GRASS_NOISE);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.BRITTLEBUSH_5);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.SNOWCAP_PINHEAD_8);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.TURQUOISE_GRASS_5);
            builder.m_47842_(GenerationStep.Decoration.UNDERGROUND_DECORATION, SkiesConfiguredFeatures.SLUSHLANDS_CAVE_WALL);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.SLUSHLANDS_CAVE_BLUEBRIGHT_VINE);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.SLUSHLANDS_CAVE_PINHEAD);
            SkiesConfiguredFeatures.addDefaultBrightOres(builder);
            SkiesConfiguredFeatures.addFreezeTopLayer(builder);
            SkiesConfiguredFeatures.addGeneralBrightFeatures(builder);
            SkiesConfiguredFeatures.addFalsiteOre(builder);
            SkiesConfiguredFeatures.addVentiumOre(builder);
            return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47595_(Biome.BiomeCategory.NONE).m_47593_(depth).m_47607_(scale).m_47609_(temp).m_47611_(downfall).m_47603_(Makers.createAmbienceBuilder(grassColor, foliageColor, waterColor, waterFogColor, skyColor).m_48018_()).m_47605_(spawns.m_48381_()).m_47601_(builder.m_47831_()).m_47592_();
        }

        public static Biome frostbittenForest(boolean isClearing) {
            int grassColor = 13288447;
            int foliageColor = 7059637;
            int waterColor = 6583020;
            int waterFogColor = 6583020;
            int skyColor = 6654717;
            float depth = 1.1f;
            float scale = 0.0f;
            float temp = 0.0f;
            float downfall = 0.0f;
            MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.SNOW_OWL, 6, 2, 2));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.ARMORED_FROST_SPIRIT, 3, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.POLARGEIST, 2, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.DIOPHYDE_PROWLER, 1, 1, 1));
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder().m_47851_(SkiesBiomes.SurfaceBuilders.TURQUOISE_GRASS_SURFACE_BUILDER);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.FROSTBITTEN_FOREST_BUSH);
            if (isClearing) {
                builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.FROSTBITTEN_FOREST_SMALL_FROSTBRIGHT_TREE);
            } else {
                builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.FROSTBITTEN_FOREST_FROSTBRIGHT_TREE);
                builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.FROSTBITTEN_FOREST_BLUEBRIGHT_TREE);
            }
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.SNOWBLOOM_2);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.BRITTLEBUSH_5);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.CHILLWEED_5);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.TURQUOISE_GRASS_5);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.FROSTBITTEN_FOREST_CAVE_FROSTBRIGHT_VINE);
            builder.m_47842_(GenerationStep.Decoration.UNDERGROUND_DECORATION, SkiesConfiguredFeatures.FROSTBITTEN_FOREST_CAVE_GRASS);
            builder.m_47842_(GenerationStep.Decoration.UNDERGROUND_DECORATION, SkiesConfiguredFeatures.FROSTBITTEN_FOREST_CAVE_WALL);
            SkiesConfiguredFeatures.addDefaultBrightOres(builder);
            SkiesConfiguredFeatures.addBrightLakes(builder);
            SkiesConfiguredFeatures.addGeneralBrightFeatures(builder);
            SkiesConfiguredFeatures.addFreezeTopLayer(builder);
            SkiesConfiguredFeatures.addBrightFlowers(builder);
            SkiesConfiguredFeatures.addBrightDoubleGrass(builder);
            SkiesConfiguredFeatures.addVentiumOre(builder);
            return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.SNOW).m_47595_(Biome.BiomeCategory.NONE).m_47593_(depth).m_47607_(scale).m_47609_(temp).m_47611_(downfall).m_47603_(Makers.createAmbienceBuilder(grassColor, foliageColor, waterColor, waterFogColor, skyColor).m_48018_()).m_47605_(spawns.m_48381_()).m_47601_(builder.m_47831_()).m_47592_();
        }

        public static Biome peekingOcean(boolean isDeep, boolean isBrumbleForest) {
            int grassColor = 0xFFFFFF;
            int foliageColor = 7059637;
            int waterColor = isDeep ? 4672964 : 6583020;
            int waterFogColor = isDeep ? 4672964 : 6583020;
            int skyColor = 9684223;
            float depth = isDeep ? -1.8f : -1.0f;
            float scale = 0.1f;
            float temp = 0.2f;
            float downfall = 0.4f;
            MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
            double fishCost = 0.05;
            double fishBudget = 1.0;
            spawns.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.f_20556_, 15, 3, 6));
            spawns.m_48370_(EntityType.f_20556_, fishCost, fishBudget);
            spawns.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.JELLY_DRIFTER, 5, 1, 3));
            spawns.m_48370_(SkiesEntityTypes.JELLY_DRIFTER, fishCost, fishBudget);
            spawns.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.GRITTLE_FLATFISH, 5, 2, 3));
            spawns.m_48370_(SkiesEntityTypes.GRITTLE_FLATFISH, fishCost, fishBudget);
            spawns.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.MUNICIPAL_MONKFISH, 15, 3, 6));
            spawns.m_48370_(SkiesEntityTypes.MUNICIPAL_MONKFISH, fishCost, fishBudget);
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.ARMORED_FROST_SPIRIT, 25, 2, 4));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.WHISTLESHELL_CRAB, 20, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.SECLAM, 10, 1, 1));
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder().m_47851_(SkiesBiomes.SurfaceBuilders.TURQUOISE_GRASS_SURFACE_BUILDER);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.TURQUOISE_GRASS_5);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.PEEKING_OCEAN_BRUMBLE);
            if (isBrumbleForest) {
                builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.BRUMBLE_FOREST_BRUMBLE_VINE);
            } else {
                builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.PEEKING_OCEAN_SEA_MOSS);
                builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.PEEKING_OCEAN_BRUMBLE_VINE);
                builder.m_47842_(GenerationStep.Decoration.SURFACE_STRUCTURES, SkiesConfiguredFeatures.PEEKING_OCEAN_SPIKE);
            }
            builder.m_47842_(GenerationStep.Decoration.UNDERGROUND_DECORATION, SkiesConfiguredFeatures.PEEKING_OCEAN_CAVE_MOSS_CARPET);
            builder.m_47842_(GenerationStep.Decoration.UNDERGROUND_DECORATION, SkiesConfiguredFeatures.PEEKING_OCEAN_CAVE_DENSE_MOSS_WALL);
            builder.m_47842_(GenerationStep.Decoration.UNDERGROUND_DECORATION, SkiesConfiguredFeatures.PEEKING_OCEAN_CAVE_MOSS_WALL);
            SkiesConfiguredFeatures.addFalsiteOre(builder);
            SkiesConfiguredFeatures.addDefaultBrightOres(builder);
            SkiesConfiguredCarvers.addOceanCarvers(builder);
            SkiesConfiguredFeatures.addFreezeTopLayer(builder);
            SkiesConfiguredFeatures.addGeneralBrightFeatures(builder);
            SkiesConfiguredFeatures.addVentiumOre(builder);
            return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47595_(Biome.BiomeCategory.NONE).m_47593_(depth).m_47607_(scale).m_47609_(temp).m_47611_(downfall).m_47603_(Makers.createAmbienceBuilder(grassColor, foliageColor, waterColor, waterFogColor, skyColor).m_48018_()).m_47605_(spawns.m_48381_()).m_47601_(builder.m_47831_()).m_47592_();
        }

        public static Biome middayShore() {
            int grassColor = 12373759;
            int foliageColor = 7059637;
            int waterColor = 6583020;
            int waterFogColor = 6583020;
            int skyColor = 10994416;
            float depth = 0.0f;
            float scale = 0.025f;
            float temp = 0.3f;
            float downfall = 0.4f;
            MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.WHISTLESHELL_CRAB, 20, 1, 1));
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder().m_47851_(SkiesBiomes.SurfaceBuilders.MIDNIGHT_SAND_SURFACE_BUILDER);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.TURQUOISE_GRASS_5);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.MIDDAY_BAYHOP_6);
            SkiesConfiguredFeatures.addDefaultBrightOres(builder);
            SkiesConfiguredFeatures.addFreezeTopLayer(builder);
            SkiesConfiguredFeatures.addGeneralBrightFeatures(builder);
            SkiesConfiguredFeatures.addFalsiteOre(builder);
            SkiesConfiguredFeatures.addVentiumOre(builder);
            return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47595_(Biome.BiomeCategory.NONE).m_47593_(depth).m_47607_(scale).m_47609_(temp).m_47611_(downfall).m_47603_(Makers.createAmbienceBuilder(grassColor, foliageColor, waterColor, waterFogColor, skyColor).m_48018_()).m_47605_(spawns.m_48381_()).m_47601_(builder.m_47831_()).m_47592_();
        }

        public static Biome snowCoveredPines() {
            int grassColor = 14016767;
            int foliageColor = 7059637;
            int waterColor = 2903689;
            int waterFogColor = 2903689;
            int skyColor = 9684223;
            float depth = 1.5f;
            float scale = 0.1f;
            float temp = 0.0f;
            float downfall = 0.8f;
            MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.STARDUST_RAM, 8, 2, 4));
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.REINDEER, 4, 2, 3));
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.AZULFO, 6, 4, 4));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.ARMORED_FROST_SPIRIT, 3, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.CRYNOCEROUS, 1, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.POLARGEIST, 2, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.DIOPHYDE_PROWLER, 1, 1, 2));
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder().m_47851_(SkiesBiomes.SurfaceBuilders.TURQUOISE_GRASS_SURFACE_BUILDER);
            builder.m_47849_(SkiesStructures.NATURE_DUNGEON.getStructureFeature());
            builder.m_47849_(SkiesStructures.EVERBRIGHT_BLINDING_DUNGEON.getStructureFeature());
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.SNOW_COVERED_PINES_STARLIT_TREE);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.SNOWBLOOM_2);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.BRITTLEBUSH_3);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.CHILLWEED_3);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.TURQUOISE_GRASS_2);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.SNOW_COVERED_PINES_CAVE_STARLIT_VINE);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.SNOW_COVERED_PINES_WALL_MOONSTONE);
            builder.m_47842_(GenerationStep.Decoration.UNDERGROUND_DECORATION, SkiesConfiguredFeatures.SNOW_COVERED_PINES_CAVE_WALL);
            SkiesConfiguredFeatures.addDefaultBrightOres(builder);
            SkiesConfiguredFeatures.addBrightLakes(builder);
            SkiesConfiguredFeatures.addGeneralBrightFeatures(builder);
            SkiesConfiguredFeatures.addFreezeTopLayer(builder);
            SkiesConfiguredFeatures.addBrightFlowers(builder);
            return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.SNOW).m_47595_(Biome.BiomeCategory.NONE).m_47593_(depth).m_47607_(scale).m_47609_(temp).m_47611_(downfall).m_47603_(Makers.createAmbienceBuilder(grassColor, foliageColor, waterColor, waterFogColor, skyColor).m_48018_()).m_47605_(spawns.m_48381_()).m_47601_(builder.m_47831_()).m_47592_();
        }

        public static Biome briskMeadow() {
            int grassColor = 0xFFFFFF;
            int foliageColor = 7059637;
            int waterColor = 2903689;
            int waterFogColor = 2903689;
            int skyColor = 9684223;
            float depth = 1.2f;
            float scale = 0.0f;
            float temp = 0.3f;
            float downfall = 0.0f;
            MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.STARDUST_RAM, 5, 2, 4));
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.AZULFO, 8, 4, 4));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.ARMORED_FROST_SPIRIT, 3, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.POLARGEIST, 2, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.DIOPHYDE_PROWLER, 1, 1, 2));
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder().m_47851_(SkiesBiomes.SurfaceBuilders.TURQUOISE_GRASS_SURFACE_BUILDER);
            builder.m_47849_(SkiesStructures.EVERBRIGHT_BLINDING_DUNGEON.getStructureFeature());
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.BRISK_MEADOW_BLUEBRIGHT_TREE);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.BRISK_MEADOW_BUSH);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.BRISK_MEADOW_FLOWER);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.BREWBERRY_3);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.TURQUOISE_GRASS_8);
            builder.m_47842_(GenerationStep.Decoration.UNDERGROUND_DECORATION, SkiesConfiguredFeatures.BRISK_MEADOW_CAVE_WALL_STONE_RIMESTONE);
            builder.m_47842_(GenerationStep.Decoration.UNDERGROUND_DECORATION, SkiesConfiguredFeatures.BRISK_MEADOW_CAVE_WALL_RIMESTONE_STONE);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.BRISK_MEADOW_CAVE_FROSE);
            SkiesConfiguredFeatures.addDefaultBrightOres(builder);
            SkiesConfiguredFeatures.addBrightLakes(builder);
            SkiesConfiguredFeatures.addFreezeTopLayer(builder);
            SkiesConfiguredFeatures.addGeneralBrightFeatures(builder);
            SkiesConfiguredFeatures.addFalsiteOre(builder);
            return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47595_(Biome.BiomeCategory.NONE).m_47593_(depth).m_47607_(scale).m_47609_(temp).m_47611_(downfall).m_47603_(Makers.createAmbienceBuilder(grassColor, foliageColor, waterColor, waterFogColor, skyColor).m_48029_(new AmbientParticleSettings((ParticleOptions)SkiesParticles.BRISK_PETAL, 0.012f)).m_48018_()).m_47605_(spawns.m_48381_()).m_47601_(builder.m_47831_()).m_47592_();
        }

        public static Biome polarHighland() {
            int grassColor = 11657944;
            int foliageColor = 7059637;
            int waterColor = 2903689;
            int waterFogColor = 2903689;
            int skyColor = 7252691;
            float depth = 1.4f;
            float scale = 0.1f;
            float temp = 0.3f;
            float downfall = 0.0f;
            MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.STARDUST_RAM, 5, 2, 4));
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.AZULFO, 8, 4, 4));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.ARMORED_FROST_SPIRIT, 3, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.DIOPHYDE_PROWLER, 2, 1, 2));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.POLARGEIST, 1, 1, 1));
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder().m_47851_(SkiesBiomes.SurfaceBuilders.COARSE_TURQUOISE_SURFACE_BUILDER);
            builder.m_47842_(GenerationStep.Decoration.LOCAL_MODIFICATIONS, SkiesConfiguredFeatures.POLAR_HIGHLAND_ROCK);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.POLAR_HIGHLAND_BLUEBRIGHT_TREE);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.TURQUOISE_GRASS_NOISE);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.POLAR_POSY_6);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.TURQUOISE_GRASS_5);
            builder.m_47842_(GenerationStep.Decoration.UNDERGROUND_DECORATION, SkiesConfiguredFeatures.POLAR_HIGHLAND_CAVE_WALL_TARATITE);
            builder.m_47842_(GenerationStep.Decoration.UNDERGROUND_DECORATION, SkiesConfiguredFeatures.POLAR_HIGHLAND_CAVE_GRASS);
            builder.m_47842_(GenerationStep.Decoration.UNDERGROUND_DECORATION, SkiesConfiguredFeatures.POLAR_HIGHLAND_CAVE_POSY);
            SkiesConfiguredFeatures.addDefaultBrightOres(builder);
            SkiesConfiguredFeatures.addBrightLakes(builder);
            SkiesConfiguredFeatures.addFreezeTopLayer(builder);
            SkiesConfiguredFeatures.addGeneralBrightFeatures(builder);
            SkiesConfiguredFeatures.addBrightFlowers(builder);
            SkiesConfiguredFeatures.addFalsiteOre(builder);
            return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47595_(Biome.BiomeCategory.NONE).m_47593_(depth).m_47607_(scale).m_47609_(temp).m_47611_(downfall).m_47603_(Makers.createAmbienceBuilder(grassColor, foliageColor, waterColor, waterFogColor, skyColor).m_48018_()).m_47605_(spawns.m_48381_()).m_47601_(builder.m_47831_()).m_47592_();
        }

        public static Biome unorthodoxValley() {
            int grassColor = 14843647;
            int foliageColor = 12485859;
            int waterColor = 4351611;
            int waterFogColor = 4351611;
            int skyColor = 9471171;
            float depth = 0.5f;
            float scale = 1.8f;
            float temp = 1.3f;
            float downfall = 0.3f;
            MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.COSMIC_FOX, 6, 1, 2));
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.SHADE_MONITOR, 8, 2, 3));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.VENOM_SPIDER, 7, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.EMBERBACK, 7, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.INFESTED_SWARMER, 7, 1, 1));
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder().m_47851_(SkiesBiomes.SurfaceBuilders.LUNAR_GRASS_SURFACE_BUILDER);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.UNORTHODOX_VALLEY_DUSK_LUNAR_TREE);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.UNORTHODOX_VALLEY_CRESCENT_FRUIT_TREE);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.NIGHTCRESS_2);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.LUNAR_GRASS_5);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.UNORTHODOX_VALLEY_CAVE_DRIPSTONE);
            SkiesConfiguredFeatures.addDefaultDawnOres(builder);
            SkiesConfiguredFeatures.addEmeraldOre(builder, false);
            SkiesConfiguredCarvers.addDawnCarvers(builder);
            SkiesConfiguredFeatures.addDawnLakes(builder);
            SkiesConfiguredFeatures.addGeneralDawnFeatures(builder);
            SkiesConfiguredFeatures.addSprings(builder, true);
            SkiesConfiguredFeatures.addDawnFlowers(builder);
            return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47595_(Biome.BiomeCategory.NONE).m_47593_(depth).m_47607_(scale).m_47609_(temp).m_47611_(downfall).m_47603_(Makers.createAmbienceBuilder(grassColor, foliageColor, waterColor, waterFogColor, skyColor).m_48018_()).m_47605_(spawns.m_48381_()).m_47601_(builder.m_47831_()).m_47592_();
        }

        public static Biome shadedWoodlands() {
            int grassColor = 13151691;
            int foliageColor = 12485859;
            int waterColor = 4351611;
            int waterFogColor = 4351611;
            int skyColor = 0;
            float depth = 0.1f;
            float scale = 0.1f;
            float temp = 1.1f;
            float downfall = 0.3f;
            MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
            spawns.m_48376_(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.FIREFLY, 10, 3, 5));
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.COSMIC_FOX, 5, 4, 4));
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.SHADE_MONITOR, 8, 2, 3));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.VENOM_SPIDER, 7, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.NYCTOFLY, 5, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.INFESTED_SWARMER, 7, 1, 1));
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder().m_47851_(SkiesBiomes.SurfaceBuilders.LUNAR_GRASS_SURFACE_BUILDER);
            builder.m_47849_(SkiesStructures.EVERDAWN_BLINDING_DUNGEON.getStructureFeature());
            builder.m_47849_(SkiesStructures.BLUE_SKIES_VILLAGE.getStructureFeature(SkiesVillageBiomes.SHADED_WOODLANDS.toString()));
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.SHADED_WOODLANDS_LARGE_DUSK_TREE);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.LUNAR_GRASS_MUCKWEED_NOISE);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.BANEFUL_MUSHROOM_5);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.LUNAR_GRASS_MUCKWEED_20);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.SHADED_WOODLANDS_FLOWER);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.SHADED_WOODLANDS_CAVE_DUSK_VINE);
            builder.m_47842_(GenerationStep.Decoration.UNDERGROUND_DECORATION, SkiesConfiguredFeatures.SHADED_WOODLANDS_CAVE_WALL);
            SkiesConfiguredFeatures.addDefaultDawnOres(builder);
            SkiesConfiguredCarvers.addDawnCarvers(builder);
            SkiesConfiguredFeatures.addDawnLakes(builder);
            SkiesConfiguredFeatures.addGeneralDawnFeatures(builder);
            SkiesConfiguredFeatures.addDawnDoubleGrass(builder);
            SkiesConfiguredFeatures.addSprings(builder, true);
            return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47595_(Biome.BiomeCategory.NONE).m_47593_(depth).m_47607_(scale).m_47609_(temp).m_47611_(downfall).m_47603_(Makers.createAmbienceBuilder(grassColor, foliageColor, waterColor, waterFogColor, skyColor).m_48023_(SkiesSounds.AMBIENT_SHADED_WOODLANDS_LOOP).m_48018_()).m_47605_(spawns.m_48381_()).m_47601_(builder.m_47831_()).m_47592_();
        }

        public static Biome crystalDunes(boolean hasSpikes) {
            int grassColor = 0xFFA3FF;
            int foliageColor = 12485859;
            int waterColor = 4351611;
            int waterFogColor = 4351611;
            int skyColor = 15784896;
            float depth = 0.125f;
            float scale = 0.05f;
            float temp = 1.7f;
            float downfall = 0.3f;
            MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.CRYSTAL_CAMEL, 5, 2, 3));
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.SHADE_MONITOR, 2, 2, 3));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.VENOM_SPIDER, 7, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.EMBERBACK, 7, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.INFESTED_SWARMER, 7, 1, 1));
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder().m_47851_(SkiesBiomes.SurfaceBuilders.CRYSTAL_SAND_SURFACE_BUILDER);
            builder.m_47849_(SkiesStructures.EVERDAWN_BLINDING_DUNGEON.getStructureFeature());
            if (!hasSpikes) {
                builder.m_47849_(SkiesStructures.BLUE_SKIES_VILLAGE.getStructureFeature(SkiesVillageBiomes.CRYSTAL_DUNES.toString()));
            }
            builder.m_47842_(GenerationStep.Decoration.SURFACE_STRUCTURES, SkiesConfiguredFeatures.CRYSTAL_DUNES_MOONSTONE_SPIKE);
            if (hasSpikes) {
                builder.m_47842_(GenerationStep.Decoration.SURFACE_STRUCTURES, SkiesConfiguredFeatures.CRYSTAL_DUNES_LARGE_MOONSTONE_SPIKE);
            }
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.LIGHT_CRYSTALLIZED_GRASS_2);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.CRYSTAL_FLOWER_2);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.LUNAR_GRASS_5);
            builder.m_47842_(GenerationStep.Decoration.UNDERGROUND_DECORATION, SkiesConfiguredFeatures.CRYSTAL_DUNES_CAVE_MOONSTONE_CRYSTAL);
            builder.m_47842_(GenerationStep.Decoration.UNDERGROUND_DECORATION, SkiesConfiguredFeatures.CRYSTAL_DUNES_CAVE_GRASS);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.CRYSTAL_DUNES_CAVE_WALL_MOONSTONE);
            SkiesConfiguredFeatures.addDefaultDawnOres(builder);
            SkiesConfiguredCarvers.addDawnCarvers(builder);
            SkiesConfiguredFeatures.addDawnLakes(builder);
            SkiesConfiguredFeatures.addGeneralDawnFeatures(builder);
            SkiesConfiguredFeatures.addHorizoniteOre(builder);
            return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47595_(Biome.BiomeCategory.NONE).m_47593_(depth).m_47607_(scale).m_47609_(temp).m_47611_(downfall).m_47603_(Makers.createAmbienceBuilder(grassColor, foliageColor, waterColor, waterFogColor, skyColor).m_48018_()).m_47605_(spawns.m_48381_()).m_47601_(builder.m_47831_()).m_47592_();
        }

        public static Biome risingCreek() {
            int grassColor = 14843647;
            int foliageColor = 12485859;
            int waterColor = 4351611;
            int waterFogColor = 4351611;
            int skyColor = 9471171;
            float depth = -0.5f;
            float scale = 0.0f;
            float temp = 1.3f;
            float downfall = 0.3f;
            MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
            double fishCost = 0.05;
            double fishBudget = 1.0;
            spawns.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.f_20519_, 5, 1, 5));
            spawns.m_48370_(EntityType.f_20519_, fishCost, fishBudget);
            spawns.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.CHARSCALE_MOKI, 5, 3, 5));
            spawns.m_48370_(SkiesEntityTypes.CHARSCALE_MOKI, fishCost, fishBudget);
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.INFESTED_SWARMER, 5, 1, 1));
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder().m_47851_(SkiesBiomes.SurfaceBuilders.COARSE_LUNAR_SURFACE_BUILDER);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.RISING_CREEK_MOONLIT_WATER_LILY);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.MUCKWEED_5);
            SkiesConfiguredFeatures.addDefaultDawnOres(builder);
            SkiesConfiguredCarvers.addDawnCarvers(builder);
            SkiesConfiguredFeatures.addGeneralDawnFeatures(builder);
            SkiesConfiguredFeatures.addDawnFlowers(builder);
            return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47595_(Biome.BiomeCategory.NONE).m_47593_(depth).m_47607_(scale).m_47609_(temp).m_47611_(downfall).m_47603_(Makers.createAmbienceBuilder(grassColor, foliageColor, waterColor, waterFogColor, skyColor).m_48018_()).m_47605_(spawns.m_48381_()).m_47601_(builder.m_47831_()).m_47592_();
        }

        public static Biome moonlitReservoir() {
            int grassColor = 9269656;
            int foliageColor = 12485859;
            int waterColor = 4354427;
            int waterFogColor = 4354427;
            int skyColor = 8687555;
            float depth = -0.225f;
            float scale = 0.05f;
            float temp = 1.3f;
            float downfall = 0.3f;
            MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.CROGRE, 8, 1, 2));
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.SHADE_MONITOR, 4, 1, 2));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.VENOM_SPIDER, 7, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.NYCTOFLY, 5, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.INFESTED_SWARMER, 7, 1, 1));
            double fishCost = 0.05;
            double fishBudget = 1.0;
            spawns.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.f_20519_, 5, 1, 5));
            spawns.m_48370_(EntityType.f_20519_, fishCost, fishBudget);
            spawns.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.CHARSCALE_MOKI, 5, 3, 5));
            spawns.m_48370_(SkiesEntityTypes.CHARSCALE_MOKI, fishCost, fishBudget);
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder().m_47851_(SkiesBiomes.SurfaceBuilders.MOONLIT_RESERVOIR_SURFACE_BUILDER);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.MOONLIT_RESERVOIR_DUSK_TREE);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.MOONLIT_RESERVOIR_GLIMMER_REEDS);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.MOONLIT_RESERVOIR_MOONLIT_WATER_LILY);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.LUCENTROOT_2);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.LUNAR_GRASS_MUCKWEED_NOISE);
            builder.m_47842_(GenerationStep.Decoration.UNDERGROUND_DECORATION, SkiesConfiguredFeatures.MOONLIT_RESERVOIR_CAVE_GRASS);
            builder.m_47842_(GenerationStep.Decoration.UNDERGROUND_DECORATION, SkiesConfiguredFeatures.MOONLIT_RESERVOIR_CAVE_WALL);
            SkiesConfiguredFeatures.addDefaultDawnOres(builder);
            SkiesConfiguredCarvers.addDawnCarvers(builder);
            SkiesConfiguredFeatures.addGeneralDawnFeatures(builder);
            SkiesConfiguredFeatures.addDawnFlowers(builder);
            SkiesConfiguredFeatures.addDawnDoubleGrass(builder);
            return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47595_(Biome.BiomeCategory.NONE).m_47593_(depth).m_47607_(scale).m_47609_(temp).m_47611_(downfall).m_47603_(Makers.createAmbienceBuilder(grassColor, foliageColor, waterColor, waterFogColor, skyColor).m_48023_(SkiesSounds.AMBIENT_MOONLIT_RESERVOIR_LOOP).m_48018_()).m_47605_(spawns.m_48381_()).m_47601_(builder.m_47831_()).m_47592_();
        }

        public static Biome crystalRoughs() {
            int grassColor = 13155070;
            int foliageColor = 12485859;
            int waterColor = 4351611;
            int waterFogColor = 4351611;
            int skyColor = 14350335;
            float depth = 0.125f;
            float scale = 0.05f;
            float temp = 1.7f;
            float downfall = 0.0f;
            MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.CRYSTAL_CAMEL, 2, 2, 3));
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.SHADE_MONITOR, 8, 1, 2));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.VENOM_SPIDER, 7, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.EMBERBACK, 7, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.INFESTED_SWARMER, 7, 1, 1));
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder().m_47851_(SkiesBiomes.SurfaceBuilders.CRYSTAL_ROUGHS_SURFACE_BUILDER);
            builder.m_47849_(SkiesStructures.EVERDAWN_BLINDING_DUNGEON.getStructureFeature());
            builder.m_47842_(GenerationStep.Decoration.SURFACE_STRUCTURES, SkiesConfiguredFeatures.CRYSTAL_ROUGHS_LUNAR_TREE);
            builder.m_47842_(GenerationStep.Decoration.SURFACE_STRUCTURES, SkiesConfiguredFeatures.CRYSTAL_ROUGHS_CRYSTALIZED_TREE);
            builder.m_47842_(GenerationStep.Decoration.SURFACE_STRUCTURES, SkiesConfiguredFeatures.CRYSTAL_ROUGHS_SHORT_MOONSTONE_SPIKE);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.CRYSTAL_FLOWER_2);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.LUNAR_GRASS_5);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.CRYSTALLIZED_GRASS_5);
            builder.m_47842_(GenerationStep.Decoration.UNDERGROUND_DECORATION, SkiesConfiguredFeatures.CRYSTAL_ROUGHS_CAVE_GRASS);
            SkiesConfiguredFeatures.addDefaultDawnOres(builder);
            SkiesConfiguredCarvers.addDawnCarvers(builder);
            SkiesConfiguredFeatures.addDawnLakes(builder);
            SkiesConfiguredFeatures.addGeneralDawnFeatures(builder);
            SkiesConfiguredFeatures.addHorizoniteOre(builder);
            SkiesConfiguredFeatures.addSprings(builder, true);
            return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47595_(Biome.BiomeCategory.NONE).m_47593_(depth).m_47607_(scale).m_47609_(temp).m_47611_(downfall).m_47603_(Makers.createAmbienceBuilder(grassColor, foliageColor, waterColor, waterFogColor, skyColor).m_48018_()).m_47605_(spawns.m_48381_()).m_47601_(builder.m_47831_()).m_47592_();
        }

        public static Biome sunsetMapleForest() {
            int grassColor = 15829434;
            int foliageColor = 12485859;
            int waterColor = 4351611;
            int waterFogColor = 4351611;
            int skyColor = 15770516;
            float depth = 0.1f;
            float scale = 0.1f;
            float temp = 1.5f;
            float downfall = 0.3f;
            MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.COSMIC_FOX, 5, 1, 2));
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.SHADE_MONITOR, 8, 2, 3));
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.SLIV, 2, 2, 3));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.VENOM_SPIDER, 7, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.EMBERBACK, 7, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.INFESTED_SWARMER, 7, 1, 1));
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder().m_47851_(SkiesBiomes.SurfaceBuilders.LUNAR_GRASS_SURFACE_BUILDER);
            builder.m_47849_(SkiesStructures.EVERDAWN_BLINDING_DUNGEON.getStructureFeature());
            builder.m_47849_(SkiesStructures.POISON_DUNGEON.getStructureFeature());
            builder.m_47849_(SkiesStructures.BLUE_SKIES_VILLAGE.getStructureFeature(SkiesVillageBiomes.SUNSET_MAPLE_FOREST.toString()));
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.SUNSET_MAPLE_FOREST_MAPLE_TREE);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.LUNAR_GRASS_7);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.FLARE_FLORET_BLAZE_BUD_LUCENTROOT_4);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.SUNSET_MAPLE_FOREST_CAVE_WALL_SUNSTONE);
            builder.m_47842_(GenerationStep.Decoration.UNDERGROUND_DECORATION, SkiesConfiguredFeatures.SUNSET_MAPLE_FOREST_CAVE_MAGMA);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.SUNSET_MAPLE_FOREST_CAVE_MAPLE_VINE);
            SkiesConfiguredFeatures.addDefaultDawnOres(builder);
            SkiesConfiguredCarvers.addDawnCarvers(builder);
            SkiesConfiguredFeatures.addDawnLakes(builder);
            SkiesConfiguredFeatures.addGeneralDawnFeatures(builder);
            SkiesConfiguredFeatures.addHorizoniteOre(builder);
            return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47595_(Biome.BiomeCategory.NONE).m_47593_(depth).m_47607_(scale).m_47609_(temp).m_47611_(downfall).m_47603_(Makers.createAmbienceBuilder(grassColor, foliageColor, waterColor, waterFogColor, skyColor).m_48018_()).m_47605_(spawns.m_48381_()).m_47601_(builder.m_47831_()).m_47592_();
        }

        public static Biome searingGrassland() {
            int grassColor = 15829396;
            int foliageColor = 12485859;
            int waterColor = 4351611;
            int waterFogColor = 4351611;
            int skyColor = 15766676;
            float depth = 0.1f;
            float scale = 0.0f;
            float temp = 1.6f;
            float downfall = 0.1f;
            MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.COSMIC_FOX, 5, 1, 2));
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.SHADE_MONITOR, 8, 2, 3));
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.SLIV, 2, 2, 3));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.VENOM_SPIDER, 7, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.EMBERBACK, 7, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.INFESTED_SWARMER, 7, 1, 1));
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder().m_47851_(SkiesBiomes.SurfaceBuilders.LUNAR_GRASS_SURFACE_BUILDER);
            builder.m_47849_(SkiesStructures.EVERDAWN_BLINDING_DUNGEON.getStructureFeature());
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.SEARING_GRASSLAND_BUSH);
            builder.m_47842_(GenerationStep.Decoration.LOCAL_MODIFICATIONS, SkiesConfiguredFeatures.SEARING_GRASSLAND_ROCK);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.FLARE_FLORET_BLAZE_BUD_LUCENTROOT_5);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.LUNAR_GRASS_7);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.SEARING_GRASSLAND_CAVE_WALL_SUNSTONE);
            builder.m_47842_(GenerationStep.Decoration.UNDERGROUND_DECORATION, SkiesConfiguredFeatures.SEARING_GRASSLAND_CAVE_MAGMA);
            builder.m_47842_(GenerationStep.Decoration.UNDERGROUND_DECORATION, SkiesConfiguredFeatures.SEARING_GRASSLAND_CAVE_WALL);
            SkiesConfiguredFeatures.addDefaultDawnOres(builder);
            SkiesConfiguredCarvers.addDawnCarvers(builder);
            SkiesConfiguredFeatures.addDawnLakes(builder);
            SkiesConfiguredFeatures.addGeneralDawnFeatures(builder);
            SkiesConfiguredFeatures.addHorizoniteOre(builder);
            return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47595_(Biome.BiomeCategory.NONE).m_47593_(depth).m_47607_(scale).m_47609_(temp).m_47611_(downfall).m_47603_(Makers.createAmbienceBuilder(grassColor, foliageColor, waterColor, waterFogColor, skyColor).m_48029_(new AmbientParticleSettings((ParticleOptions)SkiesParticles.SEARING_SMOKE, 0.01f)).m_48018_()).m_47605_(spawns.m_48381_()).m_47601_(builder.m_47831_()).m_47592_();
        }

        public static Biome crescentOrchard(boolean isLake) {
            int grassColor = 12025574;
            int foliageColor = 12485859;
            int waterColor = 4351611;
            int waterFogColor = 4351611;
            int skyColor = 15774612;
            float depth = isLake ? -0.6f : 0.1f;
            float scale = isLake ? 0.0f : 0.1f;
            float temp = 1.3f;
            float downfall = 0.3f;
            MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
            if (isLake) {
                double fishCost = 0.05;
                double fishBudget = 1.0;
                spawns.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.CHARSCALE_MOKI, 5, 3, 5));
                spawns.m_48370_(SkiesEntityTypes.CHARSCALE_MOKI, fishCost, fishBudget);
            } else {
                spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.COSMIC_FOX, 5, 1, 2));
                spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.SHADE_MONITOR, 8, 2, 3));
            }
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.VENOM_SPIDER, 7, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.INFESTED_SWARMER, 7, 1, 1));
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder().m_47851_(SkiesBiomes.SurfaceBuilders.LUNAR_GRASS_SURFACE_BUILDER);
            if (!isLake) {
                builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.CRESCENT_ORCHARD_CRESCENT_FRUIT_TREE);
            }
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.CRESCENT_ORCHARD_CRESCENT_FRUIT_TREE);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.NIGHTCRESS_2);
            builder.m_47842_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.LUNAR_GRASS_4);
            builder.m_47842_(GenerationStep.Decoration.UNDERGROUND_DECORATION, SkiesConfiguredFeatures.CRESCENT_ORCHARD_CAVE_GRASS);
            builder.m_47842_(GenerationStep.Decoration.UNDERGROUND_DECORATION, SkiesConfiguredFeatures.CRESCENT_ORCHARD_CAVE_DIRT);
            builder.m_47842_(GenerationStep.Decoration.UNDERGROUND_DECORATION, SkiesConfiguredFeatures.CRESCENT_ORCHARD_CAVE_BLOOM);
            builder.m_47842_(GenerationStep.Decoration.UNDERGROUND_DECORATION, SkiesConfiguredFeatures.CRESCENT_ORCHARD_CAVE_NIGHTCRESS);
            builder.m_47842_(GenerationStep.Decoration.UNDERGROUND_DECORATION, SkiesConfiguredFeatures.CRESCENT_ORCHARD_CAVE_LUCENTROOT);
            SkiesConfiguredFeatures.addDawnFlowers(builder);
            SkiesConfiguredFeatures.addDefaultDawnOres(builder);
            SkiesConfiguredCarvers.addDawnCarvers(builder);
            SkiesConfiguredFeatures.addDawnLakes(builder);
            SkiesConfiguredFeatures.addGeneralDawnFeatures(builder);
            return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47595_(Biome.BiomeCategory.NONE).m_47593_(depth).m_47607_(scale).m_47609_(temp).m_47611_(downfall).m_47603_(Makers.createAmbienceBuilder(grassColor, foliageColor, waterColor, waterFogColor, skyColor).m_48018_()).m_47605_(spawns.m_48381_()).m_47601_(builder.m_47831_()).m_47592_();
        }

        protected static BiomeSpecialEffects.Builder createAmbienceBuilder(int grassColor, int foliageColor, int waterColor, int waterFogColor, int skyColor) {
            return new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48040_(Makers.calcDefaultSkyColor(0.3f)).m_48027_(AmbientMoodSettings.f_47387_).m_48045_(grassColor).m_48043_(foliageColor).m_48034_(waterColor).m_48037_(waterFogColor).m_48040_(skyColor);
        }

        private static int calcDefaultSkyColor(float chance) {
            float thirdChance = chance / 3.0f;
            thirdChance = Mth.m_14036_((float)thirdChance, (float)-1.0f, (float)1.0f);
            return Mth.m_14169_((float)(0.62222224f - thirdChance * 0.05f), (float)(0.5f + thirdChance * 0.1f), (float)1.0f);
        }
    }
}

