/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.data.objects.alchemy;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.data.managers.SkiesDataManager;
import com.legacy.blue_skies.data.objects.alchemy.AlchemyRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.ImmutableTriple;

public class CatylistRecipe
extends AlchemyRecipe {
    private static final String INPUT_KEY = "input";
    private static final String CATYLIST_KEY = "catylist";
    private static final String RESULTS_KEY = "results";
    private final Item input;
    private final Item catylist;
    private final List<Item> results;

    public CatylistRecipe(Item input, Item catylist, List<Item> results, boolean shouldOverride) {
        super(shouldOverride, BlueSkies.locate(CATYLIST_KEY));
        this.input = input;
        this.catylist = catylist;
        this.results = results;
    }

    public Item getInput() {
        return this.input;
    }

    public Item getCatylist() {
        return this.catylist;
    }

    @Override
    public void mergeRecipe(AlchemyRecipe recipe) {
        AlchemyRecipe alchemyRecipe = recipe;
        if (alchemyRecipe instanceof CatylistRecipe) {
            CatylistRecipe catylist = (CatylistRecipe)alchemyRecipe;
            this.results.addAll(catylist.results);
        }
    }

    @Override
    public List<Item> getResults(Item inputA, Item inputB) {
        return this.getResults();
    }

    @Override
    public List<Item> getResults() {
        return new ArrayList<Item>(this.results);
    }

    @Override
    public List<ImmutableTriple<ItemStack, ItemStack, ItemStack>> getAllCombinations() {
        ArrayList<ImmutableTriple<ItemStack, ItemStack, ItemStack>> data = new ArrayList<ImmutableTriple<ItemStack, ItemStack, ItemStack>>();
        for (Item output : this.results) {
            data.add((ImmutableTriple<ItemStack, ItemStack, ItemStack>)ImmutableTriple.of((Object)new ItemStack((ItemLike)this.input), (Object)new ItemStack((ItemLike)this.catylist), (Object)new ItemStack((ItemLike)output)));
        }
        return data;
    }

    @Override
    public boolean matches(Item itemA, Item itemB) {
        return this.input == itemA && this.catylist == itemB;
    }

    @Override
    public CatylistRecipe fromJson(JsonObject json) throws SkiesDataManager.RegistryObjectNotFoundException {
        boolean shouldOverride = GsonHelper.m_13855_((JsonObject)json, (String)"override", (boolean)false);
        Item input = SkiesDataManager.parseItem(json, INPUT_KEY);
        Item catylist = SkiesDataManager.parseItem(json, CATYLIST_KEY);
        ArrayList<Item> results = new ArrayList<Item>();
        GsonHelper.m_13933_((JsonObject)json, (String)RESULTS_KEY).forEach(j -> {
            ResourceLocation name = new ResourceLocation(j.getAsString());
            if (ForgeRegistries.ITEMS.containsKey(name)) {
                results.add((Item)ForgeRegistries.ITEMS.getValue(name));
            }
        });
        return new CatylistRecipe(input, catylist, results, shouldOverride);
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", this.type.toString());
        json.addProperty("override", Boolean.valueOf(this.shouldOverride));
        json.addProperty(INPUT_KEY, this.input.getRegistryName().toString());
        json.addProperty(CATYLIST_KEY, this.catylist.getRegistryName().toString());
        JsonArray results = new JsonArray();
        this.results.forEach(i -> results.add(i.getRegistryName().toString()));
        json.add(RESULTS_KEY, (JsonElement)results);
        return json;
    }
}

