/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.crafting;

import com.google.common.collect.ImmutableSet;
import com.legacy.blue_skies.data.BlueSkiesData;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesItems;
import com.legacy.blue_skies.registries.SkiesRecipes;
import com.legacy.blue_skies.util.StringUtil;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ToolRecipe
extends ShapedRecipe {
    private final Item tool;
    private final Materials material;
    private final RecipeShapes shape;
    private NonNullList<Ingredient> ingredients;

    public ToolRecipe(ResourceLocation id, Materials material, Item tool, RecipeShapes shape) {
        super(id, "", shape.width, shape.height, NonNullList.m_122779_(), new ItemStack((ItemLike)tool));
        this.tool = tool;
        this.material = material;
        this.shape = shape;
    }

    public RecipeSerializer<?> m_7707_() {
        return SkiesRecipes.SERIALIZERS.get(this.m_6423_());
    }

    public NonNullList<Ingredient> m_7527_() {
        if (this.ingredients == null) {
            this.ingredients = this.shape.create(this.material.getIngredient());
        }
        return this.ingredients;
    }

    public boolean m_5818_(CraftingContainer inv, Level world) {
        for (int x = 0; x <= inv.m_39347_() - this.getRecipeWidth(); ++x) {
            for (int y = 0; y <= inv.m_39346_() - this.getRecipeHeight(); ++y) {
                if (!this.checkMatch(inv, x, y, true) && !this.checkMatch(inv, x, y, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatch(CraftingContainer craftingInventory, int width, int height, boolean mirrored) {
        for (int x = 0; x < craftingInventory.m_39347_(); ++x) {
            for (int y = 0; y < craftingInventory.m_39346_(); ++y) {
                int k = x - width;
                int l = y - height;
                Ingredient ingredient = Ingredient.f_43901_;
                if (k >= 0 && l >= 0 && k < this.getRecipeWidth() && l < this.getRecipeHeight()) {
                    ingredient = mirrored ? (Ingredient)this.m_7527_().get(this.getRecipeWidth() - k - 1 + l * this.getRecipeWidth()) : (Ingredient)this.m_7527_().get(k + l * this.getRecipeWidth());
                }
                if (ingredient.test(craftingInventory.m_8020_(x + y * craftingInventory.m_39347_()))) continue;
                return false;
            }
        }
        return true;
    }

    public ItemStack m_5874_(CraftingContainer inv) {
        boolean stickFlag = true;
        Item stick = null;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            if (stick == null && BlueSkiesData.TOOL_HANDLE_TYPES.hasHandle(inv.m_8020_(i).m_41720_())) {
                stick = inv.m_8020_(i).m_41720_();
            }
            if (stick == null || !BlueSkiesData.TOOL_HANDLE_TYPES.hasHandle(inv.m_8020_(i).m_41720_()) || stick == inv.m_8020_(i).m_41720_()) continue;
            stickFlag = false;
        }
        if (stick != null && stickFlag) {
            ItemStack output = new ItemStack((ItemLike)this.tool);
            output.m_41784_().m_128359_("Stick", BlueSkiesData.TOOL_HANDLE_TYPES.getHandle(stick).getName());
            return output;
        }
        return ItemStack.f_41583_;
    }

    public static enum RecipeShapes {
        AXE(2, 3, "mm", "ms", " s"),
        PICKAXE(3, 3, "mmm", " s ", " s "),
        SHOVEL(1, 3, "m", "s", "s"),
        HOE(2, 3, "mm", " s", " s"),
        SWORD(1, 3, "m", "m", "s");

        public final int width;
        public final int height;
        public final String[] rows;

        private RecipeShapes(int width, int height, String ... rows) {
            this.width = width;
            this.height = height;
            this.rows = rows;
        }

        public NonNullList<Ingredient> create(Ingredient material) {
            Object[] ingredients = new Ingredient[this.width * this.height];
            for (int row = 0; row < this.height; ++row) {
                for (int col = 0; col < this.width; ++col) {
                    Object sticks;
                    char c = this.rows[row].charAt(col);
                    Object object = sticks = !BlueSkiesData.TOOL_HANDLE_TYPES.getData().keySet().isEmpty() ? BlueSkiesData.TOOL_HANDLE_TYPES.getData().keySet() : ImmutableSet.of((Object)Items.f_42398_);
                    Ingredient ingredient = c == 'm' ? material : (c == 's' ? Ingredient.m_43929_((ItemLike[])((ItemLike[])sticks.toArray(new Item[0]))) : Ingredient.f_43901_);
                    ingredients[row * this.width + col] = ingredient;
                }
            }
            return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])ingredients);
        }

        public static RecipeShapes fromString(String key) {
            for (RecipeShapes shape : RecipeShapes.values()) {
                if (!StringUtil.toLower(shape.name()).equals(key)) continue;
                return shape;
            }
            return HOE;
        }
    }

    public static enum Materials {
        BLUEBRIGHT((ItemLike)SkiesBlocks.bluebright_planks),
        STARLIT((ItemLike)SkiesBlocks.starlit_planks),
        FROSTBRIGHT((ItemLike)SkiesBlocks.frostbright_planks),
        LUNAR((ItemLike)SkiesBlocks.lunar_planks),
        DUSK((ItemLike)SkiesBlocks.dusk_planks),
        MAPLE((ItemLike)SkiesBlocks.maple_planks),
        CHERRY((ItemLike)SkiesBlocks.cherry_planks),
        TURQUOISE_STONE((ItemLike)SkiesBlocks.turquoise_cobblestone),
        LUNAR_STONE((ItemLike)SkiesBlocks.lunar_cobblestone),
        PYROPE((ItemLike)SkiesItems.pyrope_gem),
        AQUITE((ItemLike)SkiesItems.aquite),
        DIOPSIDE((ItemLike)SkiesItems.diopside_gem),
        CHAROITE((ItemLike)SkiesItems.charoite),
        HORIZONITE((ItemLike)SkiesItems.horizonite_ingot);

        private final Ingredient ingredient;

        private Materials(ItemLike item) {
            this.ingredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{item});
        }

        public Ingredient getIngredient() {
            return this.ingredient;
        }

        public ItemLike getItem() {
            return this.ingredient.m_43908_()[0].m_41720_();
        }
    }
}

