/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.blocks.natural;

import com.legacy.blue_skies.blocks.natural.SkyDirtBlock;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.AbstractFlowerFeature;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.lighting.LayerLightEngine;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public class SkyGrassBlock
extends GrassBlock {
    private final GrassProperties grassProp;

    public SkyGrassBlock(GrassProperties grassProp) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76315_).m_60977_().m_60978_(0.6f).m_60918_(SoundType.f_56740_));
        this.grassProp = grassProp;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos pos, BlockPos facingPos) {
        Block block = worldIn.m_8055_(pos.m_7494_()).m_60734_();
        return (BlockState)state.m_61124_((Property)f_56637_, (Comparable)Boolean.valueOf(block == Blocks.f_50125_ || block == Blocks.f_50127_));
    }

    private static boolean isLightAbove(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos blockpos = pos.m_7494_();
        BlockState blockstate = world.m_8055_(blockpos);
        if (blockstate.m_60734_() == Blocks.f_50125_ && (Integer)blockstate.m_61143_((Property)SnowLayerBlock.f_56581_) == 1) {
            return true;
        }
        int i = LayerLightEngine.m_75667_((BlockGetter)world, (BlockState)state, (BlockPos)pos, (BlockState)blockstate, (BlockPos)blockpos, (Direction)Direction.UP, (int)blockstate.m_60739_((BlockGetter)world, blockpos));
        return i < world.m_7469_();
    }

    private static boolean isCovered(BlockState state, LevelReader world, BlockPos pos) {
        return SkyGrassBlock.isLightAbove(state, world, pos) && !world.m_6425_(pos.m_7494_()).m_76153_((Tag)FluidTags.f_13131_);
    }

    public void m_7455_(BlockState state, ServerLevel worldIn, BlockPos pos, Random rand) {
        if (!worldIn.f_46443_) {
            if (!worldIn.isAreaLoaded(pos, 3)) {
                return;
            }
            if (!SkyGrassBlock.isLightAbove(state, (LevelReader)worldIn, pos)) {
                worldIn.m_46597_(pos, this.grassProp.getDirtBlock().m_49966_());
            } else if (worldIn.m_46803_(pos.m_7494_()) >= 9) {
                for (int i = 0; i < 4; ++i) {
                    BlockPos blockpos = pos.m_142082_(rand.nextInt(3) - 1, rand.nextInt(5) - 3, rand.nextInt(3) - 1);
                    Block dirt = worldIn.m_8055_(blockpos).m_60734_();
                    if (!this.grassProp.canSpreadTo(dirt) || !SkyGrassBlock.isCovered(this.m_49966_(), (LevelReader)worldIn, blockpos)) continue;
                    worldIn.m_46597_(blockpos, (BlockState)this.grassProp.getSpreadResult(dirt).m_49966_().m_61124_((Property)f_56637_, (Comparable)Boolean.valueOf(worldIn.m_8055_(blockpos.m_7494_()).m_60734_() == Blocks.f_50125_)));
                }
            }
        }
    }

    public boolean canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction facing, IPlantable plantable) {
        PlantType type = plantable.getPlantType(world, pos.m_142300_(facing));
        if (type == PlantType.PLAINS) {
            return true;
        }
        if (type == PlantType.BEACH) {
            for (Direction d : SkyDirtBlock.HORIZONTAL_DIRECTIONS) {
                if (world.m_8055_(pos.m_142300_(d)).m_60767_() != Material.f_76305_) continue;
                return true;
            }
        }
        return super.canSustainPlant(state, world, pos, facing, plantable);
    }

    public void m_7719_(ServerLevel worldIn, Random rand, BlockPos pos, BlockState state) {
        BlockPos blockpos = pos.m_7494_();
        BlockState blockstate = this.grassProp.getGrass().m_49966_();
        block0: for (int i = 0; i < 128; ++i) {
            BlockPos blockpos1 = blockpos;
            int j = 0;
            while (true) {
                if (j >= i / 16) {
                    BlockState blockstate1;
                    if (!worldIn.m_46859_(blockpos1)) continue block0;
                    if (rand.nextInt(8) == 0) {
                        List list = worldIn.m_46857_(blockpos1).m_47536_().m_47815_();
                        if (list.isEmpty()) continue block0;
                        ConfiguredFeature configuredfeature = (ConfiguredFeature)list.get(0);
                        AbstractFlowerFeature flowersfeature = (AbstractFlowerFeature)configuredfeature.f_65377_;
                        blockstate1 = flowersfeature.m_7973_(rand, blockpos1, configuredfeature.m_65397_());
                    } else {
                        blockstate1 = blockstate;
                    }
                    if (!blockstate1.m_60710_((LevelReader)worldIn, blockpos1)) continue block0;
                    worldIn.m_7731_(blockpos1, blockstate1, 3);
                    continue block0;
                }
                if (worldIn.m_8055_((blockpos1 = blockpos1.m_142082_(rand.nextInt(3) - 1, (rand.nextInt(3) - 1) * rand.nextInt(3) / 2, rand.nextInt(3) - 1)).m_7495_()).m_60734_() != this || SkyGrassBlock.m_49916_((VoxelShape)worldIn.m_8055_(blockpos1).m_60812_((BlockGetter)worldIn, blockpos1))) continue block0;
                ++j;
            }
        }
    }

    public static class GrassProperties {
        private final Supplier<? extends Block> GRASS;
        private final Supplier<? extends Block> DIRTBLOCK;
        private final Map<Supplier<? extends Block>, Supplier<? extends Block>> SPREADMAP;

        public GrassProperties(Supplier<? extends Block> grass, Supplier<? extends Block> dirtBlock, Map<Supplier<? extends Block>, Supplier<? extends Block>> spreadMap) {
            this.GRASS = grass;
            this.DIRTBLOCK = dirtBlock;
            this.SPREADMAP = spreadMap;
        }

        public Block getGrass() {
            return this.GRASS.get();
        }

        public Block getDirtBlock() {
            return this.DIRTBLOCK.get();
        }

        public boolean canSpreadTo(Block dirt) {
            for (Supplier<? extends Block> supplier : this.SPREADMAP.keySet()) {
                if (!supplier.get().equals(dirt)) continue;
                return true;
            }
            return false;
        }

        public Block getSpreadResult(Block dirt) {
            for (Map.Entry<Supplier<? extends Block>, Supplier<? extends Block>> entry : this.SPREADMAP.entrySet()) {
                if (!entry.getKey().get().equals(dirt)) continue;
                return entry.getValue().get();
            }
            return Blocks.f_50440_;
        }
    }
}

