/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.blocks.natural;

import com.legacy.blue_skies.blocks.util.IFluidLoggable;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SkyDripstoneBlock
extends Block
implements IFluidLoggable {
    private static final VoxelShape[] SHAPES = new VoxelShape[]{Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), Block.m_49796_((double)0.5, (double)0.0, (double)0.5, (double)15.5, (double)16.0, (double)15.5)};
    public static final EnumProperty<Section> SECTION = EnumProperty.m_61587_((String)"section", Section.class);
    public static final EnumProperty<Type> TYPE = EnumProperty.m_61587_((String)"type", Type.class);

    public SkyDripstoneBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(SECTION, (Comparable)((Object)Section.TIP))).m_61124_(TYPE, (Comparable)((Object)Type.STALAGMITE))).m_61124_((Property)FLUIDLOGGED, (Comparable)((Object)IFluidLoggable.FluidLogging.EMPTY)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Vec3 offset = state.m_60824_(world, pos);
        return SHAPES[((Section)((Object)state.m_61143_(SECTION))).ordinal()].m_83216_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (state.m_61143_(SECTION) == Section.TIP && world.m_8055_(pos.m_142300_(((Type)((Object)state.m_61143_(SkyDripstoneBlock.TYPE))).growthDir.m_122424_())).m_60734_() != this) {
            return Shapes.m_83040_();
        }
        Vec3 offset = state.m_60824_(world, pos);
        return SHAPES[((Section)((Object)state.m_61143_(SECTION))).ordinal()].m_83216_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
    }

    public BlockBehaviour.OffsetType m_5858_() {
        return BlockBehaviour.OffsetType.XZ;
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        int fluidLight = ((IFluidLoggable.FluidLogging)((Object)state.m_61143_((Property)SkyDripstoneBlock.FLUIDLOGGED))).fluidState.m_76188_().getLightEmission(world, pos);
        int blockLight = state.m_60791_();
        return Math.max(fluidLight, blockLight);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return this.getStateForPlacement(context.m_43725_(), context.m_8083_(), context.m_6232_());
    }

    @Nullable
    public BlockState getStateForPlacement(Level world, BlockPos pos, Direction ... directions) {
        FluidState fluidState = world.m_6425_(pos);
        for (Direction dir : directions) {
            BlockState state;
            if (dir.m_122434_() != Direction.Axis.Y || !(state = (BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)(dir == Type.STALAGMITE.growthDir ? Type.STALACTITE : Type.STALAGMITE)))).m_60710_((LevelReader)world, pos)) continue;
            return (BlockState)state.m_61124_((Property)FLUIDLOGGED, (Comparable)((Object)IFluidLoggable.FluidLogging.from(fluidState.m_76152_())));
        }
        return null;
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        if (state.m_61138_(TYPE)) {
            Direction growthDir = ((Type)((Object)state.m_61143_(SkyDripstoneBlock.TYPE))).growthDir;
            BlockState connectedTo = world.m_8055_(pos.m_142300_(growthDir.m_122424_()));
            return connectedTo.m_60734_() == this || connectedTo.m_60783_((BlockGetter)world, pos.m_142300_(growthDir.m_122424_()), growthDir);
        }
        return false;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        Direction growthDir;
        BlockState frontState;
        IFluidLoggable.FluidLogging fluid = (IFluidLoggable.FluidLogging)((Object)state.m_61143_((Property)FLUIDLOGGED));
        if (fluid != IFluidLoggable.FluidLogging.EMPTY) {
            world.m_6217_().m_5945_(currentPos, (Object)fluid.fluid, fluid.fluid instanceof FlowingFluid ? ((FlowingFluid)fluid.fluid).m_6718_((LevelReader)world) : Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        if ((frontState = world.m_8055_(currentPos.m_142300_(growthDir = ((Type)((Object)state.m_61143_(SkyDripstoneBlock.TYPE))).growthDir))).m_60734_() == this && frontState.m_61143_(TYPE) == state.m_61143_(TYPE) && (state.m_61143_(SECTION) != Section.MIDDLE || world.m_8055_(currentPos.m_142300_(growthDir.m_122424_())).m_60734_() != this)) {
            world.m_7731_(currentPos, (BlockState)state.m_61124_(SECTION, (Comparable)((Object)Section.getWider((Section)((Object)frontState.m_61143_(SECTION))))), 3);
        }
        return state.m_60710_((LevelReader)world, currentPos) ? state : Blocks.f_50016_.m_49966_();
    }

    public FluidState m_5888_(BlockState state) {
        return ((IFluidLoggable.FluidLogging)((Object)state.m_61143_((Property)SkyDripstoneBlock.FLUIDLOGGED))).fluidState;
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return state.m_61143_(SECTION) == Section.TIP && world.m_8055_(pos.m_142300_(((Type)((Object)state.m_61143_(SkyDripstoneBlock.TYPE))).growthDir.m_122424_())).m_60734_() != this;
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.DESTROY;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SECTION, TYPE, FLUIDLOGGED});
    }

    public static enum Section implements StringRepresentable
    {
        TIP("tip"),
        MIDDLE("middle"),
        BASE("base");

        private final String name;

        private Section(String name) {
            this.name = name;
        }

        public static Section getWider(Section section) {
            switch (section) {
                case TIP: {
                    return MIDDLE;
                }
                case MIDDLE: {
                    return BASE;
                }
            }
            return BASE;
        }

        public String m_7912_() {
            return this.name;
        }
    }

    public static enum Type implements StringRepresentable
    {
        STALAGMITE("stalagmite", Direction.UP),
        STALACTITE("stalactite", Direction.DOWN);

        private final String name;
        public final Direction growthDir;

        private Type(String name, Direction growthDir) {
            this.name = name;
            this.growthDir = growthDir;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

