/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.blocks.natural;

import com.legacy.blue_skies.client.particle.data.PoisonData;
import com.legacy.blue_skies.registries.SkiesVillagers;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BanefulMushroomBlock
extends BushBlock {
    private static final BooleanProperty OPEN = BooleanProperty.m_61465_((String)"open");
    protected static final VoxelShape SHAPE = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0);

    public BanefulMushroomBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Vec3 offset = state.m_60824_(level, pos);
        return SHAPE.m_83216_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
    }

    public BlockBehaviour.OffsetType m_5858_() {
        return BlockBehaviour.OffsetType.XZ;
    }

    public void m_7458_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        if (((Boolean)state.m_61143_((Property)OPEN)).booleanValue()) {
            level.m_7731_(pos, this.m_49966_(), 3);
        }
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        BanefulMushroomBlock.poisonTarget(state, level, pos, entity, (Block)this, OPEN);
    }

    public static void poisonTarget(BlockState state, Level level, BlockPos pos, Entity entity, Block block, BooleanProperty openProperty) {
        LivingEntity living;
        Entity entity2 = entity;
        if (entity2 instanceof LivingEntity && (living = (LivingEntity)entity2).m_7301_(new MobEffectInstance(MobEffects.f_19614_))) {
            Villager villager;
            Entity entity3 = entity;
            if (entity3 instanceof Villager && (villager = (Villager)entity3).m_7141_().m_35560_() == SkiesVillagers.SHADED_WOODLANDS) {
                return;
            }
            int durration = 20 * (level.m_46791_().m_19028_() + 3);
            int amplifier = level.m_46791_().m_19028_() / 2;
            if (level.m_5776_() && !((Boolean)state.m_61143_((Property)openProperty)).booleanValue()) {
                block.m_7100_(level.m_8055_(pos), level, pos, new Random());
            }
            level.m_46597_(pos, (BlockState)block.m_49966_().m_61124_((Property)openProperty, (Comparable)Boolean.valueOf(true)));
            if (!living.m_21023_(MobEffects.f_19614_)) {
                living.m_7292_(new MobEffectInstance(MobEffects.f_19614_, durration, amplifier));
            }
            level.m_6219_().m_5945_(pos, (Object)block, 100);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(BlockState state, Level level, BlockPos pos, Random rand) {
        if (((Boolean)state.m_61143_((Property)OPEN)).booleanValue() && rand.nextFloat() < 0.7f) {
            Vec3 offset = state.m_60824_((BlockGetter)level, pos);
            for (int i = rand.nextInt(2) + 1; i > 0; --i) {
                float dx = (rand.nextFloat() - 0.5f) / 7.0f;
                float dy = rand.nextFloat() / 10.0f;
                float dz = (rand.nextFloat() - 0.5f) / 7.0f;
                level.m_7106_((ParticleOptions)new PoisonData(false), (double)pos.m_123341_() + 0.5 + offset.f_82479_, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5 + offset.f_82481_, (double)dx, (double)dy, (double)dz);
            }
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{OPEN});
    }
}

