/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.blocks.construction;

import com.legacy.structure_gel.api.util.VoxelShapeUtil;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WallMoonstoneBlock
extends FaceAttachedHorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape FLOOR = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0);
    private static final VoxelShape CEILING = VoxelShapeUtil.mirror((VoxelShape)FLOOR, (Direction.Axis)Direction.Axis.Y);
    private static final VoxelShape NORTH = Block.m_49796_((double)4.0, (double)4.0, (double)14.0, (double)12.0, (double)12.0, (double)16.0);
    private static final VoxelShape SOUTH = VoxelShapeUtil.rotate((VoxelShape)NORTH, (Direction)Direction.SOUTH);
    private static final VoxelShape EAST = VoxelShapeUtil.rotate((VoxelShape)NORTH, (Direction)Direction.EAST);
    private static final VoxelShape WEST = VoxelShapeUtil.rotate((VoxelShape)NORTH, (Direction)Direction.WEST);

    public WallMoonstoneBlock(BlockBehaviour.Properties builder) {
        super(builder);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)f_53179_, (Comparable)AttachFace.WALL)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        return WallMoonstoneBlock.isValidFace(worldIn, pos, WallMoonstoneBlock.m_53200_((BlockState)state).m_122424_());
    }

    public static boolean isValidFace(LevelReader worldIn, BlockPos pos, Direction direction) {
        BlockPos blockPos = pos.m_142300_(direction);
        if (direction.m_122434_() == Direction.Axis.Y && (BlockTags.f_13039_.m_8110_((Object)worldIn.m_8055_(blockPos).m_60734_()) || BlockTags.f_13032_.m_8110_((Object)worldIn.m_8055_(blockPos).m_60734_()))) {
            return true;
        }
        return worldIn.m_8055_(blockPos).m_60783_((BlockGetter)worldIn, blockPos, direction.m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_53179_, f_54117_, WATERLOGGED});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        switch ((AttachFace)state.m_61143_((Property)f_53179_)) {
            case WALL: {
                switch ((Direction)state.m_61143_((Property)f_54117_)) {
                    case NORTH: {
                        return NORTH;
                    }
                    case SOUTH: {
                        return SOUTH;
                    }
                    case EAST: {
                        return EAST;
                    }
                }
                return WEST;
            }
            case CEILING: {
                return CEILING;
            }
        }
        return FLOOR;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : Fluids.f_76191_.m_76145_();
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_6217_().m_5945_(currentPos, (Object)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        for (Direction direction : context.m_6232_()) {
            BlockState blockstate = direction.m_122434_() == Direction.Axis.Y ? (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_53179_, (Comparable)(direction == Direction.UP ? AttachFace.CEILING : AttachFace.FLOOR))).m_61124_((Property)f_54117_, (Comparable)context.m_8125_()) : (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_53179_, (Comparable)AttachFace.WALL)).m_61124_((Property)f_54117_, (Comparable)direction.m_122424_());
            if (!blockstate.m_60710_((LevelReader)context.m_43725_(), context.m_8083_())) continue;
            return (BlockState)blockstate.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_));
        }
        return null;
    }
}

