/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.blocks.construction;

import com.legacy.blue_skies.data.objects.SkiesItemTags;
import com.legacy.blue_skies.util.DirectionUtil;
import com.legacy.structure_gel.api.util.VoxelShapeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TroughBlock
extends HorizontalDirectionalBlock
implements WorldlyContainerHolder {
    public static final IntegerProperty LEVEL = IntegerProperty.m_61631_((String)"level", (int)0, (int)4);
    private static final Map<Direction, List<VoxelShape>> SHAPES = new HashMap<Direction, List<VoxelShape>>();

    public TroughBlock(BlockBehaviour.Properties builder) {
        super(builder);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.m_61143_((Property)f_54117_)).get((Integer)state.m_61143_((Property)LEVEL));
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.m_61143_((Property)f_54117_)).get(0);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_());
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        int level = (Integer)state.m_61143_((Property)LEVEL);
        ItemStack heldStack = player.m_21120_(hand);
        if (level < 4 && TroughBlock.canUseItem(heldStack)) {
            if (!world.f_46443_) {
                TroughBlock.attemptFill(state, (LevelAccessor)world, pos, heldStack);
                if (!player.m_150110_().f_35937_) {
                    heldStack.m_41774_(1);
                }
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public static boolean attemptFill(BlockState state, LevelAccessor world, BlockPos pos, ItemStack fillWithStack) {
        if (TroughBlock.canUseItem(fillWithStack) && world.m_5822_().nextFloat() < 0.4f) {
            BlockState newState = (BlockState)state.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(Math.min(4, (Integer)state.m_61143_((Property)LEVEL) + 1)));
            world.m_7731_(pos, newState, 3);
            world.m_46796_(1500, pos, 1);
            return true;
        }
        world.m_46796_(1500, pos, 0);
        return false;
    }

    public static boolean canConsume(BlockState state, LevelAccessor world) {
        return (Integer)state.m_61143_((Property)LEVEL) > 0;
    }

    public static boolean attemptConsume(BlockState state, LevelAccessor world, BlockPos pos) {
        if (TroughBlock.canConsume(state, world)) {
            BlockState newState = (BlockState)state.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(Math.max(0, (Integer)state.m_61143_((Property)LEVEL) - 1)));
            world.m_7731_(pos, newState, 3);
            return true;
        }
        return false;
    }

    public static boolean canUseItem(ItemStack item) {
        return item.m_150922_(SkiesItemTags.TROUGH_FOODS);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        return (Integer)state.m_61143_((Property)LEVEL);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, LEVEL});
    }

    public WorldlyContainer m_5840_(BlockState state, LevelAccessor world, BlockPos pos) {
        return new TroughInventory(state, world, pos);
    }

    static {
        VoxelShape outside = Block.m_49796_((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)10.0, (double)14.0);
        for (Direction dir : DirectionUtil.HORIZONTAL) {
            SHAPES.put(dir, new ArrayList());
            for (int i = 0; i <= 4; ++i) {
                SHAPES.get(dir).add(VoxelShapeUtil.rotate((VoxelShape)Shapes.m_83113_((VoxelShape)outside, (VoxelShape)Block.m_49796_((double)1.0, (double)(i * 2 + 1), (double)3.0, (double)15.0, (double)10.0, (double)13.0), (BooleanOp)BooleanOp.f_82685_), (Direction)dir));
            }
        }
    }

    static class TroughInventory
    extends SimpleContainer
    implements WorldlyContainer {
        private final BlockState state;
        private final int level;
        private final LevelAccessor world;
        private final BlockPos pos;
        private boolean hasInserted = false;

        protected TroughInventory(BlockState state, LevelAccessor world, BlockPos pos) {
            super(1);
            this.state = state;
            this.level = (Integer)state.m_61143_((Property)LEVEL);
            this.world = world;
            this.pos = pos;
        }

        public int[] m_7071_(Direction dir) {
            int[] nArray;
            if (dir == Direction.UP) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 0;
            } else {
                nArray = new int[]{};
            }
            return nArray;
        }

        public boolean m_7155_(int index, ItemStack stack, @Nullable Direction dir) {
            return !this.hasInserted && this.level < 4 && dir == Direction.UP && TroughBlock.canUseItem(stack);
        }

        public boolean m_7157_(int index, ItemStack stack, Direction dir) {
            return false;
        }

        public void m_6596_() {
            ItemStack stackInThis = this.m_8020_(0);
            if (!stackInThis.m_41619_()) {
                this.hasInserted = true;
                TroughBlock.attemptFill(this.state, this.world, this.pos, stackInThis);
                this.m_8016_(0);
            }
        }
    }
}

