/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.block_entity;

import com.legacy.blue_skies.block_entity.SkiesBlockEntity;
import com.legacy.blue_skies.entities.util.interfaces.ISkyBoss;
import com.legacy.blue_skies.events.SkiesPlayerEvents;
import com.legacy.blue_skies.registries.SkiesBlockEntityTypes;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.registries.SkiesItems;
import com.legacy.blue_skies.registries.SkiesSounds;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class KeystoneBlockEntity
extends SkiesBlockEntity {
    public static BlockPos posUp = new BlockPos(0, 1, 0);
    protected EntityType<?> containedMob;
    protected Item key;
    protected Item arc;
    protected boolean spawnsBoss = true;
    protected boolean keysRequired = true;
    protected BlockPos spawnOffset;
    protected BlockPos teleportOffset;

    public KeystoneBlockEntity(BlockEntityType<?> type, BlockPos tilePos, BlockState tileState, EntityType<?> containedMob, Item key, Item arc, BlockPos spawnOffset, BlockPos teleportOffset) {
        super(type, tilePos, tileState);
        this.containedMob = containedMob;
        this.key = key;
        this.arc = arc;
        this.spawnOffset = spawnOffset;
        this.teleportOffset = teleportOffset;
    }

    public void spawnMob(boolean spawnedFromArc) {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && this.spawnsBoss && this.f_58857_ instanceof ServerLevelAccessor) {
            BlockPos position = this.f_58858_.m_141952_((Vec3i)this.spawnOffset);
            Entity mob = this.containedMob.m_20615_(this.f_58857_);
            if (mob instanceof ISkyBoss) {
                ((ISkyBoss)mob).setInvulTime(100);
                ((ISkyBoss)mob).setDungeonSpawned(true);
                ((ISkyBoss)mob).setHome(position);
                ((ISkyBoss)mob).setBossRespawned(spawnedFromArc);
                position = position.m_141952_((Vec3i)((ISkyBoss)mob).bossSpawnOffset());
            }
            mob.m_6034_((double)position.m_123341_() + 0.5, (double)position.m_123342_(), (double)position.m_123343_() + 0.5);
            if (mob instanceof Mob) {
                ((Mob)mob).m_6518_((ServerLevelAccessor)this.f_58857_, this.f_58857_.m_6436_(position), MobSpawnType.TRIGGERED, (SpawnGroupData)null, (CompoundTag)null);
            }
            this.f_58857_.m_7967_(mob);
        }
    }

    public void teleportClosePlayers(Level worldIn) {
        List players = worldIn.m_45976_(ServerPlayer.class, new AABB(this.f_58858_, this.f_58858_).m_82400_(7.0));
        players.forEach(player -> this.teleportPlayer((Player)player));
    }

    public void teleportPlayer(Player player) {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_6263_(null, (double)((float)this.f_58858_.m_123341_() + 0.5f), (double)((float)this.f_58858_.m_123342_() + 0.5f), (double)((float)this.f_58858_.m_123343_() + 0.5f), SkiesSounds.BLOCK_KEYSTONE_TELEPORT, SoundSource.BLOCKS, 0.5f, 1.0f);
            BlockPos position = this.f_58858_.m_141952_((Vec3i)this.teleportOffset);
            player.m_6021_((double)position.m_123341_() + 0.5, (double)position.m_123342_(), (double)position.m_123343_() + 0.5);
        }
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.containedMob = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(compound.m_128461_("ContainedMob")));
        this.key = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(compound.m_128461_("Key")));
        this.arc = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(compound.m_128461_("Arc")));
        this.teleportOffset = compound.m_128441_("TeleportOffset") ? NbtUtils.m_129239_((CompoundTag)compound.m_128469_("TeleportOffset")) : BlockPos.f_121853_;
        this.spawnOffset = compound.m_128441_("SpawnOffset") ? NbtUtils.m_129239_((CompoundTag)compound.m_128469_("SpawnOffset")) : BlockPos.f_121853_;
        this.keysRequired = compound.m_128471_("KeysRequired");
        this.spawnsBoss = compound.m_128471_("SpawnsBoss");
    }

    public CompoundTag m_6945_(CompoundTag compound) {
        super.m_6945_(compound);
        if (this.containedMob.getRegistryName() != null) {
            compound.m_128359_("ContainedMob", this.containedMob.getRegistryName().toString());
        }
        compound.m_128359_("Arc", this.arc.getRegistryName().toString());
        compound.m_128359_("Key", this.key.getRegistryName().toString());
        compound.m_128365_("TeleportOffset", (Tag)NbtUtils.m_129224_((BlockPos)this.teleportOffset));
        compound.m_128365_("SpawnOffset", (Tag)NbtUtils.m_129224_((BlockPos)this.spawnOffset));
        compound.m_128379_("KeysRequired", this.keysRequired);
        compound.m_128379_("SpawnsBoss", this.spawnsBoss);
        return compound;
    }

    public void setContainedMob(EntityType<?> containedMob) {
        this.containedMob = containedMob;
        this.m_6596_();
    }

    public BlockPos getTeleportOffset() {
        return this.teleportOffset;
    }

    public void setTeleportOffset(BlockPos teleportOffset) {
        this.teleportOffset = teleportOffset;
        this.m_6596_();
    }

    public BlockPos getSpawnOffset() {
        return this.spawnOffset;
    }

    public void setSpawnOffset(BlockPos spawnOffset) {
        this.spawnOffset = spawnOffset;
        this.m_6596_();
    }

    public void setKey(Item key) {
        this.key = key;
        this.m_6596_();
    }

    public void setArc(Item arc) {
        this.arc = arc;
        this.m_6596_();
    }

    public boolean getSpawnsBoss() {
        return this.spawnsBoss;
    }

    public void setSpawnsBoss(boolean spawnsBoss) {
        this.spawnsBoss = spawnsBoss;
        this.m_6596_();
    }

    public boolean getKeysRequired() {
        return this.keysRequired;
    }

    public void setKeysRequired(boolean keysRequired) {
        this.keysRequired = keysRequired;
        this.m_6596_();
    }

    public boolean isCorrectArc(Item item) {
        return item == this.arc;
    }

    public boolean isCorrectKey(ItemStack stack) {
        return stack.m_41720_() == this.key && stack.m_41613_() >= 4;
    }

    public int getBossRoomSize() {
        return 15;
    }

    public int getBossRoomCeilingSize() {
        return 0;
    }

    public boolean isEverbrightBased() {
        return true;
    }

    public int getRequiredProgressionId() {
        return 0;
    }

    public static class PoisonKeystoneBlockEntity
    extends KeystoneBlockEntity {
        public PoisonKeystoneBlockEntity(BlockPos pos, BlockState state) {
            super(SkiesBlockEntityTypes.POISON_KEYSTONE, pos, state, SkiesEntityTypes.ARACHNARCH, SkiesItems.poison_key, SkiesItems.poison_arc, posUp, posUp);
        }

        public void teleportPlayer(Player player, Direction clickFace, Direction blockDirection) {
            if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
                boolean leaving;
                boolean bl = leaving = clickFace != blockDirection;
                if (leaving && SkiesPlayerEvents.inBossFight(player)) {
                    this.f_58857_.m_6263_(null, (double)((float)this.f_58858_.m_123341_() + 0.5f), (double)((float)this.f_58858_.m_123342_() + 0.5f), (double)((float)this.f_58858_.m_123343_() + 0.5f), SkiesSounds.BLOCK_KEYSTONE_LOCKED, SoundSource.BLOCKS, 1.0f, 1.0f);
                    player.m_5661_((Component)new TranslatableComponent("tile.keystone.leaving_in_fight"), true);
                    return;
                }
                this.f_58857_.m_6263_(null, (double)((float)this.f_58858_.m_123341_() + 0.5f), (double)((float)this.f_58858_.m_123342_() + 0.5f), (double)((float)this.f_58858_.m_123343_() + 0.5f), SkiesSounds.BLOCK_KEYSTONE_TELEPORT, SoundSource.BLOCKS, 0.5f, 1.0f);
                BlockPos position = this.f_58858_.m_141952_((Vec3i)this.teleportOffset);
                if (leaving) {
                    position = this.f_58858_.m_141952_((Vec3i)new BlockPos(-this.teleportOffset.m_123341_(), this.teleportOffset.m_123342_(), -this.teleportOffset.m_123343_()));
                }
                player.m_6021_((double)position.m_123341_() + 0.5, (double)position.m_123342_(), (double)position.m_123343_() + 0.5);
            }
        }

        @Override
        public int getBossRoomCeilingSize() {
            return 15;
        }

        @Override
        public boolean isEverbrightBased() {
            return false;
        }

        @Override
        public int getRequiredProgressionId() {
            return 1;
        }
    }

    public static class NatureKeystoneBlockEntity
    extends KeystoneBlockEntity {
        public NatureKeystoneBlockEntity(BlockPos pos, BlockState state) {
            super(SkiesBlockEntityTypes.NATURE_KEYSTONE, pos, state, SkiesEntityTypes.STARLIT_CRUSHER, SkiesItems.nature_key, SkiesItems.nature_arc, posUp, posUp);
        }

        public void teleportPlayer(Player player, Direction clickFace, Direction blockDirection) {
            if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
                boolean leaving;
                boolean bl = leaving = clickFace != blockDirection;
                if (leaving && SkiesPlayerEvents.inBossFight(player)) {
                    this.f_58857_.m_6263_(null, (double)((float)this.f_58858_.m_123341_() + 0.5f), (double)((float)this.f_58858_.m_123342_() + 0.5f), (double)((float)this.f_58858_.m_123343_() + 0.5f), SkiesSounds.BLOCK_KEYSTONE_LOCKED, SoundSource.BLOCKS, 1.0f, 1.0f);
                    player.m_5661_((Component)new TranslatableComponent("tile.keystone.leaving_in_fight"), true);
                    return;
                }
                this.f_58857_.m_6263_(null, (double)((float)this.f_58858_.m_123341_() + 0.5f), (double)((float)this.f_58858_.m_123342_() + 0.5f), (double)((float)this.f_58858_.m_123343_() + 0.5f), SkiesSounds.BLOCK_KEYSTONE_TELEPORT, SoundSource.BLOCKS, 0.5f, 1.0f);
                BlockPos position = this.f_58858_.m_141952_((Vec3i)this.teleportOffset);
                if (leaving) {
                    position = this.f_58858_.m_141952_((Vec3i)new BlockPos(-this.teleportOffset.m_123341_(), this.teleportOffset.m_123342_(), -this.teleportOffset.m_123343_()));
                }
                player.m_6021_((double)position.m_123341_() + 0.5, (double)position.m_123342_(), (double)position.m_123343_() + 0.5);
            }
        }

        @Override
        public int getRequiredProgressionId() {
            return 1;
        }
    }

    public static class DawnBlindingKeystoneBlockEntity
    extends KeystoneBlockEntity {
        public DawnBlindingKeystoneBlockEntity(BlockPos pos, BlockState state) {
            super(SkiesBlockEntityTypes.DAWN_BLINDING_KEYSTONE, pos, state, SkiesEntityTypes.ALCHEMIST, SkiesItems.blinding_key, SkiesItems.dusk_arc, posUp, posUp);
        }

        @Override
        public int getBossRoomSize() {
            return 20;
        }

        @Override
        public boolean isEverbrightBased() {
            return false;
        }
    }

    public static class BrightBlindingKeystoneBlockEntity
    extends KeystoneBlockEntity {
        public BrightBlindingKeystoneBlockEntity(BlockPos pos, BlockState state) {
            super(SkiesBlockEntityTypes.BRIGHT_BLINDING_KEYSTONE, pos, state, SkiesEntityTypes.SUMMONER, SkiesItems.blinding_key, SkiesItems.ethereal_arc, posUp, posUp);
        }

        @Override
        public int getBossRoomSize() {
            return 20;
        }
    }
}

