/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.asm_hooks;

import com.legacy.blue_skies.BlueSkiesConfig;
import com.legacy.blue_skies.world.general_features.AbstractSkyTreeFeature;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.DecoratedFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;

public class ConfiguredFeatureHooks {
    public static boolean blue_skies_isAllowedToGenerate(ConfiguredFeature<?, ?> configuredFeature) {
        if (ConfiguredFeatureHooks.checkConfiguredFeature(configuredFeature)) {
            return true;
        }
        return ConfiguredFeatureHooks.checkFeature(configuredFeature.f_65377_, configuredFeature.f_65378_);
    }

    private static boolean checkConfiguredFeature(ConfiguredFeature<?, ?> configuredFeature) {
        ResourceLocation registryName = BuiltinRegistries.f_123861_.m_7981_(configuredFeature);
        if (registryName != null) {
            return BlueSkiesConfig.COMMON.isModAllowedForFeatureGen(registryName.m_135827_());
        }
        return false;
    }

    private static boolean checkFeature(Feature<?> feature, FeatureConfiguration config) {
        if (config instanceof DecoratedFeatureConfiguration) {
            feature = ConfiguredFeatureHooks.diveIntoDecorated((DecoratedFeatureConfiguration)config);
        }
        if (feature != null) {
            if (feature instanceof AbstractSkyTreeFeature) {
                return true;
            }
            ResourceLocation registryName = feature.getRegistryName();
            if (registryName != null) {
                return BlueSkiesConfig.COMMON.isModAllowedForFeatureGen(registryName.m_135827_()) && feature != Feature.f_65760_;
            }
        }
        return false;
    }

    private static Feature<?> diveIntoDecorated(DecoratedFeatureConfiguration config) {
        ConfiguredFeature configuredFeature = (ConfiguredFeature)config.f_67577_.get();
        if (configuredFeature.f_65378_ instanceof DecoratedFeatureConfiguration) {
            return ConfiguredFeatureHooks.diveIntoDecorated((DecoratedFeatureConfiguration)configuredFeature.f_65378_);
        }
        return configuredFeature.f_65377_;
    }
}

