/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.events;

import com.legacy.structure_gel.api.biome_dictionary.BiomeDictionary;
import com.legacy.structure_gel.api.biome_dictionary.BiomeType;
import com.legacy.structure_gel.api.registry.registrar.StructureRegistrar;
import com.legacy.structure_gel.api.structure.GelStructure;
import com.legacy.structure_gel.api.structure.base.IConfigStructure;
import com.legacy.structure_gel.api.util.GelCollectors;
import com.legacy.structure_gel.core.SGConfig;
import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.capability.entity.GelCapability;
import com.legacy.structure_gel.core.capability.entity.GelEntityProvider;
import com.legacy.structure_gel.core.capability.entity.IGelEntity;
import com.legacy.structure_gel.core.commands.StructureGelCommand;
import com.legacy.structure_gel.core.network.PacketHandler;
import com.legacy.structure_gel.core.util.Internal;
import com.mojang.brigadier.CommandDispatcher;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.StructureSettings;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryBuilder;

@Internal
public class SGCommonEvents {
    public static void init(IEventBus modBus, IEventBus forgeBus) {
        modBus.addListener(SGCommonEvents::commonInit);
        modBus.addListener(SGCommonEvents::loadComplete);
        modBus.addListener(SGCommonEvents::createRegistries);
        modBus.addListener(SGCommonEvents::registerCapability);
        forgeBus.addListener(SGCommonEvents::registerCommands);
        forgeBus.addListener(SGCommonEvents::onEntityJoinLevel);
        forgeBus.addListener(SGCommonEvents::loadLevel);
        forgeBus.addGenericListener(Entity.class, SGCommonEvents::attachCapabilities);
    }

    protected static void commonInit(FMLCommonSetupEvent event) {
        PacketHandler.register();
    }

    protected static void loadComplete(FMLLoadCompleteEvent event) {
        try {
            if (SGConfig.COMMON.shouldGuessBiomeDict()) {
                StructureGelMod.log("Attempting to register unregistered biomes to the biome dictionary. This can be disabled via config", new Object[0]);
                BiomeDictionary.makeGuess();
            }
        }
        catch (Throwable e) {
            StructureGelMod.logError("Encountered an issue while making assumptions for the biome dictionary. Please narrow down which mods cause a conflict here and report it to our issue tracker: https://gitlab.com/modding-legacy/structure-gel-api/-/issues", new Object[0]);
            e.printStackTrace();
        }
        ForgeRegistries.STRUCTURE_FEATURES.forEach(structure -> {
            StructureFeature configStructure$temp = structure;
            if (configStructure$temp instanceof IConfigStructure) {
                IConfigStructure configStructure = (IConfigStructure)configStructure$temp;
                StructureGelMod.debug("Reloading biome config for {}", structure.getRegistryName());
                configStructure.getConfig().reloadBiomes();
            }
        });
    }

    protected static void loadLevel(WorldEvent.Load event) {
        ServerLevel level;
        ChunkGenerator chunkGen;
        LevelAccessor levelAccessor = event.getWorld();
        if (levelAccessor instanceof ServerLevel && !((chunkGen = (level = (ServerLevel)levelAccessor).m_7726_().m_8481_()) instanceof FlatLevelSource)) {
            StructureSettings settings = chunkGen.m_62205_();
            ResourceLocation levelDimName = level.m_46472_().m_135782_();
            for (StructureRegistrar<?, ?> registrar : StructureRegistrar.REGISTRARS) {
                Object structure = registrar.getStructure();
                StructureFeatureConfiguration separation = registrar.getFeatureConfiguration();
                boolean flag = false;
                Object obj = structure;
                if (obj instanceof GelStructure) {
                    GelStructure gelStructure = (GelStructure)((Object)obj);
                    Set<ResourceLocation> dims = gelStructure.getValidDimensions();
                    if (dims == null || dims.contains(levelDimName)) {
                        flag = true;
                    }
                } else {
                    flag = true;
                }
                if (!flag) continue;
                StructureGelMod.debug("Adding structure {} to dimension {}", structure.m_67098_(), levelDimName.toString());
                settings.f_64582_ = GelCollectors.addToMap(settings.f_64582_, structure, separation);
            }
        }
    }

    protected static void registerCapability(RegisterCapabilitiesEvent event) {
        event.register(IGelEntity.class);
    }

    protected static void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (!((Entity)event.getObject()).getCapability(GelCapability.INSTANCE).isPresent()) {
            GelEntityProvider provider = new GelEntityProvider();
            event.addCapability(StructureGelMod.locate("gel_entity"), (ICapabilityProvider)provider);
        }
    }

    protected static void onEntityJoinLevel(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            GelCapability.ifPresent(serverPlayer, gelPlayer -> gelPlayer.sendToClient(serverPlayer));
        }
    }

    protected static void createRegistries(RegistryEvent.NewRegistry event) {
        new RegistryBuilder().setName(StructureGelMod.locate("biome_dictionary")).setType(BiomeType.class).setDefaultKey(StructureGelMod.locate("empty")).create();
    }

    protected static void registerCommands(RegisterCommandsEvent event) {
        StructureGelCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }
}

