/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.biome_dictionary;

import com.google.common.collect.Sets;
import com.legacy.structure_gel.api.biome_dictionary.BiomeType;
import com.legacy.structure_gel.api.registry.registrar.BiomeRegistrar;
import com.legacy.structure_gel.core.util.Internal;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Internal
public class ForgeType
extends BiomeType {
    private final BiomeDictionary.Type type;

    @Internal
    private ForgeType(BiomeDictionary.Type type) {
        super(new ResourceLocation("forge", type.getName().toLowerCase(Locale.ENGLISH)), Sets.newHashSet(), Sets.newHashSet());
        this.type = type;
    }

    @Internal
    public static ForgeType create(BiomeDictionary.Type type) {
        return new ForgeType(type);
    }

    public BiomeDictionary.Type getType() {
        return this.type;
    }

    @Override
    public Set<ResourceLocation> getBiomes() {
        return BiomeDictionary.getBiomes((BiomeDictionary.Type)this.type).stream().map(ResourceKey::m_135782_).collect(Collectors.toSet());
    }

    @Override
    public Set<ResourceKey<Biome>> getAllBiomes() {
        return this.getBiomes().stream().filter(arg_0 -> ((IForgeRegistry)ForgeRegistries.BIOMES).containsKey(arg_0)).map(r -> ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOMES, (ResourceLocation)r)).collect(Collectors.toSet());
    }

    @Override
    public boolean contains(ResourceKey<Biome> key) {
        return this.contains(key.m_135782_());
    }

    @Override
    public boolean contains(Biome biome) {
        return this.contains(biome.getRegistryName());
    }

    @Override
    public boolean contains(ResourceLocation key) {
        return BiomeDictionary.getBiomes((BiomeDictionary.Type)this.type).stream().anyMatch(registryKey -> registryKey.m_135782_().equals((Object)key));
    }

    @Override
    public boolean equals(Object obj) {
        ForgeType type;
        Object object;
        return obj == this || (object = obj) instanceof ForgeType && (type = (ForgeType)object).getRegistryName() != null && this.getRegistryName() != null && type.getRegistryName().equals((Object)this.getRegistryName());
    }

    @Override
    public String toString() {
        String biomes = String.join((CharSequence)", ", this.getBiomes().stream().map(ResourceLocation::toString).sorted().collect(Collectors.toSet()));
        return String.format("name = %s, biomes = [%s]", this.getRegistryName().toString(), biomes);
    }

    @Override
    @Deprecated
    public ForgeType biomes(ResourceKey<Biome> ... biomes) {
        return this;
    }

    @Override
    @Deprecated
    public ForgeType biomes(Biome ... biomes) {
        return this;
    }

    @Override
    @Deprecated
    public ForgeType biomes(ResourceLocation ... biomes) {
        return this;
    }

    @Override
    @Deprecated
    public ForgeType biomes(BiomeRegistrar ... biomes) {
        return this;
    }

    @Override
    @Deprecated
    public ForgeType biomes(String modid, String ... biomes) {
        return this;
    }

    @Override
    @Deprecated
    public ForgeType biomes(Collection<ResourceLocation> biomes) {
        return this;
    }

    @Override
    @Deprecated
    public ForgeType biome(ResourceKey<Biome> biome) {
        return this;
    }

    @Override
    @Deprecated
    public ForgeType biome(Biome biome) {
        return this;
    }

    @Override
    @Deprecated
    public ForgeType biome(ResourceLocation biome) {
        return this;
    }

    @Override
    @Deprecated
    public ForgeType biome(BiomeRegistrar biome) {
        return this;
    }

    @Override
    @Deprecated
    public ForgeType setBiomes(Collection<ResourceLocation> biomes) {
        return this;
    }

    @Override
    @Deprecated
    public ForgeType parents(ResourceLocation ... parents) {
        return this;
    }

    @Override
    @Deprecated
    public ForgeType parents(BiomeType ... parents) {
        return this;
    }

    @Override
    @Deprecated
    public ForgeType parents(Collection<ResourceLocation> parents) {
        return this;
    }

    @Override
    @Deprecated
    public ForgeType parent(ResourceLocation parent) {
        return this;
    }

    @Override
    @Deprecated
    public Set<ResourceLocation> getParents() {
        return Sets.newHashSet();
    }

    @Override
    @Deprecated
    public ForgeType setParents(Collection<ResourceLocation> parents) {
        return this;
    }
}

