/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.structure.jigsaw;

import com.legacy.structure_gel.core.StructureGelMod;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.structures.FeaturePoolElement;
import net.minecraft.world.level.levelgen.feature.structures.ListPoolElement;
import net.minecraft.world.level.levelgen.feature.structures.SinglePoolElement;
import net.minecraft.world.level.levelgen.feature.structures.StructurePoolElement;
import net.minecraft.world.level.levelgen.feature.structures.StructureTemplatePool;

public class JigsawAccessHelper {
    public static void clearPool(ResourceLocation pool) {
        JigsawAccessHelper.modifyJigsawPattern(pool, template -> template.f_69250_.clear());
    }

    public static void addToPool(ResourceLocation pool, List<Pair<StructurePoolElement, Integer>> pieces) {
        JigsawAccessHelper.modifyJigsawPattern(pool, template -> {
            for (Pair pair : pieces) {
                for (int i = 0; i < (Integer)pair.getSecond(); ++i) {
                    template.f_69250_.add((StructurePoolElement)pair.getFirst());
                }
            }
        });
    }

    public static void removeFromPool(ResourceLocation pool, ResourceLocation elementName) {
        JigsawAccessHelper.modifyJigsawPattern(pool, template -> template.f_69250_.removeIf(element -> {
            StructurePoolElement singleElement$temp = element;
            if (singleElement$temp instanceof SinglePoolElement) {
                SinglePoolElement singleElement = (SinglePoolElement)singleElement$temp;
                return JigsawAccessHelper.getSingleJigsawPieceLocation(singleElement).equals((Object)elementName);
            }
            StructurePoolElement listElement$temp = element;
            if (listElement$temp instanceof ListPoolElement) {
                ListPoolElement listElement = (ListPoolElement)listElement$temp;
                return JigsawAccessHelper.removeFromListJigsaw(listElement, elementName);
            }
            return false;
        }));
    }

    public static void removeFromPool(ResourceLocation pool, Feature<?> feature) {
        JigsawAccessHelper.modifyJigsawPattern(pool, template -> template.f_69250_.removeIf(element -> {
            StructurePoolElement featureElement$temp = element;
            if (featureElement$temp instanceof FeaturePoolElement) {
                FeaturePoolElement featureElement = (FeaturePoolElement)featureElement$temp;
                return JigsawAccessHelper.getFeatureJigsawPieceFeatures((FeaturePoolElement)featureElement).f_65377_ == feature;
            }
            StructurePoolElement listElement$temp = element;
            if (listElement$temp instanceof ListPoolElement) {
                ListPoolElement listElement = (ListPoolElement)listElement$temp;
                return JigsawAccessHelper.removeFromListJigsaw(listElement, feature);
            }
            return false;
        }));
    }

    public static boolean removeFromListJigsaw(ListPoolElement listElement, ResourceLocation elementName) {
        JigsawAccessHelper.getListJigsawPiecePieces(listElement).removeIf(element -> {
            StructurePoolElement singleElement$temp = element;
            if (singleElement$temp instanceof SinglePoolElement) {
                SinglePoolElement singleElement = (SinglePoolElement)singleElement$temp;
                return JigsawAccessHelper.getSingleJigsawPieceLocation(singleElement).equals((Object)elementName);
            }
            StructurePoolElement l$temp = element;
            if (l$temp instanceof ListPoolElement) {
                ListPoolElement l = (ListPoolElement)l$temp;
                JigsawAccessHelper.removeFromListJigsaw(l, elementName);
                return JigsawAccessHelper.getListJigsawPiecePieces(l).isEmpty();
            }
            return false;
        });
        return JigsawAccessHelper.getListJigsawPiecePieces(listElement).isEmpty();
    }

    public static boolean removeFromListJigsaw(ListPoolElement listElement, Feature<?> feature) {
        JigsawAccessHelper.getListJigsawPiecePieces(listElement).removeIf(piece -> {
            StructurePoolElement featureElement$temp = piece;
            if (featureElement$temp instanceof FeaturePoolElement) {
                FeaturePoolElement featureElement = (FeaturePoolElement)featureElement$temp;
                return JigsawAccessHelper.getFeatureJigsawPieceFeatures((FeaturePoolElement)featureElement).f_65377_ == feature;
            }
            StructurePoolElement l$temp = piece;
            if (l$temp instanceof ListPoolElement) {
                ListPoolElement l = (ListPoolElement)l$temp;
                JigsawAccessHelper.removeFromListJigsaw(l, feature);
                return JigsawAccessHelper.getListJigsawPiecePieces(l).isEmpty();
            }
            return false;
        });
        return JigsawAccessHelper.getListJigsawPiecePieces(listElement).isEmpty();
    }

    public static ResourceLocation getSingleJigsawPieceLocation(SinglePoolElement element) {
        return (ResourceLocation)element.f_69098_.left().get();
    }

    public static List<StructurePoolElement> getListJigsawPiecePieces(ListPoolElement element) {
        return element.f_69058_;
    }

    public static ConfiguredFeature<?, ?> getFeatureJigsawPieceFeatures(FeaturePoolElement element) {
        return (ConfiguredFeature)element.f_68883_.get();
    }

    private static void modifyJigsawPattern(ResourceLocation key, Consumer<StructureTemplatePool> action) {
        BuiltinRegistries.f_123864_.m_6612_(key).ifPresentOrElse(action, () -> StructureGelMod.logError("Could not remove from {} because it has not been created yet.", key));
    }
}

