/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.block_entity;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;

public class SpawnerAccessHelper {
    public static void setMinSpawnDelay(SpawnerBlockEntity tile, Level level, BlockPos pos, int minSpawnelay) {
        SpawnerAccessHelper.modifySpawnerNBT(tile, level, pos, nbt -> nbt.m_128376_("MinSpawnDelay", (short)minSpawnelay));
    }

    public static void setMaxSpawnDelay(SpawnerBlockEntity tile, Level level, BlockPos pos, int maxSpawnDelay) {
        SpawnerAccessHelper.modifySpawnerNBT(tile, level, pos, nbt -> nbt.m_128376_("MaxSpawnDelay", (short)maxSpawnDelay));
    }

    public static void setSpawnCount(SpawnerBlockEntity tile, Level level, BlockPos pos, int spawnCount) {
        SpawnerAccessHelper.modifySpawnerNBT(tile, level, pos, nbt -> nbt.m_128376_("SpawnCount", (short)spawnCount));
    }

    public static void setMaxNearbyEntities(SpawnerBlockEntity tile, Level level, BlockPos pos, int maxNearbyEntities) {
        SpawnerAccessHelper.modifySpawnerNBT(tile, level, pos, nbt -> nbt.m_128376_("MaxNearbyEntities", (short)maxNearbyEntities));
    }

    public static void setRequiredPlayerRange(SpawnerBlockEntity tile, Level level, BlockPos pos, int requiredPlayerRange) {
        SpawnerAccessHelper.modifySpawnerNBT(tile, level, pos, nbt -> nbt.m_128376_("RequiredPlayerRange", (short)requiredPlayerRange));
    }

    public static void setSpawnRange(SpawnerBlockEntity tile, Level level, BlockPos pos, int spawnRange) {
        SpawnerAccessHelper.modifySpawnerNBT(tile, level, pos, nbt -> nbt.m_128376_("SpawnRange", (short)spawnRange));
    }

    public static void setSpawnPotentials(SpawnerBlockEntity tile, Level level, BlockPos pos, EntityType<?> entityType) {
        SpawnerAccessHelper.setSpawnPotentials(tile, level, pos, SpawnerAccessHelper.createSpawnerEntity(entityType));
    }

    public static void setSpawnPotentials(SpawnerBlockEntity tile, Level level, BlockPos pos, SpawnData ... spawnDatas) {
        SpawnerAccessHelper.setSpawnPotentials(tile, level, pos, Arrays.asList(spawnDatas));
    }

    public static void setSpawnPotentials(SpawnerBlockEntity tile, Level level, BlockPos pos, Collection<SpawnData> spawnDatas) {
        SpawnerAccessHelper.modifySpawnerNBT(tile, level, pos, nbt -> {
            if (!spawnDatas.isEmpty()) {
                nbt.m_128365_("SpawnData", (Tag)((SpawnData)spawnDatas.stream().findAny().get()).m_47265_());
                ListTag listNbt = new ListTag();
                spawnDatas.forEach(wse -> listNbt.add((Object)wse.m_47264_()));
                nbt.m_128365_("SpawnPotentials", (Tag)listNbt);
            }
        });
    }

    public static SpawnData createSpawnerEntity(EntityType<?> entity) {
        return SpawnerAccessHelper.createSpawnerEntity(1, entity);
    }

    public static SpawnData createSpawnerEntity(int weight, EntityType<?> entity) {
        return SpawnerAccessHelper.createSpawnerEntity(weight, entity, new CompoundTag());
    }

    public static SpawnData createSpawnerEntity(int weight, EntityType<?> entity, CompoundTag entityNBT) {
        CompoundTag nbt = new CompoundTag();
        entityNBT.m_128359_("id", entity.getRegistryName().toString());
        nbt.m_128365_("Entity", (Tag)entityNBT);
        return new SpawnData(weight, entityNBT);
    }

    public static void modifySpawnerNBT(SpawnerBlockEntity spawner, Level level, BlockPos pos, Consumer<CompoundTag> nbtConsumer) {
        CompoundTag nbt = new CompoundTag();
        spawner.m_59801_().m_151339_(level, pos, nbt);
        nbtConsumer.accept(nbt);
        spawner.m_59801_().m_151328_(level, pos, nbt);
    }
}

