/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.biome_dictionary;

import com.legacy.structure_gel.api.biome_dictionary.BiomeType;
import com.legacy.structure_gel.core.SGConfig;
import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.biome_dictionary.ForgeType;
import com.legacy.structure_gel.core.util.Internal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.GravelBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;

public class BiomeDictionary {
    public static final IForgeRegistry<BiomeType> REGISTRY = RegistryManager.ACTIVE.getRegistry(BiomeType.class);
    private static final String bop = "biomesoplenty";
    private static final String nethercraft = "nethercraft";
    private static final String endergetic = "endergetic";
    private static final String rediscovered = "rediscovered";
    private static final String moo = "moolands";
    private static final String pagamos = "pagamos";
    private static final String glacidus = "glacidus";
    private static final String byg = "byg";
    private static final String aether = "aether";
    private static final Map<ResourceLocation, List<BiomeType>> BIOME_TO_BIOMETYPE_CACHE = new HashMap<ResourceLocation, List<BiomeType>>();
    protected static final ResourceLocation EMPTY_NAME = StructureGelMod.locate("empty");
    @Internal
    public static final BiomeType EMPTY = new BiomeType(EMPTY_NAME, new HashSet<ResourceLocation>(), new HashSet<ResourceLocation>());
    public static final BiomeType FROZEN_OCEAN = BiomeDictionary.register(BiomeType.create("frozen_ocean").biomes(Biomes.f_48211_, Biomes.f_48172_));
    public static final BiomeType COLD_OCEAN = BiomeDictionary.register(BiomeType.create("cold_ocean").biomes(Biomes.f_48168_, Biomes.f_48171_));
    public static final BiomeType WARM_OCEAN = BiomeDictionary.register(BiomeType.create("warm_ocean").biomes(Biomes.f_48166_, Biomes.f_48169_));
    public static final BiomeType OCEAN = BiomeDictionary.register(BiomeType.create("ocean").parents(COLD_OCEAN, WARM_OCEAN, FROZEN_OCEAN).biomes(Biomes.f_48174_, Biomes.f_48170_, Biomes.f_48225_, Biomes.f_48167_).biomes("byg", "dead_sea"));
    public static final BiomeType PLAINS = BiomeDictionary.register(BiomeType.create("plains").biomes(Biomes.f_48202_, Biomes.f_48176_).biomes("biomesoplenty", "grove_clearing", "steppe", "highland", "tundra", "lush_grassland", "jade_grassland", "shrubland", "wooded_scrubland", "lush_savanna", "scrubland", "flower_meadow", "prairie", "golden_prairie").biomes("byg", "allium_fields", "amaranth_fields", "meadow", "prairie", "prairie_clearing", "shrublands", "wooded_meadow"));
    public static final BiomeType SNOWY_PLAINS = BiomeDictionary.register(BiomeType.create("snowy_plains").biomes(Biomes.f_48213_));
    public static final BiomeType DESERT = BiomeDictionary.register(BiomeType.create("desert").biomes(Biomes.f_48203_, Biomes.f_48218_, Biomes.f_48177_).biomes("biomesoplenty", "xeric_shrubland", "outback", "lush_desert").biomes("byg", "dunes", "lush_red_desert", "mojave_desert", "red_desert", "red_desert_dunes"));
    public static final BiomeType SAVANNA = BiomeDictionary.register(BiomeType.create("savanna").biomes(Biomes.f_48157_, Biomes.f_48158_).biomes("biomesoplenty", "brushland").biomes("byg", "baobab_savanna"));
    public static final BiomeType MOUNTAIN_SAVANNA = BiomeDictionary.register(BiomeType.create("mountain_savanna").biomes(Biomes.f_48192_, Biomes.f_48193_));
    public static final BiomeType FLOWERY = BiomeDictionary.register(BiomeType.create("flowery").biomes(Biomes.f_48179_, Biomes.f_48176_).biomes("biomesoplenty", "lavender_field", "lavender_forest", "lush_savanna", "flower_meadow").biomes("byg", "allium_fields", "amaranth_fields", "flowering_enchanted_grove", "flowering_grove", "flowering_meadow"));
    public static final BiomeType OAK_FOREST = BiomeDictionary.register(BiomeType.create("oak_forest").biomes(Biomes.f_48205_, Biomes.f_48219_).biomes("biomesoplenty", "maple_forest", "snowy_maple_forest", "orchard", "origin_hills", "rainforest", "silkglade_nest", "snowy_forest").biomes("byg", "deciduous_clearing", "deciduous_forest", "deciduous_forest_hills", "orchard", "red_oak_forest", "red_oak_forest_hills", "snowy_deciduous_clearing", "snowy_deciduous_forest", "snowy_deciduous_forest_hills", "woodlands"));
    public static final BiomeType BIRCH_FOREST = BiomeDictionary.register(BiomeType.create("birch_forest").biomes(Biomes.f_48149_, Biomes.f_48150_, Biomes.f_48185_, Biomes.f_48186_).biomes("biomesoplenty", "boreal_forest", "rainbow_valley").biomes("byg", "aspen_clearing", "aspen_forest", "aspen_forest_hills"));
    public static final BiomeType SPRUCE_FOREST = BiomeDictionary.register(BiomeType.create("spruce_forest").biomes(Biomes.f_48206_, Biomes.f_48220_, Biomes.f_48180_).biomes("biomesoplenty", "coniferous_lakes", "grove", "meadow", "meadow_forest", "jade_cliffs").biomes("byg", "blue_taiga", "blue_taiga_hills", "boreal_clearing", "boreal_forest", "boreal_forest_hills", "evergreen_clearing", "evergreen_hills", "evergreen_taiga"));
    public static final BiomeType SNOWY_SPRUCE_FOREST = BiomeDictionary.register(BiomeType.create("snowy_spruce_forest").biomes(Biomes.f_48152_, Biomes.f_48153_, Biomes.f_48188_).biomes("byg", "apline_foothills", "snowy_blue_taiga", "snowy_blue_taiga_hills", "snowy_evergreen_clearing", "snowy_evergreen_hills", "snowy_evergreen_taiga"));
    public static final BiomeType LARGE_SPRUCE_FOREST = BiomeDictionary.register(BiomeType.create("large_spruce_forest").biomes(Biomes.f_48189_, Biomes.f_48190_, Biomes.f_48154_, Biomes.f_48155_).biomes("byg", "blue_giant_taiga", "snowy_blue_giant_taiga"));
    public static final BiomeType BAMBOO_JUNGLE = BiomeDictionary.register(BiomeType.create("bamboo_jungle").biomes(Biomes.f_48197_, Biomes.f_48198_));
    public static final BiomeType JUNGLE = BiomeDictionary.register(BiomeType.create("jungle").parents(BAMBOO_JUNGLE).biomes(Biomes.f_48222_, Biomes.f_48223_, Biomes.f_48224_, Biomes.f_48183_, Biomes.f_48184_).biomes("biomesoplenty", "rainforest_cliffs").biomes("byg", "guiana_clearing", "guiana_shield"));
    public static final BiomeType DARK_FOREST = BiomeDictionary.register(BiomeType.create("dark_forest").biomes(Biomes.f_48151_, Biomes.f_48187_).biomes("byg", "ancient_forest", "ebony_woods", "ebony_hills", "flowering_ancient_forest"));
    public static final BiomeType CONIFEROUS_FOREST = BiomeDictionary.register(BiomeType.create("coniferous_forest").biomes("biomesoplenty", "snowy_coniferous_forest", "coniferous_forest", "fir_clearing", "snowy_fir_clearing").biomes("byg", "coniferous_clearing", "coniferous_forest", "coniferous_forest_hills", "snowy_coniferous_clearing", "snowy_coniferous_forest", "snowy_coniferous_forest_hills"));
    public static final BiomeType REDWOOD_FOREST = BiomeDictionary.register(BiomeType.create("redwood_forest").biomes("biomesoplenty", "redwood_forest", "redwood_forest_edge", "redwood_forest", "redwood_forest_hills", "redwood_hills").biomes("byg", "redwood_clearing", "redwood_mountains", "redwood_tropics"));
    public static final BiomeType AUTUMN_FOREST = BiomeDictionary.register(BiomeType.create("autumn_forest").biomes("biomesoplenty", "maple_forest", "seasonal_forest", "seasonal_orchard", "seasonal_pumpkin_patch").biomes("byg", "maple_hills", "maple_taiga", "seasonal_birch_forest", "seasonal_birch_forest_hills", "seasonal_deciduous_clearing", "seasonal_deciduous_forest", "seasonal_deciduous_forest_hills", "seasonal_forest", "seasonal_forest_hills", "seasonal_giant_taiga", "seasonal_taiga", "seasonal_taiga_hills", "zelkova_clearing", "zelkova_forest", "zelkova_forest_hills"));
    public static final BiomeType CHERRY_FOREST = BiomeDictionary.register(BiomeType.create("cherry_forest").biomes("biomesoplenty", "cherry_blossom_grove", "bamboo_blossom_grove").biomes("byg", "cherry_blossom_clearing", "cherry_blossom_forest", "skyris_highlands"));
    public static final BiomeType BAMBOO = BiomeDictionary.register(BiomeType.create("bamboo").parents(BAMBOO_JUNGLE).biomes("biomesoplenty", "bamboo_blossom_grove").biomes("byg", "jacaranda_clearing", "jacaranda_forest", "jacaranda_forest_hills", "bamboo_forest", "crag_gardens"));
    public static final BiomeType MOUNTAIN = BiomeDictionary.register(BiomeType.create("mountain").biomes(Biomes.f_48204_, Biomes.f_48221_, Biomes.f_48178_, Biomes.f_48191_, Biomes.f_48156_).biomes("biomesoplenty", "steppe", "rainforest_cliffs", "highland_moor", "highland", "highland_crag", "shrubland_hills", "jade_cliffs").biomes("byg", "bluff_steeps", "cika_mountains", "crag_gardens", "dover_mountains", "grassland_plateau", "guiana_clearing", "guiana_shield", "redwood_mountains", "skyris_highlands", "wooded_grassland_plateau"));
    public static final BiomeType SNOWY_MOUNTAIN = BiomeDictionary.register(BiomeType.create("snowy_mountain").biomes(Biomes.f_48214_).biomes("biomesoplenty", "alps", "alps_foothills").biomes("byg", "apls", "apline_foothills", "bluff_peaks", "bluff_steeps"));
    public static final BiomeType SWAMP = BiomeDictionary.register(BiomeType.create("swamp").biomes(Biomes.f_48207_, Biomes.f_48181_).biomes("biomesoplenty", "dead_swamp", "rainforest_floodplain", "bayou", "deep_bayou", "wetland", "lush_swamp", "bog", "wetland_marsh").biomes("byg", "bayou", "tundra_bog", "cold_swamplands", "cypress_swamplands", "glowshroom_bayou", "marshlands", "vibrant_swamplands"));
    public static final BiomeType MANGROVE = BiomeDictionary.register(BiomeType.create("mangrove").biomes("biomesoplenty", "bayou_mangrove").biomes("byg", "coral_mangroves", "cypress_swamplands", "mangrove_marshes"));
    public static final BiomeType BADLANDS = BiomeDictionary.register(BiomeType.create("badlands").biomes(Biomes.f_48159_, Biomes.f_48161_, Biomes.f_48194_, Biomes.f_48196_, Biomes.f_48195_, Biomes.f_48160_).biomes("biomesoplenty", "outback").biomes("byg", "lush_red_desert", "red_desert", "red_desert_dunes", "red_rock_highlands", "red_rock_lowlands", "red_rock_mountains", "sierra_range", "sierra_valley", "wooded_red_rock_mountains"));
    public static final BiomeType MUSHROOM = BiomeDictionary.register(BiomeType.create("mushroom").biomes(Biomes.f_48216_, Biomes.f_48215_).biomes("biomesoplenty", "fungal_jungle", "overgrown_fungal_jungle").biomes("byg", "glowing_ancient_forest", "glowshroom_bayou"));
    public static final BiomeType FUNGAL = BiomeDictionary.register(BiomeType.create("fungal").parents(MUSHROOM).biomes("biomesoplenty", "fungal_field").biomes("byg", "fungal_patch"));
    public static final BiomeType RIVER = BiomeDictionary.register(BiomeType.create("river").biomes(Biomes.f_48208_, Biomes.f_48212_));
    public static final BiomeType LAKE = BiomeDictionary.register(BiomeType.create("lake").biomes("biomesoplenty", "oasis", "grove_lakes").biomes("byg", "fresh_water_lake", "oasis", "frozen_lake", "great_lakes", "polluted_lake"));
    public static final BiomeType BEACH = BiomeDictionary.register(BiomeType.create("beach").biomes(Biomes.f_48217_).biomes("biomesoplenty", "tropic_beach").biomes("byg", "rainbow_beach", "snowy_black_beach", "white_beach"));
    public static final BiomeType WOODED = BiomeDictionary.register(BiomeType.create("wooded").parents(OAK_FOREST, BIRCH_FOREST, SPRUCE_FOREST, SNOWY_SPRUCE_FOREST, DARK_FOREST, AUTUMN_FOREST, CHERRY_FOREST).biomes(Biomes.f_48179_).biomes("biomesoplenty", "seasonal_forest", "lavender_field", "tropical_rainforest", "dead_forest").biomes("byg", "jacaranda_forest", "the_black_forest", "black_forest_hills", "bluff_peaks", "bluff_steeps", "enchanted_forest", "enchanted_forest_hills", "flowering_meadow", "forest_fault", "glowing_ancient_forest", "great_lake_isles", "grove", "weeping_witch_forest", "weeping_witch_clearing", "wooded_grassland_plateau", "wooded_meadow", "wooded_red_rock_mountains"));
    public static final BiomeType LARGE_WOODED = BiomeDictionary.register(BiomeType.create("large_wooded").parents(LARGE_SPRUCE_FOREST, JUNGLE, CONIFEROUS_FOREST, REDWOOD_FOREST).biomes("byg", "cika_wooded", "cika_mountains", "dover_mountains", "northern_forest"));
    public static final BiomeType SANDY = BiomeDictionary.register(BiomeType.create("sandy").parents(DESERT, BEACH).biomes(Biomes.f_48199_, Biomes.f_48159_));
    public static final BiomeType GRAVELLY = BiomeDictionary.register(BiomeType.create("gravelly").biomes("biomesoplenty", "gravel_beach", "tundra_basin"));
    public static final BiomeType DIRTY = BiomeDictionary.register(BiomeType.create("dirty").biomes(Biomes.f_48189_, Biomes.f_48190_).biomes("byg", "black_forest_clearing"));
    public static final BiomeType TROPICAL = BiomeDictionary.register(BiomeType.create("tropical").biomes("biomesoplenty", "tropic_beach", "tropics", "tropic_plains", "rainforest", "tropical_rainforest", "rainforest_cliffs").biomes("byg", "tropical_fungal_forest", "tropical_fungal_rainforest_hills", "tropical_island", "tropical_rainforest", "tropical_rainforest_hills"));
    public static final BiomeType VOLCANIC = BiomeDictionary.register(BiomeType.create("volcanic").biomes("biomesoplenty", "volcanic_plains", "volcano"));
    public static final BiomeType DEAD = BiomeDictionary.register(BiomeType.create("dead").biomes(Biomes.f_48209_).biomes("biomesoplenty", "wooded_wasteland", "dry_boneyard", "burnt_forest", "dead_forest", "wasteland", "silkglade", "silkglade_nest", "xeric_shrubland", "brushland", "dead_swamp", "dryland").biomes("byg", "dead_sea"));
    public static final BiomeType SKY = BiomeDictionary.register(BiomeType.create("sky").biomes("rediscovered", "skylands"));
    public static final BiomeType CAVE = BiomeDictionary.register(BiomeType.create("cave").biomes(Biomes.f_151785_, Biomes.f_151784_));
    public static final BiomeType FROZEN = BiomeDictionary.register(BiomeType.create("frozen").biomes(Biomes.f_48212_, Biomes.f_48182_).parents(FROZEN_OCEAN).biomes("byg", "frozen_lake", "shattered_glacier"));
    public static final BiomeType SNOWY = BiomeDictionary.register(BiomeType.create("snowy").parents(SNOWY_SPRUCE_FOREST, SNOWY_PLAINS).biomes(Biomes.f_48212_, Biomes.f_48148_).biomes("biomesoplenty", "snowy_forest", "snowy_coniferous_forest", "snowy_fir_clearing", "muskeg", "alps", "alps_foothills", "snowy_black_beach", "snowy_blue_taiga", "snowy_blue_taiga_hills", "snowy_giant_blue_taiga", "snowy_coniferous_clearing", "snowy_coniferous_forest", "snowy_coniferous_forest_hills", "snowy_deciduous_clearing", "snowy_deciduous_forest", "snowy_deciduous_forest_hills", "snowy_evergreen_clearing", "snowy_evergreen_hills", "snowy_evergreen_taiga", "snowy_maple_forest", "snowy_rocky_black_beach"));
    public static final BiomeType COLD = BiomeDictionary.register(BiomeType.create("cold").parents(SPRUCE_FOREST, LARGE_SPRUCE_FOREST, CONIFEROUS_FOREST).biomes(Biomes.f_48204_, Biomes.f_48178_, Biomes.f_48156_, Biomes.f_48191_, Biomes.f_48226_).biomes("biomesoplenty", "tundra", "tundra_bog", "tundra_basin").biomes("byg", "cold_swamplands", "lush_tundra", "rocky_beach"));
    public static final BiomeType NEUTRAL_TEMP = BiomeDictionary.register(BiomeType.create("neutral_temp").parents(PLAINS, OAK_FOREST, BIRCH_FOREST, DARK_FOREST).biomes(Biomes.f_48179_));
    public static final BiomeType WARM = BiomeDictionary.register(BiomeType.create("warm").parents(SWAMP, MANGROVE, JUNGLE, MUSHROOM, TROPICAL));
    public static final BiomeType HOT = BiomeDictionary.register(BiomeType.create("hot").parents(DESERT, BADLANDS, SAVANNA, MOUNTAIN_SAVANNA, VOLCANIC));
    public static final BiomeType FIERY = BiomeDictionary.register(BiomeType.create("fiery").biomes(Biomes.f_48209_, Biomes.f_48199_, Biomes.f_48175_).biomes("byg", "embur_bog"));
    public static final BiomeType HUMID = BiomeDictionary.register(BiomeType.create("humid").parents(SWAMP, JUNGLE, TROPICAL));
    public static final BiomeType DRY = BiomeDictionary.register(BiomeType.create("dry").parents(DESERT, BADLANDS, SAVANNA, MOUNTAIN_SAVANNA, DEAD).biomes("biomesoplenty", "dryland"));
    public static final BiomeType VOID = BiomeDictionary.register(BiomeType.create("void").biomes(Biomes.f_48173_));
    public static final BiomeType MAGICAL = BiomeDictionary.register(BiomeType.create("magical").biomes("biomesoplenty", "mystic_grove", "mystic_plains", "rainbow_hills").biomes("byg", "enchanted_forest", "enchanted_forest_hills", "enchanted_grove", "flowering_enchanted_grove"));
    public static final BiomeType SPOOKY = BiomeDictionary.register(BiomeType.create("spooky").parents(DARK_FOREST).biomes("biomesoplenty", "ominous_woods", "ominous_mire", "pumpkin_patch", "silkglade_nest", "visceral_heap", "withered_abyss", "dryland").biomes("byg", "pumpkin_forest", "weeping_witch_forest", "weeping_witch_clearing"));
    public static final BiomeType RARE = BiomeDictionary.register(BiomeType.create("rare").biomes(Biomes.f_48224_, Biomes.f_48216_, Biomes.f_48215_, Biomes.f_48182_).biomes("biomesoplenty", "mystic_grove", "origin_valley", "rainbow_hills").biomes("byg", "rainbow_beach", "tropical_island"));
    public static final BiomeType SPACE = BiomeDictionary.register(BiomeType.create("space").biomes("glacidus", "glacidus"));
    public static final BiomeType PUMPKIN = BiomeDictionary.register(BiomeType.create("pumpkin").biomes("biomesoplenty", "pumpkin_patch", "seasonal_pumpkin_patch").biomes("byg", "pumpkin_forest", "autumnal_valley", "cika_wooded", "cika_mountains"));
    public static final BiomeType OVERGROWN_NETHER = BiomeDictionary.register(BiomeType.create("overgrown_nether").biomes("biomesoplenty", "undergrowth"));
    public static final BiomeType WARPED = BiomeDictionary.register(BiomeType.create("warped").biomes(Biomes.f_48201_).biomes("byg", "warped_desert"));
    public static final BiomeType CRIMSON = BiomeDictionary.register(BiomeType.create("crimson").biomes(Biomes.f_48200_));
    public static final BiomeType NETHER_FOREST = BiomeDictionary.register(BiomeType.create("nether_forest").biomes(Biomes.f_48200_, Biomes.f_48201_).biomes("nethercraft", "glowing_grove"));
    public static final BiomeType NETHER_FUNGAL = BiomeDictionary.register(BiomeType.create("nether_fungal").biomes(Biomes.f_48200_, Biomes.f_48201_).biomes("nethercraft", "glowshroom_garden").biomes("byg", "glowstone_gardens"));
    public static final BiomeType NETHER_SANDY = BiomeDictionary.register(BiomeType.create("nether_sandy").biomes(Biomes.f_48199_).biomes("nethercraft", "volcanic_rushes").biomes("byg", "warped_desert"));
    public static final BiomeType NETHER_EXTREME = BiomeDictionary.register(BiomeType.create("nether_extreme").biomes(Biomes.f_48175_));
    public static final BiomeType NETHER_FLESHY = BiomeDictionary.register(BiomeType.create("nether_fleshy").biomes("biomesoplenty", "visceral_heap"));
    public static final BiomeType OUTER_END_ISLAND = BiomeDictionary.register(BiomeType.create("outer_end_island").biomes(Biomes.f_48164_, Biomes.f_48163_).biomes("endergetic", "poise_forest", "chorus_plains", "end_midlands", "end_highlands").biomes("byg", "ivis_fields"));
    public static final BiomeType OUTER_END = BiomeDictionary.register(BiomeType.create("outer_end").parents(OUTER_END_ISLAND).biomes(Biomes.f_48165_, Biomes.f_48162_));
    public static final BiomeType AETHER = BiomeDictionary.register(BiomeType.create("aether").biomes("aether", "aether_skylands"));
    public static final BiomeType SKYLANDS = BiomeDictionary.register(BiomeType.create("skylands").biomes("rediscovered", "skylands"));
    public static final BiomeType MOOLANDS = BiomeDictionary.register(BiomeType.create("moolands").biomes("moolands", "awkward_heights"));
    public static final BiomeType PAGAMOS = BiomeDictionary.register(BiomeType.create("pagamos").biomes("pagamos", "frozen_hell"));
    public static final BiomeType GLACIDUS = BiomeDictionary.register(BiomeType.create("glacidus").biomes("glacidus", "glacidus"));
    public static final BiomeType GOOD_DREAM = BiomeDictionary.register(BiomeType.create("good_dream"));
    public static final BiomeType NIGHTMARE = BiomeDictionary.register(BiomeType.create("nightmare"));
    public static final ForgeType FORGE_HOT = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.HOT));
    public static final ForgeType FORGE_COLD = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.COLD));
    public static final ForgeType FORGE_SPARSE = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.SPARSE));
    public static final ForgeType FORGE_DENSE = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.DENSE));
    public static final ForgeType FORGE_WET = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.WET));
    public static final ForgeType FORGE_DRY = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.DRY));
    public static final ForgeType FORGE_SAVANNA = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.SAVANNA));
    public static final ForgeType FORGE_CONIFEROUS = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.CONIFEROUS));
    public static final ForgeType FORGE_JUNGLE = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.JUNGLE));
    public static final ForgeType FORGE_SPOOKY = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.SPOOKY));
    public static final ForgeType FORGE_DEAD = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.DEAD));
    public static final ForgeType FORGE_LUSH = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.LUSH));
    public static final ForgeType FORGE_MUSHROOM = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.MUSHROOM));
    public static final ForgeType FORGE_MAGICAL = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.MAGICAL));
    public static final ForgeType FORGE_RARE = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.RARE));
    public static final ForgeType FORGE_PLATEAU = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.PLATEAU));
    public static final ForgeType FORGE_MODIFIED = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.MODIFIED));
    public static final ForgeType FORGE_OCEAN = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.OCEAN));
    public static final ForgeType FORGE_RIVER = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.RIVER));
    public static final ForgeType FORGE_WATER = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.WATER));
    public static final ForgeType FORGE_MESA = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.MESA));
    public static final ForgeType FORGE_FOREST = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.FOREST));
    public static final ForgeType FORGE_PLAINS = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.PLAINS));
    public static final ForgeType FORGE_MOUNTAIN = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.MOUNTAIN));
    public static final ForgeType FORGE_HILLS = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.HILLS));
    public static final ForgeType FORGE_SWAMP = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.SWAMP));
    public static final ForgeType FORGE_SANDY = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.SANDY));
    public static final ForgeType FORGE_SNOWY = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.SNOWY));
    public static final ForgeType FORGE_WASTELAND = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.WASTELAND));
    public static final ForgeType FORGE_BEACH = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.BEACH));
    public static final ForgeType FORGE_VOID = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.VOID));
    public static final ForgeType FORGE_OVERWORLD = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.OVERWORLD));
    public static final ForgeType FORGE_NETHER = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.NETHER));
    public static final ForgeType FORGE_END = BiomeDictionary.register(ForgeType.create(BiomeDictionary.Type.END));

    public static void init() {
        if (!REGISTRY.containsKey(EMPTY_NAME)) {
            REGISTRY.register((IForgeRegistryEntry)EMPTY);
        }
    }

    public static <T extends BiomeType> T register(T biomeType) {
        ResourceLocation key = biomeType.getRegistryName();
        if (biomeType.getRegistryName().equals((Object)EMPTY_NAME)) {
            StructureGelMod.logError("Registry failed: Attempted to register a biome dictionary entry under the name \"{}\". Don't do this!", EMPTY_NAME.toString());
            return biomeType;
        }
        BiomeType existing = (BiomeType)REGISTRY.getValue(key);
        if (existing != null) {
            existing.biomes(biomeType.getBiomes()).parents(biomeType.getParents());
        } else {
            REGISTRY.register(biomeType);
        }
        BIOME_TO_BIOMETYPE_CACHE.clear();
        return biomeType;
    }

    public static void registerAll(BiomeType ... biomeTypes) {
        for (BiomeType type : biomeTypes) {
            BiomeDictionary.register(type);
        }
    }

    private static ForgeType register(ForgeType forgeType) {
        REGISTRY.register((IForgeRegistryEntry)forgeType);
        return forgeType;
    }

    public static List<BiomeType> getAllTypes(ResourceKey<Biome> biome) {
        return BiomeDictionary.getAllTypes(biome.m_135782_());
    }

    public static List<BiomeType> getAllTypes(Biome biome) {
        return BiomeDictionary.getAllTypes(biome.getRegistryName());
    }

    public static List<BiomeType> getAllTypes(ResourceLocation biome) {
        return BIOME_TO_BIOMETYPE_CACHE.computeIfAbsent(biome, b -> {
            ArrayList types = new ArrayList();
            REGISTRY.getValues().stream().filter(type -> type.getAllBiomes().stream().map(ResourceKey::m_135782_).anyMatch(arg_0 -> ((ResourceLocation)b).equals(arg_0))).forEach(type -> types.add(type));
            return types;
        });
    }

    @Internal
    public static void makeGuess() {
        HashMap<ResourceLocation, List> newlyRegistered = new HashMap<ResourceLocation, List>();
        HashMap<Biome.BiomeCategory, Function<Biome, BiomeType>> categoryToType = new HashMap<Biome.BiomeCategory, Function<Biome, BiomeType>>();
        categoryToType.put(Biome.BiomeCategory.TAIGA, b -> b.m_47530_() == Biome.Precipitation.SNOW ? SNOWY_SPRUCE_FOREST : SPRUCE_FOREST);
        categoryToType.put(Biome.BiomeCategory.EXTREME_HILLS, b -> b.m_47530_() == Biome.Precipitation.SNOW ? SNOWY_MOUNTAIN : MOUNTAIN);
        categoryToType.put(Biome.BiomeCategory.JUNGLE, b -> JUNGLE);
        categoryToType.put(Biome.BiomeCategory.MESA, b -> BADLANDS);
        categoryToType.put(Biome.BiomeCategory.PLAINS, b -> b.m_47530_() == Biome.Precipitation.SNOW ? SNOWY_PLAINS : PLAINS);
        categoryToType.put(Biome.BiomeCategory.SAVANNA, b -> SAVANNA);
        categoryToType.put(Biome.BiomeCategory.ICY, b -> SNOWY);
        categoryToType.put(Biome.BiomeCategory.THEEND, b -> FORGE_END);
        categoryToType.put(Biome.BiomeCategory.BEACH, b -> BEACH);
        categoryToType.put(Biome.BiomeCategory.FOREST, b -> WOODED);
        categoryToType.put(Biome.BiomeCategory.OCEAN, b -> b.m_47530_() == Biome.Precipitation.SNOW ? FROZEN_OCEAN : OCEAN);
        categoryToType.put(Biome.BiomeCategory.DESERT, b -> DESERT);
        categoryToType.put(Biome.BiomeCategory.RIVER, b -> RIVER);
        categoryToType.put(Biome.BiomeCategory.SWAMP, b -> SWAMP);
        categoryToType.put(Biome.BiomeCategory.MUSHROOM, b -> MUSHROOM);
        categoryToType.put(Biome.BiomeCategory.NETHER, b -> FORGE_NETHER);
        HashMap<BiomeDictionary.Type, Function<Biome, BiomeType>> forgeToType = new HashMap<BiomeDictionary.Type, Function<Biome, BiomeType>>();
        forgeToType.put(BiomeDictionary.Type.BEACH, b -> BEACH);
        forgeToType.put(BiomeDictionary.Type.CONIFEROUS, b -> CONIFEROUS_FOREST);
        forgeToType.put(BiomeDictionary.Type.DEAD, b -> DEAD);
        forgeToType.put(BiomeDictionary.Type.DRY, b -> DRY);
        forgeToType.put(BiomeDictionary.Type.FOREST, b -> WOODED);
        forgeToType.put(BiomeDictionary.Type.HOT, b -> HOT);
        forgeToType.put(BiomeDictionary.Type.JUNGLE, b -> JUNGLE);
        forgeToType.put(BiomeDictionary.Type.MAGICAL, b -> MAGICAL);
        forgeToType.put(BiomeDictionary.Type.MESA, b -> BADLANDS);
        forgeToType.put(BiomeDictionary.Type.MOUNTAIN, b -> b.m_47530_() == Biome.Precipitation.SNOW ? SNOWY_MOUNTAIN : MOUNTAIN);
        forgeToType.put(BiomeDictionary.Type.MUSHROOM, b -> MUSHROOM);
        forgeToType.put(BiomeDictionary.Type.OCEAN, b -> b.m_47530_() == Biome.Precipitation.SNOW ? FROZEN_OCEAN : OCEAN);
        forgeToType.put(BiomeDictionary.Type.PLAINS, b -> b.m_47530_() == Biome.Precipitation.SNOW ? SNOWY_PLAINS : PLAINS);
        forgeToType.put(BiomeDictionary.Type.RARE, b -> RARE);
        forgeToType.put(BiomeDictionary.Type.RIVER, b -> RIVER);
        forgeToType.put(BiomeDictionary.Type.SANDY, b -> SANDY);
        forgeToType.put(BiomeDictionary.Type.SAVANNA, b -> SAVANNA);
        forgeToType.put(BiomeDictionary.Type.SNOWY, b -> SNOWY);
        forgeToType.put(BiomeDictionary.Type.SPOOKY, b -> SPOOKY);
        forgeToType.put(BiomeDictionary.Type.SWAMP, b -> SWAMP);
        forgeToType.put(BiomeDictionary.Type.VOID, b -> VOID);
        forgeToType.put(BiomeDictionary.Type.WASTELAND, b -> DEAD);
        HashMap<String, BiomeType> nameToType = new HashMap<String, BiomeType>();
        nameToType.put("frozen", FROZEN);
        nameToType.put("snowy", SNOWY);
        nameToType.put("redwood", REDWOOD_FOREST);
        nameToType.put("coniferous", CONIFEROUS_FOREST);
        nameToType.put("bamboo", BAMBOO);
        nameToType.put("flower", FLOWERY);
        nameToType.put("tulip", FLOWERY);
        nameToType.put("orchid", FLOWERY);
        nameToType.put("dandelion", FLOWERY);
        nameToType.put("allium", FLOWERY);
        nameToType.put("poppy", FLOWERY);
        nameToType.put("daisy", FLOWERY);
        nameToType.put("lilac", FLOWERY);
        nameToType.put("peony", FLOWERY);
        nameToType.put("lavender", FLOWERY);
        nameToType.put("ocean", OCEAN);
        nameToType.put("river", RIVER);
        nameToType.put("beach", BEACH);
        nameToType.put("shroom", MUSHROOM);
        nameToType.put("fungal", FUNGAL);
        nameToType.put("seasonal", AUTUMN_FOREST);
        nameToType.put("autumn", AUTUMN_FOREST);
        nameToType.put("tropic", TROPICAL);
        nameToType.put("cave", CAVE);
        List<? extends String> ignoredMods = SGConfig.COMMON.getIgnoredMods();
        String hot = "hot";
        String warm = "warm";
        String frozen = "frozen";
        String cold = "cold";
        ForgeRegistries.BIOMES.getValues().stream().filter(biome -> !ignoredMods.contains(biome.getRegistryName().m_135827_())).filter(biome -> !BiomeDictionary.getAllTypes(biome).stream().filter(type -> !(type instanceof ForgeType)).findAny().isPresent()).forEach(biome -> {
            BlockState topMaterial;
            ResourceLocation registryName;
            if (categoryToType.containsKey(biome.m_47567_())) {
                ((BiomeType)((Function)categoryToType.get(biome.m_47567_())).apply(biome)).biome((Biome)biome);
            }
            if ((registryName = biome.getRegistryName()) != null) {
                String name = registryName.m_135815_();
                float t = biome.m_47554_();
                if (t <= 0.05f) {
                    if (!name.contains(hot) && !name.contains(warm)) {
                        SNOWY.biome((Biome)biome);
                    }
                } else if (t <= 0.25f) {
                    if (!name.contains(hot) && !name.contains(warm)) {
                        COLD.biome((Biome)biome);
                    }
                } else if (t <= 1.0f) {
                    NEUTRAL_TEMP.biome((Biome)biome);
                } else if (t <= 1.5f) {
                    if (!name.contains(frozen) && !name.contains(cold)) {
                        WARM.biome((Biome)biome);
                    }
                } else if (!name.contains(frozen) && !name.contains(cold)) {
                    HOT.biome((Biome)biome);
                }
                if (biome.m_47533_()) {
                    HUMID.biome((Biome)biome);
                }
                switch (biome.m_47530_()) {
                    case NONE: {
                        if (!(biome.m_47545_() > 0.0f)) break;
                        DRY.biome((Biome)biome);
                        break;
                    }
                    case SNOW: {
                        SNOWY.biome((Biome)biome);
                        break;
                    }
                }
                net.minecraftforge.common.BiomeDictionary.getTypes((ResourceKey)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)registryName)).forEach(type -> {
                    Function biomeTypeGetter = (Function)forgeToType.get(type);
                    if (biomeTypeGetter != null) {
                        ((BiomeType)biomeTypeGetter.apply(biome)).biome((Biome)biome);
                    }
                });
                nameToType.forEach((string, type) -> {
                    if (name.contains((CharSequence)string)) {
                        type.biome((Biome)biome);
                    }
                });
            }
            if ((topMaterial = biome.m_47536_().m_47824_().m_6743_()).m_60767_() == Material.f_76317_) {
                SANDY.biome((Biome)biome);
            }
            if (topMaterial.m_60767_() == Material.f_76314_) {
                DIRTY.biome((Biome)biome);
            }
            if (topMaterial.m_60734_() instanceof GravelBlock) {
                GRAVELLY.biome((Biome)biome);
            }
            newlyRegistered.put(registryName, BiomeDictionary.getAllTypes(biome));
        });
        BIOME_TO_BIOMETYPE_CACHE.clear();
        newlyRegistered.forEach((name, types) -> {
            List nonForgeTypes = types.stream().filter(type -> !(type instanceof ForgeType)).collect(Collectors.toList());
            if (nonForgeTypes.size() > 0) {
                StructureGelMod.log("Registered {} to [{}]", name, String.join((CharSequence)", ", nonForgeTypes.stream().map(type -> type.getRegistryName().toString()).sorted().collect(Collectors.toSet())));
            }
        });
    }
}

