/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds;

import com.google.common.base.Strings;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.fmlclient.gui.GuiUtils;
import team.creative.ambientsounds.AmbientDimension;
import team.creative.ambientsounds.AmbientEngine;
import team.creative.ambientsounds.AmbientEnviroment;
import team.creative.ambientsounds.AmbientRegion;
import team.creative.ambientsounds.AmbientSound;
import team.creative.ambientsounds.AmbientSoundEngine;
import team.creative.ambientsounds.AmbientSounds;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.common.config.holder.ConfigHolderDynamic;
import team.creative.creativecore.common.config.holder.CreativeConfigRegistry;
import team.creative.creativecore.common.config.sync.ConfigSynchronization;
import team.creative.creativecore.common.util.type.Pair;

public class AmbientTickHandler {
    private static Minecraft mc = Minecraft.m_91087_();
    public AmbientSoundEngine soundEngine;
    public AmbientEnviroment enviroment = null;
    public AmbientEngine engine;
    public int timer = 0;
    public boolean showDebugInfo = false;
    private static DecimalFormat df = new DecimalFormat("0.##");

    public void setEngine(AmbientEngine engine) {
        this.engine = engine;
        this.initConfiguration();
    }

    public void initConfiguration() {
        CreativeConfigRegistry.ROOT.removeField("ambientsounds");
        if (this.engine == null) {
            return;
        }
        ConfigHolderDynamic holder = CreativeConfigRegistry.ROOT.registerFolder("ambientsounds", ConfigSynchronization.CLIENT);
        ConfigHolderDynamic sounds = holder.registerFolder("sounds");
        Field soundField = ObfuscationReflectionHelper.findField(AmbientSound.class, (String)"volumeSetting");
        for (Map.Entry<String, AmbientRegion> pair : this.engine.allRegions.entrySet()) {
            if (pair.getValue().sounds == null) continue;
            for (AmbientSound sound : pair.getValue().sounds.values()) {
                sounds.registerField(pair.getKey() + "." + sound.name, soundField, (Object)sound);
            }
        }
        ConfigHolderDynamic dimensions = holder.registerFolder("dimensions");
        Field dimensionField = ObfuscationReflectionHelper.findField(AmbientDimension.class, (String)"volumeSetting");
        for (AmbientDimension dimension : this.engine.dimensions.values()) {
            dimensions.registerField(dimension.name, dimensionField, (Object)dimension);
        }
        holder.registerField("silent-dimensions", ObfuscationReflectionHelper.findField(AmbientEngine.class, (String)"silentDimensions"), (Object)this.engine);
        holder.registerValue("general", (Object)AmbientSounds.CONFIG);
        CreativeCore.CONFIG_HANDLER.load("ambientsounds", Dist.CLIENT);
    }

    private String format(Object value) {
        if (value instanceof Double || value instanceof Float) {
            return df.format(value);
        }
        return value.toString();
    }

    private String format(List<Pair<String, Object>> details) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (Pair<String, Object> pair : details) {
            if (!first) {
                builder.append(",");
            } else {
                first = false;
            }
            builder.append(ChatFormatting.YELLOW + (String)pair.key + ChatFormatting.RESET + ":" + this.format(pair.value));
        }
        return builder.toString();
    }

    @SubscribeEvent
    public void onRender(TickEvent.RenderTickEvent event) {
        if (this.showDebugInfo && event.phase == TickEvent.Phase.END && this.engine != null && !mc.m_91104_() && this.enviroment != null && AmbientTickHandler.mc.f_91073_ != null) {
            ArrayList<String> list = new ArrayList<String>();
            AmbientDimension dimension = this.engine.getDimension((Level)AmbientTickHandler.mc.f_91073_);
            ArrayList<Pair<String, Object>> details = new ArrayList<Pair<String, Object>>();
            details.add(new Pair((Object)"", (Object)(this.engine.name + " v" + this.engine.version)));
            details.add(new Pair((Object)"night", (Object)this.enviroment.night));
            details.add(new Pair((Object)"rain", (Object)this.enviroment.raining));
            details.add(new Pair((Object)"worldRain", (Object)this.enviroment.overallRaining));
            details.add(new Pair((Object)"snow", (Object)this.enviroment.snowing));
            details.add(new Pair((Object)"storm", (Object)this.enviroment.thundering));
            details.add(new Pair((Object)"b-volume", (Object)this.enviroment.biomeVolume));
            details.add(new Pair((Object)"underwater", (Object)this.enviroment.underwater));
            details.add(new Pair((Object)"dim-name", (Object)AmbientTickHandler.mc.f_91073_.m_46472_().m_135782_()));
            list.add(this.format(details));
            details.clear();
            for (Map.Entry<AmbientEnviroment.BiomeArea, Float> pair : this.enviroment.biomes.entrySet()) {
                details.add((Pair<String, Object>)new Pair((Object)pair.getKey().biome.m_47567_().m_47645_(), (Object)pair.getValue()));
            }
            list.add(this.format(details));
            details.clear();
            details.add((Pair<String, Object>)new Pair((Object)"dimension", (Object)dimension));
            details.add((Pair<String, Object>)new Pair((Object)"playing", (Object)this.engine.soundEngine.playingCount()));
            details.add((Pair<String, Object>)new Pair((Object)"light", (Object)this.enviroment.blocks.averageLight));
            details.add((Pair<String, Object>)new Pair((Object)"outside", (Object)this.enviroment.blocks.outsideVolume));
            details.add((Pair<String, Object>)new Pair((Object)"height", (Object)(df.format(this.enviroment.relativeHeight) + "," + df.format(this.enviroment.averageHeight) + "," + df.format(this.enviroment.player.m_20188_() - (double)this.enviroment.minHeight) + "," + df.format(this.enviroment.player.m_20188_() - (double)this.enviroment.maxHeight))));
            list.add(this.format(details));
            details.clear();
            for (AmbientRegion region : this.engine.activeRegions) {
                details.add((Pair<String, Object>)new Pair((Object)"region", (Object)(ChatFormatting.DARK_GREEN + region.name + ChatFormatting.RESET)));
                details.add((Pair<String, Object>)new Pair((Object)"playing", (Object)region.playing.size()));
                list.add(this.format(details));
                details.clear();
                for (AmbientSound sound : region.playing) {
                    if (!sound.isPlaying()) continue;
                    Object text = "";
                    if (sound.stream1 != null) {
                        details.add((Pair<String, Object>)new Pair((Object)"n", (Object)sound.stream1.location));
                        details.add((Pair<String, Object>)new Pair((Object)"v", (Object)sound.stream1.volume));
                        details.add((Pair<String, Object>)new Pair((Object)"i", (Object)sound.stream1.index));
                        details.add((Pair<String, Object>)new Pair((Object)"p", (Object)sound.stream1.pitch));
                        details.add((Pair<String, Object>)new Pair((Object)"t", (Object)sound.stream1.ticksPlayed));
                        details.add((Pair<String, Object>)new Pair((Object)"d", (Object)sound.stream1.duration));
                        text = "[" + this.format(details) + "]";
                        details.clear();
                    }
                    if (sound.stream2 != null) {
                        details.add((Pair<String, Object>)new Pair((Object)"n", (Object)sound.stream2.location));
                        details.add((Pair<String, Object>)new Pair((Object)"v", (Object)sound.stream2.volume));
                        details.add((Pair<String, Object>)new Pair((Object)"i", (Object)sound.stream2.index));
                        details.add((Pair<String, Object>)new Pair((Object)"p", (Object)sound.stream2.pitch));
                        details.add((Pair<String, Object>)new Pair((Object)"t", (Object)sound.stream2.ticksPlayed));
                        details.add((Pair<String, Object>)new Pair((Object)"d", (Object)sound.stream2.duration));
                        text = (String)text + "[" + this.format(details) + "]";
                        details.clear();
                    }
                    list.add((String)text);
                }
            }
            for (int i = 0; i < list.size(); ++i) {
                String s = (String)list.get(i);
                if (Strings.isNullOrEmpty((String)s)) continue;
                Objects.requireNonNull(AmbientTickHandler.mc.f_91062_);
                int j = 9;
                int k = AmbientTickHandler.mc.f_91062_.m_92895_(s);
                int i1 = 2 + j * i;
                PoseStack mat = new PoseStack();
                GuiUtils.drawGradientRect((Matrix4f)mat.m_85850_().m_85861_(), (int)0, (int)1, (int)(i1 - 1), (int)(2 + k + 1), (int)(i1 + j - 1), (int)-1873784752, (int)-1873784752);
                AmbientTickHandler.mc.f_91062_.m_92750_(mat, s, 2.0f, (float)i1, 0xE0E0E0);
            }
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            if (this.soundEngine == null) {
                this.soundEngine = new AmbientSoundEngine(mc.m_91106_(), AmbientTickHandler.mc.f_91066_);
                if (this.engine == null) {
                    this.setEngine(AmbientEngine.loadAmbientEngine(this.soundEngine));
                }
                if (this.engine != null) {
                    this.engine.soundEngine = this.soundEngine;
                }
            }
            if (this.engine == null) {
                return;
            }
            ClientLevel level = AmbientTickHandler.mc.f_91073_;
            LocalPlayer player = AmbientTickHandler.mc.f_91074_;
            if (level != null && player != null && !mc.m_91104_() && AmbientTickHandler.mc.f_91066_.m_92147_(SoundSource.AMBIENT) > 0.0f) {
                AmbientDimension newDimension;
                if (this.enviroment == null) {
                    this.enviroment = new AmbientEnviroment((Player)player);
                }
                if (this.enviroment.dimension != (newDimension = this.engine.getDimension((Level)level))) {
                    this.engine.changeDimension(this.enviroment, newDimension);
                    this.enviroment.dimension = newDimension;
                }
                if (this.timer % this.engine.enviromentTickTime == 0) {
                    this.enviroment.level = level;
                    this.enviroment.player = player;
                    this.enviroment.biomeVolume = 1.0;
                    this.enviroment.setHeight(this.engine.calculateAverageHeight((Level)level, (Player)player));
                    this.enviroment.biomeVolume = 1.0;
                    if (this.enviroment.dimension != null) {
                        this.enviroment.dimension.manipulateEnviroment(this.enviroment);
                    }
                    if (this.enviroment.biomeVolume > 0.0) {
                        this.enviroment.biomes = this.engine.calculateBiomes((Level)level, (Player)player, this.enviroment.biomeVolume);
                    } else if (this.enviroment.biomes != null) {
                        this.enviroment.biomes.clear();
                    } else {
                        this.enviroment.biomes = new LinkedHashMap();
                    }
                    this.enviroment.blocks.updateAllDirections(this.engine);
                }
                if (this.timer % this.engine.soundTickTime == 0) {
                    this.enviroment.setSunAngle((float)Math.toDegrees(level.m_46490_(mc.m_91297_())));
                    this.enviroment.updateLevel();
                    int depth = 0;
                    if (player.m_19941_((Tag)FluidTags.f_13131_)) {
                        BlockPos blockpos = new BlockPos((Vec3i)player.m_142538_()).m_7494_();
                        while (level.m_8055_(blockpos).m_60767_() == Material.f_76305_) {
                            ++depth;
                            blockpos = blockpos.m_7494_();
                        }
                        --depth;
                    }
                    this.enviroment.setUnderwater(depth);
                    this.engine.tick(this.enviroment);
                }
                this.engine.fastTick(this.enviroment);
                ++this.timer;
            } else if (!this.engine.activeRegions.isEmpty()) {
                this.engine.stopEngine();
            }
        }
    }
}

