/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds;

import com.google.common.base.Charsets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.io.IOUtils;
import team.creative.ambientsounds.AmbientConfig;
import team.creative.ambientsounds.AmbientDimension;
import team.creative.ambientsounds.AmbientEnviroment;
import team.creative.ambientsounds.AmbientRegion;
import team.creative.ambientsounds.AmbientSound;
import team.creative.ambientsounds.AmbientSoundEngine;
import team.creative.ambientsounds.AmbientSounds;

public class AmbientEngine {
    public static final ResourceLocation CONFIG_LOCATION = new ResourceLocation("ambientsounds", "config.json");
    public static final String ENGINE_LOCATION = "engine.json";
    public static final String DIMENSIONS_LOCATION = "dimensions.json";
    public static final String REGIONS_LOCATION = "regions.json";
    public static final String SOUNDS_LOCATION = "sounds.json";
    private static final JsonParser parser = new JsonParser();
    private static final Gson gson = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new JsonDeserializer<ResourceLocation>(){

        public ResourceLocation deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isString()) {
                return new ResourceLocation(json.getAsString());
            }
            return null;
        }
    }).create();
    protected transient LinkedHashMap<String, AmbientDimension> dimensions = new LinkedHashMap();
    protected transient LinkedHashMap<String, AmbientRegion> allRegions = new LinkedHashMap();
    protected transient LinkedHashMap<String, AmbientRegion> generalRegions = new LinkedHashMap();
    protected transient List<AmbientRegion> activeRegions = new ArrayList<AmbientRegion>();
    protected transient LinkedHashMap<String, AmbientSound> sounds = new LinkedHashMap();
    protected transient List<String> silentDimensions = new ArrayList<String>();
    protected transient AmbientSoundEngine soundEngine;
    protected transient AmbientDimension silentDim;
    public String name;
    public String version;
    @SerializedName(value="enviroment-tick-time")
    public int enviromentTickTime = 40;
    @SerializedName(value="sound-tick-time")
    public int soundTickTime = 4;
    @SerializedName(value="block-scan-distance")
    public int blockScanDistance = 40;
    @SerializedName(value="outside-distance-min")
    public int outsideDistanceMin = 2;
    @SerializedName(value="outside-distance-max")
    public int outsideDistanceMax = 13;
    @SerializedName(value="average-height-scan-distance")
    public int averageHeightScanDistance = 2;
    @SerializedName(value="average-height-scan-count")
    public int averageHeightScanCount = 5;
    @SerializedName(value="biome-scan-distance")
    public int biomeScanDistance = 5;
    @SerializedName(value="biome-scan-count")
    public int biomeScanCount = 3;

    public static AmbientEngine attemptToLoadEngine(AmbientSoundEngine soundEngine, ResourceManager manager, String name) throws Exception {
        int i;
        AmbientEngine engine = (AmbientEngine)gson.fromJson((JsonElement)parser.parse(IOUtils.toString((InputStream)manager.m_142591_(new ResourceLocation("ambientsounds", name + "/engine.json")).m_6679_(), (Charset)Charsets.UTF_8)).getAsJsonObject(), AmbientEngine.class);
        if (!engine.name.equals(name)) {
            throw new Exception("Invalid engine name");
        }
        for (Resource resource : manager.m_7396_(new ResourceLocation("ambientsounds", name + "/dimensions.json"))) {
            AmbientDimension[] dimensions = (AmbientDimension[])gson.fromJson(parser.parse(IOUtils.toString((InputStream)resource.m_6679_(), (Charset)Charsets.UTF_8)), AmbientDimension[].class);
            for (i = 0; i < dimensions.length; ++i) {
                AmbientDimension dimension = dimensions[i];
                if (dimension.name == null || dimension.name.isEmpty()) {
                    AmbientSounds.LOGGER.error("Found invalid dimensions at {}", (Object)i);
                }
                engine.dimensions.put(dimension.name, dimension);
                dimension.load(engine, gson, parser, manager);
                for (AmbientRegion region : dimension.regions.values()) {
                    if (!engine.checkRegion(dimension, i, region)) continue;
                    engine.addRegion(region);
                }
            }
        }
        for (Resource resource : manager.m_7396_(new ResourceLocation("ambientsounds", name + "/regions.json"))) {
            AmbientRegion[] regions = (AmbientRegion[])gson.fromJson(parser.parse(IOUtils.toString((InputStream)resource.m_6679_(), (Charset)Charsets.UTF_8)), AmbientRegion[].class);
            for (i = 0; i < regions.length; ++i) {
                AmbientRegion region = regions[i];
                if (!engine.checkRegion(null, i, region)) continue;
                engine.generalRegions.put(region.name, region);
                region.load(engine, gson, parser, manager);
                engine.addRegion(region);
            }
        }
        engine.silentDim = new AmbientDimension();
        engine.silentDim.name = "silent";
        engine.silentDim.volumeSetting = 0.0;
        engine.silentDim.mute = true;
        engine.init();
        engine.soundEngine = soundEngine;
        AmbientSounds.LOGGER.info("Loaded AmbientEngine '{}' v{}. {} dimension(s), {} region(s) and {} sound(s)", (Object)engine.name, (Object)engine.version, (Object)engine.dimensions.size(), (Object)engine.allRegions.size(), (Object)engine.sounds.size());
        return engine;
    }

    public static AmbientEngine loadAmbientEngine(AmbientSoundEngine soundEngine) {
        try {
            ResourceManager manager = Minecraft.m_91087_().m_91098_();
            AmbientConfig config = (AmbientConfig)gson.fromJson((JsonElement)parser.parse(IOUtils.toString((InputStream)manager.m_142591_(CONFIG_LOCATION).m_6679_(), (Charset)Charsets.UTF_8)).getAsJsonObject(), AmbientConfig.class);
            if (!AmbientSounds.CONFIG.engine.equalsIgnoreCase("default")) {
                try {
                    return AmbientEngine.attemptToLoadEngine(soundEngine, manager, AmbientSounds.CONFIG.engine);
                }
                catch (Exception e) {
                    AmbientSounds.LOGGER.error("Sound engine {} could not be loaded", (Object)AmbientSounds.CONFIG.engine);
                    e.printStackTrace();
                }
            }
            try {
                return AmbientEngine.attemptToLoadEngine(soundEngine, manager, config.defaultEngine);
            }
            catch (Exception e) {
                AmbientSounds.LOGGER.error("Sound engine {} could not be loaded", (Object)AmbientSounds.CONFIG.engine);
                e.printStackTrace();
                throw new Exception();
            }
        }
        catch (Exception e) {
            AmbientSounds.LOGGER.error("Not sound engine could be loaded, no sounds will be played!");
            return null;
        }
    }

    public AmbientRegion getRegion(String name) {
        return this.allRegions.get(name);
    }

    protected boolean checkRegion(AmbientDimension dimension, int i, AmbientRegion region) {
        if (region.name == null || region.name.isEmpty()) {
            if (dimension == null) {
                AmbientSounds.LOGGER.error("Found invalid region at {}", (Object)i);
            } else {
                AmbientSounds.LOGGER.error("Found invalid region in '{}' at {}", (Object)dimension.name, (Object)i);
            }
            return false;
        }
        return true;
    }

    protected void addRegion(AmbientRegion region) {
        this.allRegions.put(region.name, region);
        region.volumeSetting = 1.0;
        String prefix = (String)(region.dimension != null ? region.dimension.name + "." : "") + region.name + ".";
        if (region.sounds != null) {
            for (AmbientSound sound : region.sounds.values()) {
                this.sounds.put(prefix + sound.name, sound);
                sound.fullName = prefix + sound.name;
                sound.volumeSetting = 1.0;
            }
        }
    }

    public AmbientDimension getDimension(Level level) {
        String dimensionTypeName = level.m_46472_().m_135782_().toString();
        if (this.silentDimensions.contains(dimensionTypeName)) {
            return this.silentDim;
        }
        for (AmbientDimension dimension : this.dimensions.values()) {
            if (!dimension.is(level)) continue;
            return dimension;
        }
        return this.silentDim;
    }

    public void stopEngine() {
        if (!this.activeRegions.isEmpty()) {
            for (AmbientRegion region : this.activeRegions) {
                region.deactivate();
            }
            this.activeRegions.clear();
        }
    }

    public void init() {
        for (AmbientDimension dimension : this.dimensions.values()) {
            dimension.init(this);
        }
        for (AmbientRegion region : this.allRegions.values()) {
            region.init(this);
        }
    }

    public void tick(AmbientEnviroment env) {
        if (env.dimension.regions != null) {
            for (AmbientRegion region : env.dimension.regions.values()) {
                if (region.tick(env)) {
                    if (region.isActive()) continue;
                    region.activate();
                    this.activeRegions.add(region);
                    continue;
                }
                if (!region.isActive()) continue;
                region.deactivate();
                this.activeRegions.remove(region);
            }
        }
        for (AmbientRegion region : this.generalRegions.values()) {
            if (region.tick(env)) {
                if (region.isActive()) continue;
                region.activate();
                this.activeRegions.add(region);
                continue;
            }
            if (!region.isActive()) continue;
            region.deactivate();
            this.activeRegions.remove(region);
        }
    }

    public void fastTick(AmbientEnviroment env) {
        this.soundEngine.tick();
        if (!this.activeRegions.isEmpty()) {
            Iterator<AmbientRegion> iterator = this.activeRegions.iterator();
            while (iterator.hasNext()) {
                AmbientRegion region = iterator.next();
                if (region.fastTick(env)) continue;
                region.deactivate();
                iterator.remove();
            }
        }
    }

    public void changeDimension(AmbientEnviroment env, AmbientDimension newDimension) {
        if (env.dimension == null || env.dimension.regions == null) {
            return;
        }
        for (AmbientRegion region : env.dimension.regions.values()) {
            if (!region.isActive()) continue;
            region.deactivate();
            this.activeRegions.remove(region);
        }
    }

    public AmbientEnviroment.TerrainHeight calculateAverageHeight(Level level, Player player) {
        int sum = 0;
        int count = 0;
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        BlockPos center = player.m_142538_();
        for (int x = -this.averageHeightScanCount; x <= this.averageHeightScanCount; ++x) {
            for (int z = -this.averageHeightScanCount; z <= this.averageHeightScanCount; ++z) {
                pos.m_122178_(center.m_123341_() + this.averageHeightScanDistance * x, center.m_123342_(), center.m_123343_() + this.averageHeightScanDistance * z);
                int height = AmbientEngine.getHeightBlock(level, pos);
                min = Math.min(height, min);
                max = Math.max(height, max);
                sum += height;
                ++count;
            }
        }
        return new AmbientEnviroment.TerrainHeight((double)sum / (double)count, min, max);
    }

    public LinkedHashMap<AmbientEnviroment.BiomeArea, Float> calculateBiomes(Level level, Player player, double volume) {
        LinkedHashMap<AmbientEnviroment.BiomeArea, Float> biomes = new LinkedHashMap<AmbientEnviroment.BiomeArea, Float>();
        if (volume > 0.0) {
            int posX = (int)player.m_20185_();
            int posZ = (int)player.m_20189_();
            BlockPos center = new BlockPos(posX, 0, posZ);
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            for (int x = -this.biomeScanCount; x <= this.biomeScanCount; ++x) {
                for (int z = -this.biomeScanCount; z <= this.biomeScanCount; ++z) {
                    pos.m_122178_(posX + x * this.biomeScanDistance, 0, posZ + z * this.biomeScanDistance);
                    Biome biome = level.m_46857_((BlockPos)pos);
                    float biomeVolume = (float)((1.0 - Math.sqrt(center.m_123331_((Vec3i)pos)) / (double)(this.biomeScanCount * this.biomeScanDistance * 2)) * volume);
                    AmbientEnviroment.BiomeArea area = new AmbientEnviroment.BiomeArea(biome, (BlockPos)pos);
                    Float before = biomes.get(area);
                    if (before == null) {
                        before = Float.valueOf(0.0f);
                    }
                    biomes.put(area, Float.valueOf(Math.max(before.floatValue(), biomeVolume)));
                }
            }
            ArrayList<Map.Entry<AmbientEnviroment.BiomeArea, Float>> entries = new ArrayList<Map.Entry<AmbientEnviroment.BiomeArea, Float>>(biomes.entrySet());
            Collections.sort(entries, new Comparator<Map.Entry<AmbientEnviroment.BiomeArea, Float>>(){

                @Override
                public int compare(Map.Entry<AmbientEnviroment.BiomeArea, Float> o1, Map.Entry<AmbientEnviroment.BiomeArea, Float> o2) {
                    return o1.getValue().compareTo(o2.getValue());
                }
            });
            biomes = new LinkedHashMap();
            for (Map.Entry entry : entries) {
                biomes.put((AmbientEnviroment.BiomeArea)entry.getKey(), (Float)entry.getValue());
            }
        }
        return biomes;
    }

    public static int getHeightBlock(Level world, BlockPos.MutableBlockPos pos) {
        int heighest = 0;
        for (int y = 256; y > 0; --y) {
            pos.m_142448_(y);
            BlockState state = world.m_8055_((BlockPos)pos);
            if ((!state.m_60804_((BlockGetter)world, (BlockPos)pos) || state.m_60734_() instanceof LeavesBlock) && !state.m_60713_(Blocks.f_49990_)) continue;
            heighest = y;
            break;
        }
        return heighest;
    }
}

