/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds;

import com.google.common.base.Charsets;
import com.google.gson.Gson;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.Level;
import org.apache.commons.io.IOUtils;
import team.creative.ambientsounds.AmbientCondition;
import team.creative.ambientsounds.AmbientEngine;
import team.creative.ambientsounds.AmbientEnviroment;
import team.creative.ambientsounds.AmbientRegion;
import team.creative.ambientsounds.AmbientSelection;
import team.creative.creativecore.common.config.api.CreativeConfig;

public class AmbientDimension {
    @CreativeConfig.DecimalRange(min=0.0, max=1.0)
    public transient double volumeSetting = 1.0;
    public transient HashMap<String, AmbientRegion> regions = new HashMap();
    public String name;
    public boolean mute = false;
    @SerializedName(value="biome-selector")
    public AmbientCondition biomeSelector;
    public Boolean night;
    public Boolean rain;
    public Boolean storm;
    @SerializedName(value="dimension-names")
    public String[] dimensionNames;
    @SerializedName(value="bad-dimension-names")
    public String[] badDimensionNames;
    @SerializedName(value="average-height")
    public Integer averageHeight;

    public void load(AmbientEngine engine, Gson gson, JsonParser parser, ResourceManager manager) throws IOException {
        for (Resource resource : manager.m_7396_(new ResourceLocation("ambientsounds", engine.name + "/dimension_regions/" + this.name + ".json"))) {
            AmbientRegion[] regions = (AmbientRegion[])gson.fromJson(parser.parse(IOUtils.toString((InputStream)resource.m_6679_(), (Charset)Charsets.UTF_8)), AmbientRegion[].class);
            for (int j = 0; j < regions.length; ++j) {
                AmbientRegion region = regions[j];
                region.dimension = this;
                this.regions.put(region.name, region);
                region.load(engine, gson, parser, manager);
            }
        }
    }

    public void init(AmbientEngine engine) {
        int i;
        if (this.biomeSelector != null) {
            this.biomeSelector.init(engine);
        }
        if (this.badDimensionNames != null) {
            for (i = 0; i < this.badDimensionNames.length; ++i) {
                this.badDimensionNames[i] = ".*" + this.badDimensionNames[i].toLowerCase().replace("*", ".*").replace("?", "\\?") + ".*";
            }
        }
        if (this.dimensionNames != null) {
            for (i = 0; i < this.dimensionNames.length; ++i) {
                this.dimensionNames[i] = ".*" + this.dimensionNames[i].toLowerCase().replace("*", ".*").replace("?", "\\?") + ".*";
            }
        }
    }

    public boolean is(Level level) {
        int j;
        String dimensionTypeName = level.m_46472_().m_135782_().toString();
        if (this.badDimensionNames != null) {
            for (j = 0; j < this.badDimensionNames.length; ++j) {
                if (!dimensionTypeName.matches(this.badDimensionNames[j])) continue;
                return false;
            }
        }
        if (this.dimensionNames != null) {
            for (j = 0; j < this.dimensionNames.length; ++j) {
                if (!dimensionTypeName.matches(this.dimensionNames[j])) continue;
                return true;
            }
        }
        return this.dimensionNames == null;
    }

    public void manipulateEnviroment(AmbientEnviroment env) {
        env.soundsDisabled = this.mute;
        if (this.night != null) {
            env.night = this.night;
        }
        if (this.rain != null) {
            env.raining = this.rain;
        }
        if (this.storm != null) {
            env.thundering = this.storm;
        }
        if (this.biomeSelector != null) {
            AmbientSelection selection = this.biomeSelector.value(env);
            env.biomeVolume = selection != null ? selection.getEntireVolume() : 0.0;
        }
        if (this.averageHeight != null) {
            env.setHeight(new AmbientEnviroment.TerrainHeight(this.averageHeight.intValue(), this.averageHeight, this.averageHeight));
        }
    }

    public String toString() {
        return this.name;
    }
}

